function K=CreateK(iM,iN,h)

%18.086 Final Project
%By Joseph Kovac
%Revised and submitted for OCW 9/12/05

%This function creates the properly designed K matrix for the grid size
%using the stencil in the paper
K=0*(speye((iM+2)^2));
NumRows=iM+2;
NumCols=iN+2;
stencil=[-1 zeros(1,NumRows-2) -1 4 -1 zeros(1,NumRows-2) -1]/h^2;
for X=1:NumRows^2
    if (floor(X/((NumRows+1)))==0) 
        K(X,X)=1;
    elseif (rem(X,NumRows)==0)
            K(X,X)=1;
        elseif (rem(X,NumRows)==1)
                K(X,X)=1;
            elseif ((X>=(NumRows^2-NumRows)) & (X<=NumRows^2))
                K(X,X)=1;
    else
        K(X,X-NumRows:X+NumRows)=stencil;
    end
end