function [RelaxedData, Residuals,ResNorm,DataFFT]=Relax(InputMatrix,BCPoints,steps,f,w,Level)

%18.086 Final Project
%By Joseph Kovac
%Revised and submitted for OCW 9/12/05

%InputMatrix is padded with boundary conditions
%f is size appropriate for padded matrix

%Set up K with proper bondary conditions
InteriorEdge=sqrt(prod(size(InputMatrix)))-2;% length of interior grid edge
K=CreateK(InteriorEdge,InteriorEdge,Level);%Create the proper K matrix for the 2nd derivate with explicit boundaries
K(BCPoints,:)=0;%Set rows with boundaries to zero except along diagonal; put 1 there

for a=1:prod(size(BCPoints));
    K(BCPoints(a),BCPoints(a))=1;
end

%Implement Jacobi relaxation
D=sparse(diag(diag(K)));
L=-1*sparse(1*tril(K,-1));
U=-1*sparse(1*triu(K,1));
Rj=D^-1*(L+U);
I=(speye((InteriorEdge+2)^2));
Rw=(1-w)*I+w*Rj;
v=InputMatrix(1:end)';

%Calculate the current norm of the residual
ResNorm=[];
for n=1:steps
    v=Rw*v+w*D^-1*f;
    ResNorm=[ResNorm norm(f-K*v)];
end
RelaxedData=WrapVector(v);
Residuals=f-K*v;