function [RelaxedData, Residuals, ResNorm]=RelaxResiduals(InputMatrix,steps,w,Level,InitGuess)

%18.086 Final Project
%By Joseph Kovac
%Revised and submitted for OCW 9/12/05

%InputMatrix is padded with boundary conditions
%f is size appropriate for padded matrix
%Set up K with proper bondary conditions
InteriorEdge=sqrt(prod(size(InputMatrix)))-2;
K=CreateK(InteriorEdge,InteriorEdge,Level);

%Relax the residual problem via Jacobi
D=sparse(diag(diag(K)));
L=-1*sparse(1*tril(K,-1));
U=-1*sparse(1*triu(K,1));
Rj=D^-1*(L+U);
I=(speye((InteriorEdge+2)^2));
Rw=(1-w)*I+w*Rj;
f=InputMatrix(1:end)';

%Incorporate a nonzero starting guess at the error if available
if (InitGuess==0)
    v=zeros((InteriorEdge+2)^2,1);
else
    v=InitGuess;
end

%Figure out the residual to the problem Ae=r
ResNorm=[];
for n=1:steps
    v=Rw*v+w*D^-1*f;
    ResNorm=[ResNorm norm(f-K*v)];
end
RelaxedData=WrapVector(v);
Residuals=f-K*v;