function [T,Y]=RockerRK(theta0)
% Solver for rolling half-disk
% with Runge-Kutta method
% Input argument: Initial conditions
% Output arguement: time and angle matrix

% Define some constants
r=1;            % radius of disk = 1m
rc=4*r/(3*pi);  % center of gravity
% Solve equation of motion with Runge-Kutta method
% theta0: initial conditions
% time: 0 to 10 second
[T,Y]=ode45(@(t,theta) Rocker(t,theta,r,rc),[0 10],theta0);
% extract only angle matrix
Y=Y(:,1);
end

function dTHETA=Rocker(t,theta,r,rc)
% descrive equation of motion for rolling half-disk

g=9.81;         % gravity
% angular velocity 
dTHETA(1,1)=theta(2);
% angular acceleration
dTHETA(2,1)=-(r*rc*theta(2)^2+g*rc)*sin(theta(1))/(3/2*r^2-2*rc*r*cos(theta(1)));
end
