function O=MSDSE(m,b,k,F0,w,x0,v0)
%
% Solver for Mass-Sprring-Damper System with Euler Method
% ----- Input argument -----
% m: mass for particle
% b: damping coefficient
% k: spring constant
% F0: amplitude of external force
% w: angular freuency of external force
% x0: initial condition for the position x(0)
% v0: initial condition for the velocity v(0)
% ----- Output argument -----
% t: time series with given time step from ti to tf.
% x: state variable matrix for corresponding time t matrix

% Define time step in Euler method
dt=0.1;
% Make time series with given time step
t=[0:dt:50]';
% Initialize output matrix
% the 1st column: the position of the particle
% the 2nd column: the veleocity of the particle
x=zeros(length(t),2);
% the 1st row has initial conditions
x(1,:)=[x0 v0];
% Start the simulation with Euler method
for i=1:length(t)-1
    % Apply Euler method
    % x(n+1)=x(n)*v(n)*dt
    x(i+1,1,1)=x(i,1)+x(i,2)*dt;
    % v(n+1)=v(n)*a(n)*dt
    %where a(n)=1/m*(F0sin(wt)-bv(n)-kx(n))*dt
    x(i+1,2)=x(i,2)+(1/m)*(F0*sin(w*t(i))-b*x(i,2)-k*x(i,1))*dt;
end
% Extract only particle position trajectory
O=[t,x(:,1)];
end