function o=hanoi(n)
%
% Problem 5.2 Solve the tower of Hanoi with n different disks
%             with recursion algorithm
%
% Input argument n: number of disks
% Output argument o: solution matrix
%      The first column: post number which disk moves from
%      The second column: post number which disk moves to
%

% Number all the posts
sp=1;   % starting post are numbered to '1'
ep=3;   % ending post are numbered to '3'
ip=2;   % intermediate post are numbered to '2'

% Calculate Hanoitower wirh reccursion
% Move all the disks on the leftmost side post to the rightmost side post
o=MoveTower(n,sp,ep,ip);


function o=MoveTower(n,sp,ep,ip)
% 
% The solution of whole n disk tower movement one post to the other post
% It can be also expressed with whole (n-1) disk tower movent
%
% n: number of disk in the start post
% a: start post number
% b: end post number
% c: immediate post number

% Define output matrix
o=[];

% if there is no disk, simply return without movement
% o is still empty
if n<=0, return; end

% Move whole disks except for the bottom one
% from starting post to temporary post
o=[o ; MoveTower(n-1,sp,ip,ep)];

% Move the remaining disk on starting post
% to ending post
o=[o ; sp ep];

% Move whole disks on the temporary post
% to ending post
o=[o ; MoveTower(n-1,ip,ep,sp)];