J=4.0;
f_v=2.0;
f_c=0.2;
T_0=2.0;
omega_0=0.0;
t_max=10.0;

[t,omega]=shaftcv_solve(J,f_v,f_c,T_0,t_max,omega_0);

figure(1)
plot(t,omega,'LineWidth',5)
ha=gca;
set(ha,'YLim',[0 1.25],'FontSize',24,'XGrid','on','YGrid','on',...
    'XTick',[0 2.0 4.0 6.0 8.0 10.0],...
    'YTick',[0 0.63*(T_0-f_c)/f_v (T_0-f_c)/f_v])
xlabel('t [sec]')
ylabel('\omega(t) [rad/sec]')
print -deps shaftcv.eps
print -dbmp shaftcv.bmp