% Parse the DasyLab2 ascii output into a matrix of the same format
% as stream.  SYNTAX:  
%[data] = dlmread(filename,delimiter('\t' for tab),toprownumber of data, leftmost column of data) ;
% Tadd Truscott 3-30-2005  

clear all;

name = input('What is .asc filename in directory:  ','s');
c = input('Which column of the data set would you like to average?');

M=dlmread(name,'\t',8,0);
time=M(:,1);

figure(1);clf;hold off;
plot(time,M(:,c));
xlabel('time, s');
ylabel('Column you chose, Volts');
title('Pick Zero range:');
zoom on; pause;
[x,y] = ginput(2);
a_time=abs(time-x(1));
b_time=abs(time-x(2));
[g(1),ind(1)]=min(a_time);
[g(2),ind(2)]=min(b_time);

a=mean(M(ind(1):ind(2),c));

disp(sprintf('average: %g volts',a));