% Parse the DasyLab2 IEEE32 output into a matrix of the same format
% as stream.  SYNTAX:  [data] = parsedl2(name,chans) ;

% Franz Hover 28 April 1997

function [s] = parsedl2(name,chans) ;

eval(['fid = fopen(name,''r'');']);
[sx] = fread(fid,inf,'float32');

n = length(sx)/chans ;
if round(n) ~= n,
        disp(' ');
        disp('-------------------------------------');
        disp('        ***** ABORTED *****');
        disp('Length of data vector is inconsistent');
        disp('      with number of channels!');
        disp('-------------------------------------');
        disp(' ');
        return ;
end;

for i=1:chans
     s(i,:) = sx(i:chans:length(sx))' ;
end;

fclose(fid);

%---------------------------------------------------------------
