%
% MATLAB script for plotting the directivity function for
% a pointdriven elastic plate
%
% Parameters
% f     Frequency
% rho   Density
% c     Speed of Sound
% h     Plate thickness
% E     Young's modulus
% nu    Poisson's ratio
% rhos Plate density
clear
rhos=7700;
cp=5600;
h=0.05;
E=rhos*cp^2;
nu=0.33;
D= E *h^3/(12*(1-nu^2));
rho=1000;
c=1500;
f=8000;
omega=2*pi*f;
k=omega/c

a=1.0;

ka=k*a;

figure(1);
hold off
kxm=2*ka;
nkx=300;
dkx=2*kxm/(nkx-1);
x=[-kxmdkxkxm];
y=x;
o=ones(1,nkx);
kx=x' * o;
ky=(y' *o)';
kr=abs(complex(kx,ky));
kf= ((rhos * h + i * rho ./sqrt(k^2-complex(kr,0.0).^2))* omega^2/D).^0.25; 
kfa=kf*a;

ss=-rho*omega^2./(D*(2*pi)^2 *(complex(kr,0).^4 -kfa.^4));
%surfc(kx,ky,dba(ss));
wavei(dba(ss)',x,y)
shading('flat')
axis('equal')
b=xlabel('k_x')
set(b,'FontSize',16);
b=ylabel('k_y')
set(b,'FontSize',16);
tit=['Point Driven Plate, h =' num2str(h) ', f = ' num2str(omega/(2*pi))]
b=title(tit);
set(b,'FontSize',20);
nphi=361;
dphi=2*pi/(nphi-1);
phi=[0dphi2*pi];
xx=k*a*cos(phi);
yy=k*a*sin(phi);
hold on
b=plot(xx,yy,'b');
set(b,'LineWidth',3);


figure(2) 
nphi=361.
dphi=2*pi/(nphi-1)
nth=181;
dth=0.5*pi/(nth-0.5);

phi=[0dphi(nphi-1)*dphi]' * ones(1,nth);
th=([dth/2dthpi/2]'*ones(1,nphi))';
kx=ka*sin(th).*cos(phi);
ky=ka*sin(th).*sin(phi);
kr=ka*sin(th);
kf= ((rhos * h + i * rho ./sqrt(k^2-complex(kr,0.0).^2))* omega^2/D).^0.25; 
kfa=kf*a;

ss=-rho*omega^2./(D*(2*pi)^2 *(complex(kr,0).^4 -kfa.^4));

ss=dba(ss);
sm=10.0*(ceil(0.1*max((max(ss))')));
for i=1size(ss,1)
     for j=1size(ss,2)
     ss(i,j)=max(ss(i,j),sm-40.0)-(sm-40.0);
end
end

xx=ss.*sin(th).*cos(phi);
yy=ss.*sin(th).*sin(phi);
zz=ss.*cos(th);

surfl(xx,yy,zz);
colormap('copper');
shading('flat');
axis('equal');
tit=['Point Driven Plate,  h =' num2str(h) ', f = ' num2str(omega/(2*pi)) ]
b=title(tit);
set(b,'FontSize',20);


figure(3)
b=polar([pi/2-fliplr(th(1,)) pi/2+th((nphi-1)/2+1,)],[fliplr(ss(1,)) ss((nphi-1)/2+1,)]); 
set(b,'LineWidth',2)
     b=legend(['Ref. ' num2str(sm-40.0) ' dB']);
set(b,'FontSize',14);

tit=['Point Driven Plate,  h =' num2str(h) ', f = ' num2str(omega/(2*pi)) ]
b=title(tit);
set(b,'FontSize',20);
