% Radiation from an infinite cylinder (kz=0).   

N=200;			% Discretization parameter
X=0.5;			% Total x dimension
Y=0.5;			% Total y dimension
c=1520;			% Sound speed in medium
f=30000;			% frequency
omega=2*pi*f;	% Radian frequency
k=omega/c;		% Wavenumber
a=X/10;			% Radius of pipe

x=-X/2:X/N:X/2;
y=-Y/2:Y/N:Y/2;
x0=zeros(N+1);
y0=zeros(N+1);
r0=zeros(N+1);
phi=zeros(N+1);
mask=zeros(N+1);

for nx=1:N+1
   for ny=1:N+1
      x0(ny,nx)=x(nx);
      y0(ny,nx)=y(ny);
      r0(ny,nx)=sqrt(x0(ny,nx)^2+y0(ny,nx)^2);
      mask(ny,nx)=1;
      if r0(ny,nx) < a
         x0(ny,nx)=a*x0(ny,nx)/(r0(ny,nx)+eps);
         y0(ny,nx)=a*y0(ny,nx)/(r0(ny,nx)+eps);
         r0(ny,nx)=0;
         mask(ny,nx)=0;
      end
   end
end

phi=atan2(y0,x0);

dt=pi/20;
kz=0;

figure(1)
set(gcf,'doublebuffer','on');

for n=0:6
	ks=n/a;
	kr=sqrt(k^2-ks^2-kz^2);

	p6=i*H_n(n,kr.*r0)/dH_ndx(n,kr*a).*exp(i*n*phi);
	p6=p6.*mask;

	for t1=0:dt:10*pi
		p=p6*exp(-i*t1);
      imagesc(x,y,real(p))
      title(sprintf('Cylinder Radiation: k_z=0 (n=%d)',n))
      caxis([-1 1])
      colorbar
      xlabel('x')
      ylabel('y')
  		axis equal
   	axis tight
   	pause(.01)
   end
   title('HIT ANY KEY TO CONTINUE')
   pause
end

