% Calculates particle displacements around a dipole.   

clear all

N=50;				% Number of particles on a side
X=1;				% Horizontal dimension of box
Y=1;     		% Vertcial dimension of box
c=1500;			% Sound speed
f=10000;			% Frequency Hz
omega=2*pi*f; 	% Frequency in rad/s
k=omega/c;		% Wavenumber of medium
A=2e-4;			% Source strength
a=X/20;			% Size of monopoles
d=X/10;

x=-X/2:X/N:X/2;
y=-Y/2:Y/N:Y/2;
x0=zeros(N+1);
y0=zeros(N+1);
r0=zeros(N+1);

for nx=1:N+1
   for ny=1:N+1
      x0(ny,nx)=x(nx);
      y0(ny,nx)=y(ny);
      
      r0(ny,nx)=sqrt((x0(ny,nx)-d/2)^2+y0(ny,nx)^2);
      
      if r0(ny,nx) < a
         x0(ny,nx)=d/2+a*(x0(ny,nx)-d/2)/r0(ny,nx);
         y0(ny,nx)=a*y0(ny,nx)/r0(ny,nx);
         r0(ny,nx)=a;
      end
      
      r1(ny,nx)=sqrt((x0(ny,nx)+d/2)^2+y0(ny,nx)^2);
      
      if r1(ny,nx) < a
         x0(ny,nx)=a*(x0(ny,nx)+d/2)/r1(ny,nx)-d/2;
         y0(ny,nx)=a*y0(ny,nx)/r1(ny,nx);
         r1(ny,nx)=a;
      end   
   end
end

dt=pi/20;
figure(1)

for t1=0:dt:20*pi
   
   % Displacement field
   u0=A*exp(i*k.*r0).*(i*k-1./r0); % Drop 1/r term for appearance
   u0=u0*exp(-i*t1);
   
   u1=-A*exp(i*k.*r1).*(i*k-1./r1); % Drop 1/r term for appearance
   u1=u1*exp(-i*t1);

   xpos=x0+real(u0.*(x0-d/2)./r0+u1.*(x0+d/2)./r1);
   ypos=y0+real(u0.*y0./r0+u1.*y0./r1);
   
   plot(xpos,ypos,'r.')
   title('DIPOLE DISPLACEMENT FIELD');
  
  	axis equal
  	axis tight
   pause(.01);
end

