% Simulation of a helical wave in a cylindrical shell
clear all

Nl=100; 		% Discretization along length of cylinder
Nc=50;		% Discretization around circumference

freq=51566.20157; % Corresponds to n=6
omega=2*pi*freq;
c=5400;		% Longitudinal velocity for mild steel
radius=0.1;	% Radius of shell
Wo=0.01;		% Displacement amplitude
k=omega/c;	% Wavenumber in material

[x,y,z]=cylinder(radius*ones(1,Nl),Nc);

% Cylindrical polar coordinates
phi=atan2(y,x);

% Circumferential arc coordinate
s=radius*phi;

% Slices through cylinder
h=find(z==0);		% Horizontal
v=find(phi==0);	% Vertical

figure(1)
set(gcf,'doublebuffer','on');

for n=0:7

	% Cylindrical wavenumber
	ks=n/radius;

	% Axial wavenumber
	kz=sqrt(k^2-ks^2);

	% Time step
	dtheta=2*pi/20;

	for nt=0:100

		c=0.01*exp(i*ks*s).*exp(i*kz*z).*exp(-i*nt*dtheta);
   
   	figure(1)
   	subplot(1,3,1)
		surf(x,y,z,real(c));
		shading interp
   	axis equal
   
   	subplot(1,3,2)
   	plot(x(h)+real(c(h)).*cos(phi(h)),y(h)+real(c(h)).*sin(phi(h)),'k')
  		title(sprintf('Helical Wave: n=%d\n',n));
		axis equal
    	axis([-1.5*radius,1.5*radius,-.45,.45])
  
   	subplot(1,3,3)
   	plot(real(c(v)),z(v),'k.')
   	axis([-.04,.04,0,1])

   	pause(.01)   
   end
   title('HIT ANY KEY TO CONTINUE')
	pause
end


