% Calculates particle displacements around monopole.   

N=50;
X=1;
Y=1;
c=1500;	% Sound speed
f=10000;	% frequency
omega=2*pi*f;
k=omega/c;
A=2e-4;
a=X/20;

x=-X/2:X/N:X/2;
y=-Y/2:Y/N:Y/2;
x0=zeros(N+1);
y0=zeros(N+1);
r0=zeros(N+1);

for nx=1:N+1
   for ny=1:N+1
      x0(ny,nx)=x(nx);
      y0(ny,nx)=y(ny);
  		r0(ny,nx)=sqrt(x0(ny,nx)^2+y0(ny,nx)^2);
      if r0(ny,nx) < a
         x0(ny,nx)=a*x0(ny,nx)/r0(ny,nx);
         y0(ny,nx)=a*y0(ny,nx)/r0(ny,nx);
         r0(ny,nx)=a;
      end   
   end
end

dt=pi/20;
figure(1)

for t1=0:dt:20*pi
   
   % Displacement field
   u=A*exp(i*k.*r0).*(i*k-1./r0); % Remove additional 1/r term for appearance
   u=u*exp(-i*t1);
   xpos=x0+real(u).*x0./r0;
   ypos=y0+real(u).*y0./r0;
   
   plot(xpos,ypos,'r.')
   title('MONOPOLE DISPLACEMENT FIELD')
   
   axis equal
   axis tight
   pause(.01);
end

