N=100; % Discretization of sphere
m=2;	 % Degree of harmonic
n=4;	 % Order of harmonic

[x,y,z]=sphere(N);

% Cartesian to polar
theta=atan2(sqrt(x.^2+y.^2),z+eps);
phi=atan2(y,x+eps);

% Compute harmonic
c=Ymn(m,n,theta,phi);

figure(1)
surf(x,y,z,real(c));
shading interp
axis equal
xlabel('x')
ylabel('y')
zlabel('z')
title(sprintf('Spherical Harmonic Re[Y^{%d}_{%d}]',m,n)); 
colorbar

figure(2)
surf(x,y,z,imag(c));
shading interp
axis equal
xlabel('x')
ylabel('y')
zlabel('z')
title(sprintf('Spherical Harmonic Im[Y^{%d}_{%d}]',m,n)); 
colorbar

figure(3)
surf(x,y,z,abs(c));
shading interp
axis equal
xlabel('x')
ylabel('y')
zlabel('z')
title(sprintf('Spherical Harmonic Abs[Y^{%d}_{%d}]',m,n)); 
colorbar