% function bundle_raytrace(gradh,n_fig)
%
% Traces an on--axis parallel ray bundle propagating through a GRIN
% whose Hamiltonian equations are defined by the function gradh.
% gradh must be passed as a function handle, e.g. @sgradh_elliptical .
%
% (See also comments to screen_raytrace.m and sgradh_elliptical.m)
%
% z_max = maximum propagation distance (i.e., location of output screen)
% n_fig = figure # to plot result (default=1)
%
% (c) George Barbastathis -- MIT -- April 2008

function bundle_raytrace(gradh,z_max,n_fig)

if nargin==2
    n_fig=1;
end

q0x_max=10.0;
q0x_step=1.0;
qx_vec=-q0x_max:q0x_step:q0x_max;

p0=[0; 0];

figure(n_fig);
hold on

for k=1:1:length(qx_vec)
    q0=[qx_vec(k); 0];
    [z,q,p]=screen_raytrace(q0,p0,z_max,gradh);
    plot(z,q(:,1));
end

figha=gca;
set(figha,'FontSize',14,'XGrid','on','YGrid','on')
xlabel('z [a.u.]')
ylabel('q_1\equiv x [a.u.]')
