% function [z,q,p]=raytrace(q0,p0,z_max,gradh)
% 
% Hamiltonian ray trace using the screen Hamiltonian
% [K. B. Wolf, Hamiltonian Optics in Phase Space, ch. 2]
%
% Inputs
% q0 = ray position at input screen (2x1 vector, 1st element=x, 2nd=y)
% p0 = ray momentum at input screen (2x1 vector, 1st element=p_x, 2nd=p_y)
% z_max = propagation distance (location of
%      output screen)
% gradh = gradient of the screen hamiltonian
%      (should be entered as function handle to .m file
%       containing the screen hamiltonian definition;
%       e.g. @sgradh_elliptical etc.)
% 
% Outputs
% z = vector of positions along the propagation 
%      distance where trajectory was sampled
% q = ray trajectory (position) as function of z
% p = ray trajectory (momentum) as function of z
%
% (c) George Barbastathis -- MIT -- April 2007

function [z,q,p]=screen_raytrace(q0,p0,z_max,gradh)

sv0=[q0; p0]; % state vector initial value

[z,sv]=ode45(gradh,[0 z_max],sv0);

q=sv(:,1:2);
p=sv(:,3:4);





