% function gradh=sgradh_elliptical(sv)
%
% Screen Hamiltonian gradient for elliptical index profile
% 
% sv = state vector such that
%   sv(1)=q(1)
%   sv(2)=q(2)
%   sv(3)=p(1)
%   sv(4)=p(2)
% gradh = hamiltonian gradients such that
%   gradh(1)=dq(1)/dz=dH/dp(1)
%   gradh(2)=dq(2)/dz=dH/dp(2)
%   gradh(3)=dp(1)/dz=-dH/dq(1)
%   gradh(4)=dp(2)/dz=-dH/dq(2)
% 
% In this example (KBW, p. 21) h=sqrt(n^2(q)-|p|^2) and
% n^2(q)=n_0^2-kappa^2 |q|^2. This can be integrated exactly
% to a sinusoidal solution for q(z), p(z).
%
% (c) George Barbastathis -- MIT -- April 2008


function gradh=sgradh_elliptical(z,sv)

n0=1.5;
kappa=0.1;
h=-sqrt(n0^2-(sv(3)^2+sv(4)^2+kappa^2*(sv(1)^2+sv(2)^2)));
gradh=zeros(4,1);

gradh(1)=sv(3)/h;
gradh(2)=sv(4)/h;
gradh(3)=-kappa^2*sv(1)/h;
gradh(4)=-kappa^2*sv(2)/h;

