% function gradhh=sgradh_quadratic_hw(sv)
%
% Screen Hamiltonian gradient for quadratic index profile
% 
% sv = state vector such that
%   sv(1)=q(1)
%   sv(2)=q(2)
%   sv(3)=p(1)
%   sv(4)=p(2)
% gradh = hamiltonian gradients such that
%   gradh(1)=dq(1)/dz=dH/dp(1)
%   gradh(2)=dq(2)/dz=dH/dp(2)
%   gradh(3)=dp(1)/dz=-dH/dq(1)
%   gradh(4)=dp(2)/dz=-dH/dq(2)
% 
% In this example (KBW, p. 21) h=sqrt(n^2(q)-|p|^2) and
% n(q)=n_0-alpha |q|^2 /2. This can be integrated exactly
% to a sinusoidal solution for q(z), p(z).
%
% (c) George Barbastathis -- MIT -- April 2008


function gradh=sgradh_quadratic_hw(z,sv)

n0=1.5;
alpha=(0.1)^2/1.5; % =0.0067
h=-sqrt((n0-0.5*alpha*(sv(1)^2+sv(2)^2))^2-(sv(3)^2+sv(4)^2));

gradh=zeros(4,1);

gradh(1)=sv(3)/h;
gradh(2)=sv(4)/h;
gradh(3)=0.0; %% REPLACE WITH THE CORRECT EXPRESSION
gradh(4)=0.0; %% REPLACE WITH THE CORRECT EXPRESSION

