class Ball {
  PVector loc;
  PVector vel;
  float dim;
  color col;
  float damping = 0.005f;
  float maxSpeed = 1.0f;
  Ball(PVector loc, PVector vel, color col, float dim) {
    this.loc = loc;
    this.vel = vel;
    this.col = col;
    this.dim = dim;
  }
  
  void moveBall() {
    PVector delta = new PVector(vel.x, vel.y);
    if (delta.mag() > this.maxSpeed) {
      delta.mult( delta.mag() * delta.mag() * this.damping );
      vel.sub(delta);
    }
    
    loc.add(vel);
  }

  void boundary() {
    if (loc.x > width || loc.x < 0) {
      vel.x *= - 1;
    }
    if (loc.y > height || loc.y < 0) {
      vel.y *= - 1;
    }
  }

  void display() {
    noStroke();
    fill(col);
    ellipse(loc.x, loc.y, dim, dim);
  }
}

class World {
  ArrayList<Ball> balls;
  PVector pos;    
  float magnetism;

  World() {
    balls = new ArrayList<Ball>();
  }

  void addBall(Ball age) {
    balls.add(age);
  }

  void update() {
    for (int i=0; i<balls.size(); i++) {
      balls.get(i).moveBall();
      balls.get(i).boundary();
    }
   }


  void connectivity() {
      
    for (int i=0; i<balls.size(); i++) {
      Ball ballA = balls.get(i);
      PVector vecA = balls.get(i).loc;
      for (int j=0; j<balls.size(); j++) {
        Ball ballb = balls.get(j);
        PVector vecB = balls.get(j).loc;
        
        if (vecA.dist(vecB)<50) {
          strokeWeight(2);
          stroke(40, 90);
          line(vecA.x, vecA.y, vecB.x, vecB.y);
        }
        
        if (vecA.dist(vecB)<100 && vecA.dist(vecB)>50) {
          strokeWeight(2);
          stroke(120, 50);
          line(vecA.x, vecA.y, vecB.x, vecB.y);
        }
          
        if (vecA.dist(vecB)<150 && vecA.dist(vecB)>100) {
          strokeWeight(1);
          stroke(180, 50);
          line(vecA.x, vecA.y, vecB.x, vecB.y);
        }

        if (vecA.dist(vecB)<200 && vecA.dist(vecB)>200) {
          strokeWeight(1);
          stroke(200, 40);
          line(vecA.x, vecA.y, vecB.x, vecB.y);
        }

        pos = new PVector(vecA.x, vecA.y);   // set the position based on parameters
        magnetism = 0.005f;      // make particles be attracted to the mouse
          PVector mouse = new PVector( mouseX, mouseY ); // create mouse pos as a vector
          mouse.sub( pos );                              // subtract mouse pos from particle pos
          //mouse now contains the difference vector between this particle
          // and the mouse
          float magnitude = mouse.mag();  // find out how far the particle is from the mouse
          if (magnitude < 100 && magnitude > 5 ){
            ballA.maxSpeed = 0.0f;
            ballA.damping = 0.05f;       
         
         
            mouse.mult( magnetism );
            mouse.mult( 1 / magnitude / magnitude );
            ballA.vel.add( mouse );
          }
          
         
        
        else {
          ballA.damping = 0.005f;
          ballA.maxSpeed = 1.0f;
        }
      
    }
  }

 }
 
  void run() {
    for (int i=0; i<balls.size(); i++) {
      balls.get(i).display();
    }
  }
}

void createWorld(){
 
  for (int i=0; i<numBall; i++){
    PVector loc = new PVector(random(0,width), random(0,height));
    PVector vel = new PVector(random(.5), random(.5));
    color col = color(0,0,0,random(150,255));
    float dim = 3;
    
    
    
    Ball age = new Ball(loc, vel, col, dim);
    world.addBall(age);
    
    
  } 
}

//import processing.pdf.*;

//boolean record;

int numBall = 200;
World world;

void setup (){
  size(800,600,P3D);
  smooth();
  
  world= new World();
  createWorld(); 
}

void draw(){
//  if (record){
//    beginRecord(PDF, "frame-####.pdf");
//  }
  
  background(255);

  world.update();
  world.connectivity();
  world.run();
}
  

  
//  if (record){
//    endRecord();
//      record=false;
//  }  
//}
//
//void mousePressed(){
//  record=true;
//}

//void keyPressed() {
//  if (key == 'q'){
//    record=true;
//  }
//}


