/*
 * Decompiled with CFR 0.152.
 */
package peasy;

import peasy.org.apache.commons.math.geometry.Rotation;
import peasy.org.apache.commons.math.geometry.Vector3D;

public class InterpolationUtil {
    public static Rotation slerp(Rotation a, Rotation b, double t) {
        double w2;
        double w1;
        double b3;
        double b2;
        double b1;
        double a0 = a.getQ0();
        double a1 = a.getQ1();
        double a2 = a.getQ2();
        double a3 = a.getQ3();
        double b0 = b.getQ0();
        double cosTheta = a0 * b0 + a1 * (b1 = b.getQ1()) + a2 * (b2 = b.getQ2()) + a3 * (b3 = b.getQ3());
        if (cosTheta < 0.0) {
            b0 = -b0;
            b1 = -b1;
            b2 = -b2;
            b3 = -b3;
            cosTheta = -cosTheta;
        }
        double theta = Math.acos(cosTheta);
        double sinTheta = Math.sqrt(1.0 - cosTheta * cosTheta);
        if (sinTheta > 0.001) {
            w1 = Math.sin((1.0 - t) * theta) / sinTheta;
            w2 = Math.sin(t * theta) / sinTheta;
        } else {
            w1 = 1.0 - t;
            w2 = t;
        }
        return new Rotation(w1 * a0 + w2 * b0, w1 * a1 + w2 * b1, w1 * a2 + w2 * b2, w1 * a3 + w2 * b3, true);
    }

    public static double smooth(double a, double b, double t) {
        double smooth = t * t * (3.0 - 2.0 * t);
        return b * smooth + a * (1.0 - smooth);
    }

    public static Vector3D smooth(Vector3D a, Vector3D b, double t) {
        return new Vector3D(InterpolationUtil.smooth(a.getX(), b.getX(), t), InterpolationUtil.smooth(a.getY(), b.getY(), t), InterpolationUtil.smooth(a.getZ(), b.getZ(), t));
    }

    public static double linear(double a, double b, double t) {
        return a + (b - a) * t;
    }

    public static Vector3D linear(Vector3D a, Vector3D b, double t) {
        return new Vector3D(InterpolationUtil.linear(a.getX(), b.getX(), t), InterpolationUtil.linear(a.getY(), b.getY(), t), InterpolationUtil.linear(a.getZ(), b.getZ(), t));
    }
}

