/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.curve.opengl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLUniformData;

public class VBORegion2PES2
extends GLRegion {
    private GLArrayDataServer verticeTxtAttr;
    private GLArrayDataServer texCoordTxtAttr;
    private GLArrayDataServer indicesTxt;
    private GLArrayDataServer verticeFboAttr;
    private GLArrayDataServer texCoordFboAttr;
    private GLArrayDataServer indicesFbo;
    private FBObject fbo;
    private FBObject.TextureAttachment texA;
    private PMVMatrix fboPMVMatrix;
    GLUniformData mgl_fboPMVMatrix;
    private int tex_width_c = 0;
    private int tex_height_c = 0;
    GLUniformData mgl_ActiveTexture;
    GLUniformData mgl_TextureSize;
    int[] maxTexSize = new int[]{-1};

    public VBORegion2PES2(int n, int n2) {
        super(n);
        this.fboPMVMatrix = new PMVMatrix();
        this.mgl_fboPMVMatrix = new GLUniformData("gcu_PMVMatrix", 4, 4, this.fboPMVMatrix.glGetPMvMatrixf());
        this.mgl_ActiveTexture = new GLUniformData("gcu_TextureUnit", n2);
    }

    @Override
    public void update(GL2ES2 gL2ES2, RenderState renderState) {
        Object[] objectArray;
        int n;
        Object object;
        if (!this.isDirty()) {
            return;
        }
        if (null == this.indicesFbo) {
            object = renderState.getShaderState();
            this.indicesFbo = GLArrayDataServer.createData(3, 5122, 256, 35044, 34963);
            this.indicesFbo.puts((short)0);
            this.indicesFbo.puts((short)1);
            this.indicesFbo.puts((short)3);
            this.indicesFbo.puts((short)1);
            this.indicesFbo.puts((short)2);
            this.indicesFbo.puts((short)3);
            this.indicesFbo.seal(true);
            this.texCoordFboAttr = GLArrayDataServer.createGLSL("gca_TexCoords", 2, 5126, false, 256, 35044);
            ((ShaderState)object).ownAttribute(this.texCoordFboAttr, true);
            this.texCoordFboAttr.putf(5.0f);
            this.texCoordFboAttr.putf(5.0f);
            this.texCoordFboAttr.putf(5.0f);
            this.texCoordFboAttr.putf(6.0f);
            this.texCoordFboAttr.putf(6.0f);
            this.texCoordFboAttr.putf(6.0f);
            this.texCoordFboAttr.putf(6.0f);
            this.texCoordFboAttr.putf(5.0f);
            this.texCoordFboAttr.seal(true);
            this.verticeFboAttr = GLArrayDataServer.createGLSL("gca_Vertices", 3, 5126, false, 256, 35044);
            ((ShaderState)object).ownAttribute(this.verticeFboAttr, true);
            this.indicesTxt = GLArrayDataServer.createData(3, 5122, 256, 35044, 34963);
            this.verticeTxtAttr = GLArrayDataServer.createGLSL("gca_Vertices", 3, 5126, false, 256, 35044);
            ((ShaderState)object).ownAttribute(this.verticeTxtAttr, true);
            this.texCoordTxtAttr = GLArrayDataServer.createGLSL("gca_TexCoords", 2, 5126, false, 256, 35044);
            ((ShaderState)object).ownAttribute(this.texCoordTxtAttr, true);
        }
        this.indicesTxt.seal(gL2ES2, false);
        this.indicesTxt.rewind();
        for (n = 0; n < this.triangles.size(); ++n) {
            object = (Triangle)this.triangles.get(n);
            objectArray = ((Triangle)object).getVertices();
            if (objectArray[0].getId() == Integer.MAX_VALUE) {
                objectArray[0].setId(this.numVertices++);
                objectArray[1].setId(this.numVertices++);
                objectArray[2].setId(this.numVertices++);
                this.vertices.add(objectArray[0]);
                this.vertices.add(objectArray[1]);
                this.vertices.add(objectArray[2]);
                this.indicesTxt.puts((short)objectArray[0].getId());
                this.indicesTxt.puts((short)objectArray[1].getId());
                this.indicesTxt.puts((short)objectArray[2].getId());
                continue;
            }
            this.indicesTxt.puts((short)objectArray[0].getId());
            this.indicesTxt.puts((short)objectArray[1].getId());
            this.indicesTxt.puts((short)objectArray[2].getId());
        }
        this.indicesTxt.seal(gL2ES2, true);
        this.indicesTxt.enableBuffer(gL2ES2, false);
        this.box.reset();
        this.verticeTxtAttr.seal(gL2ES2, false);
        this.verticeTxtAttr.rewind();
        this.texCoordTxtAttr.seal(gL2ES2, false);
        this.texCoordTxtAttr.rewind();
        for (n = 0; n < this.vertices.size(); ++n) {
            object = (Vertex)this.vertices.get(n);
            this.verticeTxtAttr.putf(object.getX());
            this.verticeTxtAttr.putf(object.getY());
            this.verticeTxtAttr.putf(object.getZ());
            this.box.resize(object.getX(), object.getY(), object.getZ());
            objectArray = object.getTexCoord();
            this.texCoordTxtAttr.putf((float)objectArray[0]);
            this.texCoordTxtAttr.putf((float)objectArray[1]);
        }
        this.texCoordTxtAttr.seal(gL2ES2, true);
        this.texCoordTxtAttr.enableBuffer(gL2ES2, false);
        this.verticeTxtAttr.seal(gL2ES2, true);
        this.verticeTxtAttr.enableBuffer(gL2ES2, false);
        this.verticeFboAttr.seal(gL2ES2, false);
        this.verticeFboAttr.rewind();
        this.verticeFboAttr.putf(this.box.getLow()[0]);
        this.verticeFboAttr.putf(this.box.getLow()[1]);
        this.verticeFboAttr.putf(this.box.getLow()[2]);
        this.verticeFboAttr.putf(this.box.getLow()[0]);
        this.verticeFboAttr.putf(this.box.getHigh()[1]);
        this.verticeFboAttr.putf(this.box.getLow()[2]);
        this.verticeFboAttr.putf(this.box.getHigh()[0]);
        this.verticeFboAttr.putf(this.box.getHigh()[1]);
        this.verticeFboAttr.putf(this.box.getLow()[2]);
        this.verticeFboAttr.putf(this.box.getHigh()[0]);
        this.verticeFboAttr.putf(this.box.getLow()[1]);
        this.verticeFboAttr.putf(this.box.getLow()[2]);
        this.verticeFboAttr.seal(gL2ES2, true);
        this.verticeFboAttr.enableBuffer(gL2ES2, false);
        this.fboPMVMatrix.glMatrixMode(5889);
        this.fboPMVMatrix.glLoadIdentity();
        this.fboPMVMatrix.glOrthof(this.box.getLow()[0], this.box.getHigh()[0], this.box.getLow()[1], this.box.getHigh()[1], -1.0f, 1.0f);
        this.indicesFbo.seal(gL2ES2, true);
        this.indicesFbo.enableBuffer(gL2ES2, false);
        this.setDirty(false);
    }

    @Override
    protected void drawImpl(GL2ES2 gL2ES2, RenderState renderState, int n, int n2, int[] nArray) {
        if (n <= 0 || n2 <= 0 || null == nArray || nArray[0] <= 0) {
            this.renderRegion(gL2ES2);
        } else {
            if (0 > this.maxTexSize[0]) {
                gL2ES2.glGetIntegerv(3379, this.maxTexSize, 0);
            }
            if (nArray[0] != this.tex_width_c) {
                if (nArray[0] > this.maxTexSize[0]) {
                    nArray[0] = this.maxTexSize[0];
                }
                this.renderRegion2FBO(gL2ES2, renderState, nArray);
            }
            this.renderFBO(gL2ES2, renderState, n, n2);
        }
    }

    private void renderFBO(GL2ES2 gL2ES2, RenderState renderState, int n, int n2) {
        ShaderState shaderState = renderState.getShaderState();
        gL2ES2.glViewport(0, 0, n, n2);
        shaderState.uniform(gL2ES2, this.mgl_ActiveTexture);
        gL2ES2.glActiveTexture(33984 + this.mgl_ActiveTexture.intValue());
        this.fbo.use(gL2ES2, this.texA);
        this.verticeFboAttr.enableBuffer(gL2ES2, true);
        this.texCoordFboAttr.enableBuffer(gL2ES2, true);
        this.indicesFbo.bindBuffer(gL2ES2, true);
        gL2ES2.glDrawElements(4, this.indicesFbo.getElementCount() * this.indicesFbo.getComponentCount(), 5123, 0L);
        this.indicesFbo.bindBuffer(gL2ES2, false);
        this.texCoordFboAttr.enableBuffer(gL2ES2, false);
        this.verticeFboAttr.enableBuffer(gL2ES2, false);
        this.fbo.unuse(gL2ES2);
    }

    private void renderRegion2FBO(GL2ES2 gL2ES2, RenderState renderState, int[] nArray) {
        ShaderState shaderState = renderState.getShaderState();
        if (0 >= nArray[0]) {
            throw new IllegalArgumentException("texWidth must be greater than 0: " + nArray[0]);
        }
        this.tex_width_c = nArray[0];
        this.tex_height_c = (int)((float)this.tex_width_c * this.box.getHeight() / this.box.getWidth() + 0.5f);
        if (null != this.fbo && this.fbo.getWidth() != this.tex_width_c && this.fbo.getHeight() != this.tex_height_c) {
            this.fbo.reset(gL2ES2, this.tex_width_c, this.tex_height_c);
        }
        if (null == this.fbo) {
            this.fbo = new FBObject();
            this.fbo.reset(gL2ES2, this.tex_width_c, this.tex_height_c);
            this.texA = this.fbo.attachTexture2D(gL2ES2, 0, true, 9729, 9729, 33071, 33071);
            this.fbo.attachRenderbuffer(gL2ES2, FBObject.Attachment.Type.DEPTH, 24);
        } else {
            this.fbo.bind(gL2ES2);
        }
        gL2ES2.glViewport(0, 0, this.tex_width_c, this.tex_height_c);
        shaderState.uniform(gL2ES2, this.mgl_fboPMVMatrix);
        gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL2ES2.glClear(16640);
        this.renderRegion(gL2ES2);
        this.fbo.unbind(gL2ES2);
        shaderState.uniform(gL2ES2, renderState.getPMVMatrix());
        if (null == this.mgl_TextureSize) {
            this.mgl_TextureSize = new GLUniformData("gcu_TextureSize", 2, Buffers.newDirectFloatBuffer((int)2));
        }
        FloatBuffer floatBuffer = (FloatBuffer)this.mgl_TextureSize.getBuffer();
        floatBuffer.put(0, this.fbo.getWidth());
        floatBuffer.put(1, this.fbo.getHeight());
        shaderState.uniform(gL2ES2, this.mgl_TextureSize);
    }

    private void renderRegion(GL2ES2 gL2ES2) {
        this.verticeTxtAttr.enableBuffer(gL2ES2, true);
        this.texCoordTxtAttr.enableBuffer(gL2ES2, true);
        this.indicesTxt.bindBuffer(gL2ES2, true);
        gL2ES2.glDrawElements(4, this.indicesTxt.getElementCount() * this.indicesTxt.getComponentCount(), 5123, 0L);
        this.indicesTxt.bindBuffer(gL2ES2, false);
        this.texCoordTxtAttr.enableBuffer(gL2ES2, false);
        this.verticeTxtAttr.enableBuffer(gL2ES2, false);
    }

    @Override
    public void destroy(GL2ES2 gL2ES2, RenderState renderState) {
        ShaderState shaderState = renderState.getShaderState();
        if (null != this.fbo) {
            this.fbo.destroy(gL2ES2);
            this.fbo = null;
            this.texA = null;
        }
        if (null != this.verticeTxtAttr) {
            shaderState.ownAttribute(this.verticeTxtAttr, false);
            this.verticeTxtAttr.destroy(gL2ES2);
            this.verticeTxtAttr = null;
        }
        if (null != this.texCoordTxtAttr) {
            shaderState.ownAttribute(this.texCoordTxtAttr, false);
            this.texCoordTxtAttr.destroy(gL2ES2);
            this.texCoordTxtAttr = null;
        }
        if (null != this.indicesTxt) {
            this.indicesTxt.destroy(gL2ES2);
            this.indicesTxt = null;
        }
        if (null != this.verticeFboAttr) {
            shaderState.ownAttribute(this.verticeFboAttr, false);
            this.verticeFboAttr.destroy(gL2ES2);
            this.verticeFboAttr = null;
        }
        if (null != this.texCoordFboAttr) {
            shaderState.ownAttribute(this.texCoordFboAttr, false);
            this.texCoordFboAttr.destroy(gL2ES2);
            this.texCoordFboAttr = null;
        }
        if (null != this.indicesFbo) {
            this.indicesFbo.destroy(gL2ES2);
            this.indicesFbo = null;
        }
        this.triangles.clear();
        this.vertices.clear();
    }
}

