/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkTextVar;

public class PngChunkITXT
extends PngChunkTextVar {
    private boolean compressed = false;
    private String langTag = "";
    private String translatedTag = "";

    public PngChunkITXT(ImageInfo imageInfo) {
        super("iTXt", imageInfo);
    }

    @Override
    public ChunkRaw createChunk() {
        if (this.val.isEmpty() || this.key.isEmpty()) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.key.getBytes(PngHelper.charsetLatin1));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(this.compressed ? 1 : 0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(this.langTag.getBytes(PngHelper.charsetUTF8));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(this.translatedTag.getBytes(PngHelper.charsetUTF8));
            byteArrayOutputStream.write(0);
            byte[] byArray = this.val.getBytes(PngHelper.charsetUTF8);
            if (this.compressed) {
                byArray = ChunkHelper.compressBytes(byArray, true);
            }
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ChunkRaw chunkRaw = this.createEmptyChunk(byArray2.length, false);
            chunkRaw.data = byArray2;
            return chunkRaw;
        }
        catch (IOException iOException) {
            throw new PngjException(iOException);
        }
    }

    @Override
    public void parseFromChunk(ChunkRaw chunkRaw) {
        int n;
        int n2 = 0;
        int[] nArray = new int[3];
        for (n = 0; n < chunkRaw.data.length; ++n) {
            if (chunkRaw.data[n] != 0) continue;
            nArray[n2] = n;
            if (++n2 == 1) {
                n += 2;
            }
            if (n2 == 3) break;
        }
        if (n2 != 3) {
            throw new PngjException("Bad formed PngChunkITXT chunk");
        }
        this.key = new String(chunkRaw.data, 0, nArray[0], PngHelper.charsetLatin1);
        n = nArray[0] + 1;
        this.compressed = chunkRaw.data[n] != 0;
        if (this.compressed && chunkRaw.data[++n] != 0) {
            throw new PngjException("Bad formed PngChunkITXT chunk - bad compression method ");
        }
        this.langTag = new String(chunkRaw.data, n, nArray[1] - n, PngHelper.charsetLatin1);
        this.translatedTag = new String(chunkRaw.data, nArray[1] + 1, nArray[2] - nArray[1] - 1, PngHelper.charsetUTF8);
        n = nArray[2] + 1;
        if (this.compressed) {
            byte[] byArray = ChunkHelper.compressBytes(chunkRaw.data, n, chunkRaw.data.length - n, false);
            this.val = new String(byArray, PngHelper.charsetUTF8);
        } else {
            this.val = new String(chunkRaw.data, n, chunkRaw.data.length - n, PngHelper.charsetUTF8);
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkITXT pngChunkITXT = (PngChunkITXT)pngChunk;
        this.key = pngChunkITXT.key;
        this.val = pngChunkITXT.val;
        this.compressed = pngChunkITXT.compressed;
        this.langTag = pngChunkITXT.langTag;
        this.translatedTag = pngChunkITXT.translatedTag;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean bl) {
        this.compressed = bl;
    }

    public String getLangtag() {
        return this.langTag;
    }

    public void setLangtag(String string) {
        this.langTag = string;
    }

    public String getTranslatedTag() {
        return this.translatedTag;
    }

    public void setTranslatedTag(String string) {
        this.translatedTag = string;
    }
}

