/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.windows;

import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.util.ScreenModeUtil;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.Point;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.windows.DisplayDriver;

public class ScreenDriver
extends ScreenImpl {
    private int nativeModeIdx;

    @Override
    protected void createNativeImpl() {
        this.aScreen = new DefaultGraphicsScreen(this.getDisplay().getGraphicsDevice(), this.screen_idx);
    }

    @Override
    protected void closeNativeImpl() {
    }

    private int[] getScreenModeIdx(int n) {
        int[] nArray = this.getScreenMode0(this.screen_idx, n);
        if (null == nArray || 0 == nArray.length) {
            return null;
        }
        if (nArray.length < 8) {
            throw new RuntimeException("properties array too short, should be >= 8, is " + nArray.length);
        }
        return nArray;
    }

    @Override
    protected int[] getScreenModeFirstImpl() {
        this.nativeModeIdx = 0;
        return this.getScreenModeNextImpl();
    }

    @Override
    protected int[] getScreenModeNextImpl() {
        int[] nArray = this.getScreenModeIdx(this.nativeModeIdx);
        if (null != nArray && 0 < nArray.length) {
            ++this.nativeModeIdx;
            return nArray;
        }
        return null;
    }

    @Override
    protected ScreenMode getCurrentScreenModeImpl() {
        int[] nArray = this.getScreenModeIdx(-1);
        if (null != nArray && 0 < nArray.length) {
            return ScreenModeUtil.streamIn(nArray, 0);
        }
        return null;
    }

    @Override
    protected boolean setCurrentScreenModeImpl(ScreenMode screenMode) {
        return this.setScreenMode0(this.screen_idx, screenMode.getMonitorMode().getSurfaceSize().getResolution().getWidth(), screenMode.getMonitorMode().getSurfaceSize().getResolution().getHeight(), screenMode.getMonitorMode().getSurfaceSize().getBitsPerPixel(), screenMode.getMonitorMode().getRefreshRate(), screenMode.getRotation());
    }

    @Override
    protected int validateScreenIndex(int n) {
        return 0;
    }

    @Override
    protected void getVirtualScreenOriginAndSize(Point point, Dimension dimension) {
        point.setX(this.getOriginX0(this.screen_idx));
        point.setY(this.getOriginY0(this.screen_idx));
        dimension.setWidth(this.getWidthImpl0(this.screen_idx));
        dimension.setHeight(this.getHeightImpl0(this.screen_idx));
    }

    private native int getOriginX0(int var1);

    private native int getOriginY0(int var1);

    private native int getWidthImpl0(int var1);

    private native int getHeightImpl0(int var1);

    private native int[] getScreenMode0(int var1, int var2);

    private native boolean setScreenMode0(int var1, int var2, int var3, int var4, int var5, int var6);

    static {
        DisplayDriver.initSingleton();
    }
}

