/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PVector;
import processing.pdf.PGraphicsPDF;

public class MIT4_112F12_Code_Ex1
extends PApplet {
    float speed;
    int cols;
    int rows;
    int cellsize;
    float lineThreshold;
    Point[][] pts;
    float c;
    PVector pos;
    PVector vel;
    float magnetism;
    float x_diff;
    float y_diff;
    boolean dosave = false;

    public void setup() {
        this.c = 0.0f;
        this.size(600, 600, "processing.core.PGraphics2D");
        this.frameRate(30.0f);
        this.smooth();
        this.cellsize = 30;
        this.cols = 600 / this.cellsize + 1;
        this.rows = 600 / this.cellsize + 1;
        this.pts = new Point[this.cols][this.rows];
        this.lineThreshold = 45.0f;
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                this.pts[n2][n] = new Point(n2 * this.cellsize, n * this.cellsize);
                ++n2;
            }
            ++n;
        }
        this.background(255);
    }

    public void draw() {
        int n;
        if (this.dosave) {
            PGraphicsPDF cfr_ignored_0 = (PGraphicsPDF)this.beginRaw("processing.pdf.PGraphicsPDF", "pdf_complex_out.pdf");
        }
        int n2 = 0;
        while (n2 < this.rows) {
            n = 0;
            while (n < this.cols) {
                this.pts[n][n2].move();
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.rows) {
            n = 0;
            while (n < this.cols) {
                int n3 = n2;
                while (n3 < this.rows) {
                    int n4 = n;
                    while (n4 < this.cols) {
                        float f = MIT4_112F12_Code_Ex1.dist((float)this.pts[n][n2].x, (float)this.pts[n][n2].y, (float)this.pts[n4][n3].x, (float)this.pts[n4][n3].y);
                        if (f < this.lineThreshold) {
                            this.strokeWeight(3.0f - f * 3.0f / 40.0f);
                            this.stroke(this.c, 100.0f - f * 100.0f / 40.0f);
                            this.pos = new PVector((float)(n * this.cellsize), (float)(n2 * this.cellsize));
                            this.magnetism = -5.0f;
                            PVector pVector = new PVector((float)this.mouseX, (float)this.mouseY);
                            pVector.sub(this.pos);
                            float f2 = pVector.mag();
                            if (f2 > 50.0f) {
                                this.line(this.pts[n][n2].x, this.pts[n][n2].y, this.pts[n4][n3].x, this.pts[n4][n3].y);
                            } else {
                                this.stroke(this.c, 100.0f - f * 100.0f / 40.0f);
                                this.strokeWeight(3.0f - f * 3.0f / 40.0f);
                                this.line(this.pts[n][n2].x + pVector.x + pVector.y, this.pts[n][n2].y + pVector.y + pVector.x, this.pts[n4][n3].x + pVector.x + pVector.y, this.pts[n4][n3].y + pVector.y + pVector.x);
                                this.stroke(255);
                                this.strokeWeight(2.0f);
                                this.line(this.pts[n][n2].x, this.pts[n][n2].y, this.pts[n4][n3].x, this.pts[n4][n3].y);
                            }
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n;
            }
            ++n2;
        }
        this.c = this.c < 200.0f ? (this.c += 0.05f) : 200.0f;
        if (this.dosave) {
            this.endRaw();
            this.dosave = false;
        }
    }

    public void mousePressed() {
        this.dosave = true;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "MIT4_112F12_Code_Ex1"});
    }

    class Point {
        float timeIncrement;
        float range;
        float x;
        float xOrigin;
        float xtime;
        float y;
        float yOrigin;
        float ytime;

        Point(float f, float f2) {
            this.xOrigin = f;
            this.yOrigin = f2;
            this.xtime = MIT4_112F12_Code_Ex1.this.random(100.0f);
            this.ytime = MIT4_112F12_Code_Ex1.this.random(100.0f);
            this.timeIncrement = MIT4_112F12_Code_Ex1.this.random(0.005f, 0.01f);
            this.range = MIT4_112F12_Code_Ex1.this.random(100.0f);
        }

        public void move() {
            this.x = this.xOrigin + (MIT4_112F12_Code_Ex1.this.noise(this.xtime) - 0.5f) * this.range;
            this.y = this.yOrigin + (MIT4_112F12_Code_Ex1.this.noise(this.ytime) - 0.5f) * this.range;
            this.xtime += this.timeIncrement;
            this.ytime += this.timeIncrement;
        }
    }
}

