import processing.core.*; 
import processing.xml.*; 

import processing.pdf.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class MIT4_112F12_Code_Ex1 extends PApplet {



float speed;
int cols, rows;
int cellsize;
float lineThreshold;
Point[][] pts;
float c;
PVector pos;   
PVector vel;  
float magnetism;
// test stuff
float x_diff;
float y_diff;
boolean dosave=false;

class Point {

  float timeIncrement;
  float range;
  float x,xOrigin,xtime;
  float y,yOrigin,ytime;
  Point(float xOriginInput,float yOriginInput) {
    xOrigin = xOriginInput;
    yOrigin = yOriginInput;
    xtime = random(100);
    ytime = random(100);
    timeIncrement = random(0.005f,0.01f);
    range = random(100);
  }
  public void move() {
    x = xOrigin+(noise(xtime)-0.5f)*range;
    y = yOrigin+(noise(ytime)-0.5f)*range;
    xtime += timeIncrement;
    ytime += timeIncrement;

  }
}


public void setup() {
  
  c = 0;
  size(600, 600, P2D);
  frameRate(30);
  smooth();
  cellsize = 30;
  cols = 600/cellsize+1;
  rows = 600/cellsize+1;
  pts = new Point[cols][rows];
  lineThreshold = 45;


  for (int i=0;i<rows;i++) {
    for (int j=0;j<cols;j++) {
      pts[j][i] = new Point(j*cellsize, i*cellsize);
    }
  }

  background(255);
}
public void draw() {
 if(dosave) {
    // set up PGraphicsPDF for use with beginRaw()
    PGraphicsPDF pdf = (PGraphicsPDF)beginRaw(PDF, "pdf_complex_out.pdf");
 }
  for (int i=0;i<rows;i++) {
    for (int j=0;j<cols;j++) {
      pts[j][i].move();
    }
  }

  for (int i=0;i<rows;i++) {
    for (int j=0;j<cols;j++) {
      for (int k=i;k<rows;k++) {
        for (int l=j;l<cols;l++) {
          float distance = dist(pts[j][i].x, pts[j][i].y, pts[l][k].x, pts[l][k].y);
          if (distance<lineThreshold) {

            strokeWeight(3-distance*3/40);
            stroke(c, 100-distance*100/40);

            pos = new PVector(j*cellsize, i*cellsize);   // set the position based on parameters
            magnetism = -5.0f;      // make particles be attracted to the mouse

            PVector mouse = new PVector( mouseX, mouseY ); // create mouse pos as a vector
            mouse.sub( pos );                              // subtract mouse pos from particle pos
            // mouse now contains the difference vector between this particle
            // and the mouse

            float magnitude = mouse.mag();  // find out how far the particle is from the mouse
            if (magnitude > 50) {  // radius of mouse effect
              line(pts[j][i].x, pts[j][i].y, pts[l][k].x, pts[l][k].y);
            }
            else {
              stroke(c, 100-distance*100/40);  // turns line color back to random gray color
              strokeWeight(3-distance*3/40);  // thickness of lines that follow mouse
              line(pts[j][i].x+mouse.x+mouse.y, pts[j][i].y+mouse.y+mouse.x, pts[l][k].x+mouse.x+mouse.y, pts[l][k].y+mouse.y+mouse.x); 

              stroke(255);  // makes lines white
              strokeWeight(2); // thickness of white lines
              line(pts[j][i].x, pts[j][i].y, pts[l][k].x, pts[l][k].y);  // draws white lines
            }
          }
        }
      }
    }
  }


  if (c < 200) {
    c += 0.05f;
  }
  else {
    c= 200;
  }
  
    if(dosave) {
    endRaw();
    dosave=false;
  }

}

public void mousePressed() {
  //if (key == 's') { 
    dosave=true;
  }
//}

  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#FFFFFF", "MIT4_112F12_Code_Ex1" });
  }
}
