import unittest
import sys
import time

import sequence_sol as sequence

if sys.hexversion < 0x02050000:
    print "6.006 code was designed for Python 2.5, and you are running " + \
          "an older version. http://python.org/download"
    sys.exit()

class TestSequence(unittest.TestCase):
    def test1_tiny(self):
        """tiny tests"""
        self.seq_test([1], 1)
        self.seq_test([1, 1], 1)
        self.seq_test([1, 2], 2)
        self.seq_test([2, 1], 2)

    def test2_small(self):
        """small tests"""
        self.seq_test([1, 2, 3, 4, 5], 2)
        self.seq_test([6, 6, 6, 6, 6, 6, 6, 6, 6], 1)
        self.seq_test([10, 9, 8, 7, 6], 2)
    
    def test3_medium(self):
        """medium tests"""
        self.seq_test([1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 2, 2, 3, 3, 1, 1], 9)
        self.seq_test([1, 100, 1, 100, 1, 100, 1, 100, 1, 100, 1, 100, 1], 13)
        
    def test4_large(self):
        """large tests"""
        self.file_test('seq_100', 67)
        self.file_test('seq_500', 331)
        self.file_test('seq_1000', 682)
        
    def test5_huge(self):
        """huge test"""
        self.file_test('seq_5000', 3320)
        
    def file_test(self, file_name, best_length):
        """tests a file-based instance of the sequence problem"""
        s_file = open('data/' + file_name)
        length = int(s_file.readline())
        array = []
        for i in range(length):
            array.append(int(s_file.readline()))
        self.seq_test(array, best_length)

    def seq_test(self, array, best_length):
        """tests an instance of the sequence problem"""        
        answer = sequence.solve(array)        
        # valid indices
        for i in range(len(answer)):
            self.assert_(answer[i] >= 0 and answer[i] < len(array))
        # zig-zag sequence
        if len(answer) > 1:
            self.assertNotEqual(array[answer[1]], array[answer[0]])
            zig = array[answer[1]] > array[answer[0]]
            for i in range(2, len(answer)):
                self.assertNotEqual(array[answer[i]], array[answer[i - 1]])
                new_zig = array[answer[i]] > array[answer[i - 1]]
                self.assertNotEqual(zig, new_zig)
                zig = new_zig
        # best length
        self.assertEqual(best_length, len(answer))
        
if __name__ == '__main__':
    unittest.main(argv = unittest.sys.argv + ['--verbose'])
