/*  Incremental root finder based on the Newton Method
 *  (c) 2008 Victor Costan
 *  This code is freely distributable under the terms of the MIT license.
 *--------------------------------------------------------------------------*/

function generateLines(outputTarget, numLines, viewportLines, lineSize, generator, emphasizer) {
	outputTarget = $(outputTarget);
	
	var lineAppender = function(line) {
		var lineQueue = {scope: 'line', position: 'end'};
		var charQueue = {scope: 'char', position: 'end'};
		
		if(line >= numLines)
			return;
		if(line >= viewportLines)
			$('output_line_' + (line - 
viewportLines).toString()).fade({duration: 0.05 * lineSize, queue: 
lineQueue});
			 
		var lineDiv = new Element('div', {id: 'output_line_' + line.toString()});
		outputTarget.appendChild(lineDiv);
		var lineDigits = generator.getResultPiece(lineSize * line, lineSize * (line + 1) - 1);
		for(var column = 0; column < lineSize; column++) {			
			var columnDigit = lineDigits.substr(column, 1);
			var columnSpan = new Element('span', {id: 'output_line' + line.toString() + '_column_' + column.toString()});
			columnSpan.update(columnDigit);
			if(emphasizer(columnDigit, lineSize * line + column))
				columnSpan.addClassName('emphasized');
			columnSpan.hide();
			lineDiv.appendChild(columnSpan);
			if(column + 1 < lineSize)
				columnSpan.appear({duration: 0.05, 
queue: charQueue, direction: 'bottom-left'});
			else
				columnSpan.appear({duration: 0.05, 
queue: charQueue, afterFinish: function() { lineAppender(line + 1) } });
		}				
	}
	lineAppender(0);
}
