/*  Incremental root finder based on the Newton Method
 *  (c) 2008 Victor Costan
 *  This code is freely distributable under the terms of the MIT license.
 *--------------------------------------------------------------------------*/

var IncrementalNewton = Class.create({
	initialize: function(fx, dfx) {
		this.zero = new BigInteger("0", 10);
		this.one = new BigInteger("1", 10);
		this.two = new BigInteger("2", 10);
		this.ten = new BigInteger("10", 10);
		this.fx = fx;
		this.dfx = dfx;
	},
	
	setInitial: function(initial) {
		this.setFractionalInitial(initial, 0);
	},
	
	setFractionalInitial: function(initial, precision) {
		this.x = new BigInteger(initial.toString(), 10);
		this.precision = precision;
	},
	
	getPrecision: function() {
		return this.precision;
	},

	addPrecision: function(extraPrecision) {
		this.precision += extraPrecision;
		var multiplier = this.ten.pow(extraPrecision);
		this.x = this.x.multiply(multiplier);
		
		this.newtonMagic();
	},
	
	getResultPiece: function(start, end) {
		if(this.precision < end + 1)
			this.addPrecision(end + 1 - this.precision);
			
		var strsult = this.x.toString();
		if (strsult.length <= this.precision)
			strsult = "0." + "0".times(this.precision - strsult.length) + strsult;
		else {
			var breakPoint = strsult.length - this.precision;
			strsult = strsult.substr(0, breakPoint) + "." + strsult.substr(breakPoint, this.precision);
		}
		
		return strsult.substr(start, end - start + 1);
	},
	
	newtonMagic: function() {
		while (true) {			
			// iterate
			var fatx = this.fx(this.x, this.precision);
			var dfatx = this.dfx(this.x, this.precision);
			var xn = this.x.multiply(dfatx).subtract(fatx).divide(dfatx);
			
			// see if we're done
			if(xn.compareTo(this.x) == 0)
				return;
			this.x = xn;		
		}		
	}
})
