/*  Incremental computations based on newton.js
 *  (c) 2008 Victor Costan
 *  This code is freely distributable under the terms of the MIT license.
 *--------------------------------------------------------------------------*/

function incremental_sqrt(n) {
	var rn = new BigInteger(n.toString(), 10);
	var two = new BigInteger("2", 10);
	var hundred = new BigInteger("100", 10);
	
	fx = function(x, precision) {
		// f(x) = x ** 2 - n
		return x.pow(2).subtract(rn.multiply(hundred.pow(precision)));
	}
	dfx = function(x, precision) {
		// df(x)/dx = 2 * x
		return x.multiply(two);
	}
	
	sq = new IncrementalNewton(fx, dfx);
	sq.setInitial(1);
	sq.addPrecision(10);
	return sq;
}

function incremental_catalans(interleave) {
	var two = new BigInteger("2", 10);
	var ten = new BigInteger("10", 10);
	var rn = ten.pow(interleave);

	fx = function(x, precision) {
		// f(x) = x**2 - n * x + 1 = x * (x - n) + 1
		var multiplier = ten.pow(precision);
		var scaledn = rn.multiply(multiplier);
		var z = x.multiply(x.subtract(scaledn)).add(multiplier.pow(2));
		return z;
	}
	dfx = function(x, precision) {
		// df(x)/dx = 2 * x - n
		var scaledn = rn.multiply(ten.pow(precision));
		var z = x.multiply(two).subtract(scaledn);
		return z;
	}
	
	ct = new IncrementalNewton(fx, dfx);
	ct.setFractionalInitial(1, interleave);
	ct.addPrecision(interleave * 4);
	return ct;
}
