class positive_infinity:
    "bigger than any object other than itself"
    def __cmp__(self, other):
        if isinstance(other, self.__class__):
            return 0
        return 1

def solve(dimensions):
    """
    Find a best way to multiply matrices with the given dimensions.
    Return an execution plan that looks like [[0, 1], [2, 3]] for ((AB)(CD)) 
    """
    
    def multiplication_cost(start1, end1, start2, end2):
        """The cost of multiplying (start1...end1) with (start2...end2).""" 
        assert dimensions[end1][1] == dimensions[start2][0]
        return dimensions[start1][0] * dimensions[start2][0] * dimensions[end2][1]
    
    return []
