class positive_infinity:
    "bigger than any object other than itself"
    def __cmp__(self, other):
        if isinstance(other, self.__class__):
            return 0
        return 1

def solve(dimensions):
    """
    Find a best way to multiply matrices with the given dimensions.
    Return an execution plan that looks like [[0, 1], [2, 3]] for ((AB)(CD)) 
    """
    
    def multiplication_cost(start1, end1, start2, end2):
        """The cost of multiplying (start1...end1) with (start2...end2).""" 
        assert dimensions[end1][1] == dimensions[start2][0]
        return dimensions[start1][0] * dimensions[start2][0] * dimensions[end2][1]
    
    dp = [[positive_infinity() for i in range(len(dimensions))] for j in range(len(dimensions))]
    pi = [[None for i in range(len(dimensions))] for j in range(len(dimensions))]
    
    # base case
    for i in range(len(dimensions)):
        dp[i][i] = 0
    
    for delta in range(1, len(dimensions)):
        for i in range(len(dimensions)):
            j = i + delta
            if j >= len(dimensions):
                break
            for k in range(i, j):
                cost = dp[i][k] + dp[k+1][j] + multiplication_cost(i, k, k + 1, j)
                if cost < dp[i][j]:
                    dp[i][j] = cost
                    pi[i][j] = k
    
    def solution(i, j):
        if i == j:
            return i
        else:
            return [solution(i, pi[i][j]), solution(pi[i][j] + 1, j)]            
    return solution(0, len(dimensions) - 1)
