;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: Counter16_SONAR.inc
;;   Version: 2.3, Updated on 2004/07/29 at 17:41:29
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the Counter16 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for Counter16_SONAR API's.
;--------------------------------------------------

Counter16_SONAR_CONTROL_REG_START_BIT:     equ 0x01    ; Control register start bit
Counter16_SONAR_INT_REG:                   equ 0x0df
Counter16_SONAR_INT_MASK:                  equ 0x80


;--------------------------------------------------
; Constants for Counter16_SONAR user defined values
;--------------------------------------------------

Counter16_SONAR_PERIOD:                    equ 0xffff
Counter16_SONAR_COMPARE_VALUE:             equ 0x0


;--------------------------------------------------
; Register Address Constants for Counter16_SONAR
;--------------------------------------------------

Counter16_SONAR_COUNTER_LSB_REG:       equ 0x58   ; DR0 Counter register
Counter16_SONAR_COUNTER_MSB_REG:       equ 0x5c
Counter16_SONAR_PERIOD_LSB_REG:        equ 0x59   ; DR1 Period register
Counter16_SONAR_PERIOD_MSB_REG:        equ 0x5d
Counter16_SONAR_COMPARE_LSB_REG:       equ 0x5a   ; DR2 CompareValue register
Counter16_SONAR_COMPARE_MSB_REG:       equ 0x5e
Counter16_SONAR_CONTROL_LSB_REG:       equ 0x5b   ; Control register
Counter16_SONAR_CONTROL_MSB_REG:       equ 0x5f
Counter16_SONAR_FUNC_LSB_REG:          equ 0x58   ; Function register
Counter16_SONAR_FUNC_MSB_REG:          equ 0x5c
Counter16_SONAR_INPUT_LSB_REG:         equ 0x59   ; Input register
Counter16_SONAR_INPUT_MSB_REG:         equ 0x5d
Counter16_SONAR_OUTPUT_LSB_REG:        equ 0x5a   ; Output register
Counter16_SONAR_OUTPUT_MSB_REG:        equ 0x5e


;--------------------------------------------------
; Counter16_SONAR Macro 'Functions'
;--------------------------------------------------

   macro Counter16_SONAR_Start_M
   or    reg[Counter16_SONAR_CONTROL_LSB_REG],  Counter16_SONAR_CONTROL_REG_START_BIT
   endm

   macro Counter16_SONAR_Stop_M
   and   reg[Counter16_SONAR_CONTROL_LSB_REG], ~Counter16_SONAR_CONTROL_REG_START_BIT
   endm

   macro Counter16_SONAR_EnableInt_M
   M8C_EnableIntMask Counter16_SONAR_INT_REG, Counter16_SONAR_INT_MASK
   endm

   macro Counter16_SONAR_DisableInt_M
   M8C_DisableIntMask Counter16_SONAR_INT_REG, Counter16_SONAR_INT_MASK
   endm


; end of file Counter16_SONAR.inc

