;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: I2CHW_1.inc
;;   Version: 2.0, Updated on 2004/08/16 at 13:05:50
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the I2Cs user module interface
;;               for the 25/26xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************



;I2CHW_1_SLAVE_ADDR:                        equ       @Slave_Addrh     ;     Permanent Slave Address

;--------------------------------------------------
;   I2CHW_1 API Constants
;--------------------------------------------------

I2CHW_1_INT_REG:                           equ 0x0de
I2CHW_1_INT_MASK:                          equ 0x01



;-----------------
; Misc. equates
;-----------------

;I2CHW_1_RsrcStatus byte, Status Bit definitions
I2CHW_RD_NOERR:                             equ 0x1   ;read completed without errors
I2CHW_RD_OVERFLOW:                          equ 0x2   ;master read more bytes than were contained in read buffer
I2CHW_RD_COMPLETE:                          equ 0x4   ;last read transaction complete
I2CHW_READFLASH:                            equ 0x8   ;set- next read will use flash read buffer, clear- next read will use ram read buffer
I2CHW_WR_NOERR:                             equ 0x10  ;write completed without errors
I2CHW_WR_OVERFLOW:                          equ 0x20  ;received bytes exceeded write buffer length
I2CHW_WR_COMPLETE:                          equ 0x40  ;Master uses this definition, slave uses that below.
I2CHW_ISR_NEW_ADDR:                         equ 0x40  ;New addre received (can infer that previous transaction is complete)
I2CHW_ISR_ACTIVE:                           equ 0x80  ;ISR for I2C_slave is is active


fI2C_NAKnextWr:                             equ 0x04  ;flag to tell slave to nak next byte from master


;=== I2C equates ===



I2CHW_1_SCR:    equ d7h;:        equ 0xd7 ;Slave SCR register location bank 0

I2CM_BUSERR:    equ 0x80
I2CM_LOSTARB:   equ 0x40
I2C_STOP_ST:    equ 0x20
I2C_ACKOUT:     equ 0x10
I2C_ADDRIN:     equ 0x08
I2C_TX:         equ 0x04 ;compliment is RX
I2C_LST_BIT:    equ 0x02
I2C_BYTE_COMPL: equ 0x01

I2CHW_1_CFG:    equ d6h;:        equ 0xd6 ;I2C CFG register location bank 0

I2C_BUSERRIE:   equ 0x20
I2C_STOPIE:     equ 0x10
I2C_CLKR1:      equ 0x08
I2C_CLKR0:      equ 0x04
I2C_M_EN:       equ 0x02
I2C_S_EN:       equ 0x01

I2CHW_1_MSCR:   equ d9h;:       equ 0xd9 ;Master SCR register location bank 0

I2CM_BUSBUSY:   equ 0x08
I2CM_MASTEROP:  equ 0x04
I2CM_RESTRT:    equ 0x02
I2CM_SNDSTRT:   equ 0x01

I2CHW_1_DR: equ d8h;:         equ 0xd8 ;I2C DATA register location bank 0


;Equates used as conditional compile keys


I2CHW_1_READ_BUFTYPE:                       equ 0x1

I2CHW_1_READ_FLASH:                         equ I2CHW_1_READ_BUFTYPE & 0x01

I2CHW_1_24MHZ_FIX:                          equ 0x0

I2CHW_1_THROTTLE_CLK_RATE:                  equ I2CHW_1_24MHZ_FIX & 0x01



;I2C_(status and control) reg write macro
;----------------------------------------------------
;  I2C_SCR and I2C_MSCR reg write macro
;
;  Use the following macros to write to the I2C_SCR register
;  Usage:    SetI2C_MSCR WRITE_VALUE
;            SetI2C_SCR  WRITE_VALUE
;            SetI2C_CFG  WRITE_VALUE
;
;  where WRITE_VALUE is the data to be writen
;
;----------------------------------------------------
; Write to the  I2CHW_1_SCR register
    macro SetI2CHW_1_SCR
    or    F, FLAG_XIO_MASK                    ; set bank1
        push  X
        mov   X, A                        ; if data for I2C_SCR was in A save it in X
        mov   A, reg[OSC_CR0]             ;
        push  A
        and   A, ~0x07
        or    A, 0x1
        mov   reg[OSC_CR0], A                     ; throttle the clock down to 6Mhz
        and   F, ~FLAG_XIO_MASK                   ; set bank0
        mov   A, X                        ; if the operation uses data in A get it out of X
    mov   reg[0xD7], @0               ; write data to reg[I2C_SCR]
    or    F, FLAG_XIO_MASK                    ; set bank1
        pop   A                           ; restore original clock speed
        mov   reg[OSC_CR0], A
        and   F, ~FLAG_XIO_MASK                   ; set bank0
        mov   A, X                        ; if A was data restore it from X now
        pop   X                           ; restore original accumulator
    endm

; Write to the  I2CHW_1_MSCR register
    macro SetI2CHW_1_MSCR
    or    F, FLAG_XIO_MASK                    ; set bank1
        push  X
        mov   X, A                        ; if data for I2C_SCR was in A save it in X
        mov   A, reg[OSC_CR0]             ;
        push  A
        and   A, ~0x07
        or    A, 0x01
        mov   reg[OSC_CR0], A                     ; throttle the clock down to 6Mhz
        and   F, ~FLAG_XIO_MASK                   ; set bank0
        mov   A, X                        ; if the operation uses data in A get it out of X
    mov   reg[0xD9], @0               ; write data to reg[I2C_MSCR]
    or    F, FLAG_XIO_MASK                    ; set bank1
        pop   A                           ; restore original clock speed
        mov   reg[OSC_CR0], A
        and   F, ~FLAG_XIO_MASK                   ; set bank0
        mov   A, X                        ; if A was data restore it from X now
        pop   X                           ; restore original accumulator
    endm

; SET a bit in the  I2CHW_1_CFG register
    macro BitSetI2CHW_1_CFG
    or    F, FLAG_XIO_MASK                    ; set bank1
        push  A
        mov   A, reg[OSC_CR0]             ;
        push  A
        and   A, ~0x07
        or    A, 0x02
        mov   reg[OSC_CR0], A                     ; throttle the clock down to 12Mhz
        and   F, ~FLAG_XIO_MASK                   ; set bank0
    or    reg[0xD6], @0               ; write data to reg[I2C_SCR]
    or    F, FLAG_XIO_MASK                    ; set bank1
        pop   A                           ; restore original clock speed
        mov   reg[OSC_CR0], A
        and   F, ~FLAG_XIO_MASK                   ; set bank0
        pop   A                           ; restore original accumulator
    endm

; CLR a bit in the  I2CHW_1_CFG register
;
;NOTE: clears the bits set to ONE in the input
;
    macro BitClrI2CHW_1_CFG
    or    F, FLAG_XIO_MASK                    ; set bank1
        push  A
        mov   A, reg[OSC_CR0]             ;
        push  A
        and   A, ~0x07
        or    A, 0x02
        mov   reg[OSC_CR0], A                     ; throttle the clock down to 12Mhz
        and   F, ~FLAG_XIO_MASK                   ; set bank0
    and   reg[0xD6], ~@0              ; write data to reg[I2C_SCR]
    or    F, FLAG_XIO_MASK                    ; set bank1
        pop   A                           ; restore original clock speed
        mov   reg[OSC_CR0], A
        and   F, ~FLAG_XIO_MASK                   ; set bank0
        pop   A                           ; restore original accumulator
    endm


; end of file I2CHW_1.inc

