;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: Timer16_SONAR.inc
;;   Version: 2.3, Updated on 2004/07/29 at 17:47:46
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the Timer16 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for Timer16_SONAR API's.
;--------------------------------------------------

Timer16_SONAR_CONTROL_REG_START_BIT:       equ 0x01    ; Control register start bit
Timer16_SONAR_INT_REG:                     equ 0x0df
Timer16_SONAR_INT_MASK:                    equ 0x80


;--------------------------------------------------
; Constants for Timer16_SONAR user defined values
;--------------------------------------------------

Timer16_SONAR_PERIOD:                      equ 0x0
Timer16_SONAR_COMPARE_VALUE:               equ 0x0


;--------------------------------------------------
; Register Address Constants for Timer16_SONAR
;--------------------------------------------------

Timer16_SONAR_COUNTER_LSB_REG:         equ 0x58   ; DR0 Counter register
Timer16_SONAR_COUNTER_MSB_REG:         equ 0x5c
Timer16_SONAR_PERIOD_LSB_REG:          equ 0x59   ; DR1 Period register
Timer16_SONAR_PERIOD_MSB_REG:          equ 0x5d
Timer16_SONAR_COMPARE_LSB_REG:         equ 0x5a   ; DR2 CompareValue register
Timer16_SONAR_COMPARE_MSB_REG:         equ 0x5e
Timer16_SONAR_CONTROL_LSB_REG:         equ 0x5b   ; Control register
Timer16_SONAR_CONTROL_MSB_REG:         equ 0x5f
Timer16_SONAR_FUNC_LSB_REG:            equ 0x58   ; Function register
Timer16_SONAR_FUNC_MSB_REG:            equ 0x5c
Timer16_SONAR_INPUT_LSB_REG:           equ 0x59   ; Input register
Timer16_SONAR_INPUT_MSB_REG:           equ 0x5d
Timer16_SONAR_OUTPUT_LSB_REG:          equ 0x5a   ; Output register
Timer16_SONAR_OUTPUT_MSB_REG:          equ 0x5e


;--------------------------------------------------
; Timer16_SONAR Macro 'Functions'
;--------------------------------------------------

   macro Timer16_SONAR_Start_M
   or    reg[Timer16_SONAR_CONTROL_LSB_REG],  Timer16_SONAR_CONTROL_REG_START_BIT
   endm

   macro Timer16_SONAR_Stop_M
   and   reg[Timer16_SONAR_CONTROL_LSB_REG], ~Timer16_SONAR_CONTROL_REG_START_BIT
   endm

   macro Timer16_SONAR_EnableInt_M
   M8C_EnableIntMask Timer16_SONAR_INT_REG, Timer16_SONAR_INT_MASK
   endm

   macro Timer16_SONAR_DisableInt_M
   M8C_DisableIntMask Timer16_SONAR_INT_REG, Timer16_SONAR_INT_MASK
   endm


; end of file Timer16_SONAR.inc
