#include "config.h"
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules

#include <flashblock.h>

params_t params;

#pragma abs_address: 0x7fc0
params_t defaultparams={2, 5};
#pragma end_abs_address

void loadPrefs()
{
	unsigned char v;

	FLASH_READ_STRUCT frs;
	 
	frs.wARG_BlockId = FLASHBLOCKNUMBER;		// Block Id to write
	frs.pARG_FlashBuffer = (unsigned char*) &params;
	frs.wARG_ReadCount = sizeof(params);
	
	FlashReadBlock(&frs);

	// activate the parameters.
	params.drivemode&=(DRIVEMODE_SWAPLR | DRIVEMODE_LEFTINV | DRIVEMODE_RIGHTINV);

	PWM8_BAUD_Stop();

	if (params.baud==1)
		v=25;
	else if (params.baud==2)
		v=23;
	else if (params.baud==3)
		v=11;
	else
	{
		params.baud=0;
		v=51; // use default baud of 115.2kbps
	}
		
	PWM8_BAUD_WritePulseWidth(v/2);
	PWM8_BAUD_WritePeriod(v);
	
	PWM8_BAUD_Start();

}

unsigned char savePrefs()
{
 FLASH_WRITE_STRUCT fws;
 
 fws.wARG_BlockId = FLASHBLOCKNUMBER;		// Block Id to write
 fws.pARG_FlashBuffer = (unsigned char*)  &params;
 fws.cARG_Temperature = 25;	
 
 return bFlashWriteBlock(&fws);
}
