;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM16_SERVO.inc
;;   Version: 2.3, Updated on 2004/07/19 at 16:37:35
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the PWM16 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM16_SERVO API's.
;--------------------------------------------------

PWM16_SERVO_CONTROL_REG_START_BIT:         equ 0x01    ; Control register start bit
PWM16_SERVO_INT_REG:                       equ 0x0df
PWM16_SERVO_INT_MASK:                      equ 0x20


;--------------------------------------------------
; Constants for PWM16_SERVO user defined values
;--------------------------------------------------

PWM16_SERVO_PERIOD:                        equ 0xfffe
PWM16_SERVO_PULSE_WIDTH:                   equ 0x0


;--------------------------------------------------
; Register Address Constants for PWM16_SERVO
;--------------------------------------------------

PWM16_SERVO_COUNTER_LSB_REG:           equ 0x50   ; DR0 Count register
PWM16_SERVO_COUNTER_MSB_REG:           equ 0x54
PWM16_SERVO_PERIOD_LSB_REG:            equ 0x51   ; DR1 Period register
PWM16_SERVO_PERIOD_MSB_REG:            equ 0x55
PWM16_SERVO_COMPARE_LSB_REG:           equ 0x52   ; DR2 Compare register
PWM16_SERVO_COMPARE_MSB_REG:           equ 0x56
PWM16_SERVO_CONTROL_LSB_REG:           equ 0x53   ; Control register
PWM16_SERVO_CONTROL_MSB_REG:           equ 0x57
PWM16_SERVO_FUNC_LSB_REG:              equ 0x50   ; Function register
PWM16_SERVO_FUNC_MSB_REG:              equ 0x54
PWM16_SERVO_INPUT_LSB_REG:             equ 0x51   ; Input register
PWM16_SERVO_INPUT_MSB_REG:             equ 0x55
PWM16_SERVO_OUTPUT_LSB_REG:            equ 0x52   ; Output register
PWM16_SERVO_OUTPUT_MSB_REG:            equ 0x56


;--------------------------------------------------
; PWM16_SERVO Macro 'Functions'
;--------------------------------------------------

   macro PWM16_SERVO_Start_M
   or    reg[PWM16_SERVO_CONTROL_LSB_REG],  PWM16_SERVO_CONTROL_REG_START_BIT
   endm

   macro PWM16_SERVO_Stop_M
   and   reg[PWM16_SERVO_CONTROL_LSB_REG], ~PWM16_SERVO_CONTROL_REG_START_BIT
   endm

   macro PWM16_SERVO_EnableInt_M
   M8C_EnableIntMask PWM16_SERVO_INT_REG, PWM16_SERVO_INT_MASK
   endm

   macro PWM16_SERVO_DisableInt_M
   M8C_DisableIntMask PWM16_SERVO_INT_REG, PWM16_SERVO_INT_MASK
   endm


; end of file PWM16_SERVO.inc

