;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_BAUD.inc
;;   Version: 2.3, Updated on 2004/07/19 at 16:37:39
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_BAUD API's.
;--------------------------------------------------

PWM8_BAUD_CONTROL_REG_START_BIT:           equ 0x01    ; Control register start bit
PWM8_BAUD_INT_REG:                         equ 0x0e1
PWM8_BAUD_INT_MASK:                        equ 0x02


;--------------------------------------------------
; Constants for PWM8_BAUD user defined values
;--------------------------------------------------

PWM8_BAUD_PERIOD:                          equ 0x33
PWM8_BAUD_PULSE_WIDTH:                     equ 0x1a


;--------------------------------------------------
; Register Address Constants for PWM8_BAUD
;--------------------------------------------------

PWM8_BAUD_COUNTER_REG:                 equ 0x24   ; DR0 Count register
PWM8_BAUD_PERIOD_REG:                  equ 0x25   ; DR1 Period register
PWM8_BAUD_COMPARE_REG:                 equ 0x26   ; DR2 Compare register
PWM8_BAUD_CONTROL_REG:                 equ 0x27   ; Control register
PWM8_BAUD_FUNC_REG:                    equ 0x24   ; Function register
PWM8_BAUD_INPUT_REG:                   equ 0x25   ; Input register
PWM8_BAUD_OUTPUT_REG:                  equ 0x26   ; Output register


;--------------------------------------------------
; PWM8_BAUD Macro 'Functions'
;--------------------------------------------------

   macro PWM8_BAUD_Start_M
   or    reg[PWM8_BAUD_CONTROL_REG],  PWM8_BAUD_CONTROL_REG_START_BIT
   endm

   macro PWM8_BAUD_Stop_M
   and   reg[PWM8_BAUD_CONTROL_REG], ~PWM8_BAUD_CONTROL_REG_START_BIT
   endm

   macro PWM8_BAUD_EnableInt_M
   M8C_EnableIntMask PWM8_BAUD_INT_REG, PWM8_BAUD_INT_MASK
   endm

   macro PWM8_BAUD_DisableInt_M
   M8C_DisableIntMask PWM8_BAUD_INT_REG, PWM8_BAUD_INT_MASK
   endm


; end of file PWM8_BAUD.inc
