//*****************************************************************************
//*****************************************************************************
//  FILENAME: PWM8_CLOCK.h
//   Version: 2.3, Updated on 2004/07/19 at 16:37:39
//  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
//
//  DESCRIPTION: PWM8 User Module C Language interface file
//               for the 22/24/27/29xxx PSoC family of devices
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************

#include <m8c.h>

#pragma fastcall16 PWM8_CLOCK_EnableInt
#pragma fastcall16 PWM8_CLOCK_DisableInt
#pragma fastcall16 PWM8_CLOCK_Start
#pragma fastcall16 PWM8_CLOCK_Stop
#pragma fastcall16 PWM8_CLOCK_bReadCounter              // Read  DR0
#pragma fastcall16 PWM8_CLOCK_WritePeriod               // Write DR1
#pragma fastcall16 PWM8_CLOCK_bReadPulseWidth           // Read  DR2
#pragma fastcall16 PWM8_CLOCK_WritePulseWidth           // Write DR2

// The following symbols are deprecated.
// They may be omitted in future releases
//
#pragma fastcall16 bPWM8_CLOCK_ReadCounter              // Read  DR0 (Deprecated)
#pragma fastcall16 bPWM8_CLOCK_ReadPulseWidth           // Read  DR2 (Deprecated)


//-------------------------------------------------
// Prototypes of the PWM8_CLOCK API.
//-------------------------------------------------

extern void PWM8_CLOCK_EnableInt(void);                        // Proxy Class 1
extern void PWM8_CLOCK_DisableInt(void);                       // Proxy Class 1
extern void PWM8_CLOCK_Start(void);                            // Proxy Class 1
extern void PWM8_CLOCK_Stop(void);                             // Proxy Class 1
extern BYTE PWM8_CLOCK_bReadCounter(void);                     // Proxy Class 2
extern void PWM8_CLOCK_WritePeriod(BYTE bPeriod);              // Proxy Class 1
extern BYTE PWM8_CLOCK_bReadPulseWidth(void);                  // Proxy Class 1
extern void PWM8_CLOCK_WritePulseWidth(BYTE bPulseWidth);      // Proxy Class 1

// The following functions are deprecated.
// They may be omitted in future releases
//
extern BYTE bPWM8_CLOCK_ReadCounter(void);            // Deprecated
extern BYTE bPWM8_CLOCK_ReadPulseWidth(void);         // Deprecated


//--------------------------------------------------
// Constants for PWM8_CLOCK API's.
//--------------------------------------------------

#define PWM8_CLOCK_CONTROL_REG_START_BIT       ( 0x01 )
#define PWM8_CLOCK_INT_REG_ADDR                ( 0x0e1 )
#define PWM8_CLOCK_INT_MASK                    ( 0x01 )


//--------------------------------------------------
// Constants for PWM8_CLOCK user defined values
//--------------------------------------------------

#define PWM8_CLOCK_PERIOD                      ( 0x1a )
#define PWM8_CLOCK_PULSE_WIDTH                 ( 0x0d )


//-------------------------------------------------
// Register Addresses for PWM8_CLOCK
//-------------------------------------------------

#pragma ioport  PWM8_CLOCK_COUNTER_REG: 0x020              //DR0 Count register
BYTE            PWM8_CLOCK_COUNTER_REG;
#pragma ioport  PWM8_CLOCK_PERIOD_REG:  0x021              //DR1 Period register
BYTE            PWM8_CLOCK_PERIOD_REG;
#pragma ioport  PWM8_CLOCK_COMPARE_REG: 0x022              //DR2 Compare register
BYTE            PWM8_CLOCK_COMPARE_REG;
#pragma ioport  PWM8_CLOCK_CONTROL_REG: 0x023              //Control register
BYTE            PWM8_CLOCK_CONTROL_REG;
#pragma ioport  PWM8_CLOCK_FUNC_REG:    0x120              //Function register
BYTE            PWM8_CLOCK_FUNC_REG;
#pragma ioport  PWM8_CLOCK_INPUT_REG:   0x121              //Input register
BYTE            PWM8_CLOCK_INPUT_REG;
#pragma ioport  PWM8_CLOCK_OUTPUT_REG:  0x122              //Output register
BYTE            PWM8_CLOCK_OUTPUT_REG;
#pragma ioport  PWM8_CLOCK_INT_REG:       0x0e1            //Interrupt Mask Register
BYTE            PWM8_CLOCK_INT_REG;


//-------------------------------------------------
// PWM8_CLOCK Macro 'Functions'
//-------------------------------------------------

#define PWM8_CLOCK_Start_M \
   PWM8_CLOCK_CONTROL_REG |=  PWM8_CLOCK_CONTROL_REG_START_BIT

#define PWM8_CLOCK_Stop_M  \
   PWM8_CLOCK_CONTROL_REG &= ~PWM8_CLOCK_CONTROL_REG_START_BIT

#define PWM8_CLOCK_EnableInt_M   \
   M8C_EnableIntMask(PWM8_CLOCK_INT_REG, PWM8_CLOCK_INT_MASK)

#define PWM8_CLOCK_DisableInt_M  \
   M8C_DisableIntMask(PWM8_CLOCK_INT_REG, PWM8_CLOCK_INT_MASK)


// end of file PWM8_CLOCK.h
