;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_CLOCK.inc
;;   Version: 2.3, Updated on 2004/07/19 at 16:37:39
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_CLOCK API's.
;--------------------------------------------------

PWM8_CLOCK_CONTROL_REG_START_BIT:          equ 0x01    ; Control register start bit
PWM8_CLOCK_INT_REG:                        equ 0x0e1
PWM8_CLOCK_INT_MASK:                       equ 0x01


;--------------------------------------------------
; Constants for PWM8_CLOCK user defined values
;--------------------------------------------------

PWM8_CLOCK_PERIOD:                         equ 0x1a
PWM8_CLOCK_PULSE_WIDTH:                    equ 0x0d


;--------------------------------------------------
; Register Address Constants for PWM8_CLOCK
;--------------------------------------------------

PWM8_CLOCK_COUNTER_REG:                equ 0x20   ; DR0 Count register
PWM8_CLOCK_PERIOD_REG:                 equ 0x21   ; DR1 Period register
PWM8_CLOCK_COMPARE_REG:                equ 0x22   ; DR2 Compare register
PWM8_CLOCK_CONTROL_REG:                equ 0x23   ; Control register
PWM8_CLOCK_FUNC_REG:                   equ 0x20   ; Function register
PWM8_CLOCK_INPUT_REG:                  equ 0x21   ; Input register
PWM8_CLOCK_OUTPUT_REG:                 equ 0x22   ; Output register


;--------------------------------------------------
; PWM8_CLOCK Macro 'Functions'
;--------------------------------------------------

   macro PWM8_CLOCK_Start_M
   or    reg[PWM8_CLOCK_CONTROL_REG],  PWM8_CLOCK_CONTROL_REG_START_BIT
   endm

   macro PWM8_CLOCK_Stop_M
   and   reg[PWM8_CLOCK_CONTROL_REG], ~PWM8_CLOCK_CONTROL_REG_START_BIT
   endm

   macro PWM8_CLOCK_EnableInt_M
   M8C_EnableIntMask PWM8_CLOCK_INT_REG, PWM8_CLOCK_INT_MASK
   endm

   macro PWM8_CLOCK_DisableInt_M
   M8C_DisableIntMask PWM8_CLOCK_INT_REG, PWM8_CLOCK_INT_MASK
   endm


; end of file PWM8_CLOCK.inc
