//*****************************************************************************
//*****************************************************************************
//  FILENAME: PWM8_SERVOCLK.h
//   Version: 2.3, Updated on 2004/07/19 at 16:37:39
//  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
//
//  DESCRIPTION: PWM8 User Module C Language interface file
//               for the 22/24/27/29xxx PSoC family of devices
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************

#include <m8c.h>

#pragma fastcall16 PWM8_SERVOCLK_EnableInt
#pragma fastcall16 PWM8_SERVOCLK_DisableInt
#pragma fastcall16 PWM8_SERVOCLK_Start
#pragma fastcall16 PWM8_SERVOCLK_Stop
#pragma fastcall16 PWM8_SERVOCLK_bReadCounter              // Read  DR0
#pragma fastcall16 PWM8_SERVOCLK_WritePeriod               // Write DR1
#pragma fastcall16 PWM8_SERVOCLK_bReadPulseWidth           // Read  DR2
#pragma fastcall16 PWM8_SERVOCLK_WritePulseWidth           // Write DR2

// The following symbols are deprecated.
// They may be omitted in future releases
//
#pragma fastcall16 bPWM8_SERVOCLK_ReadCounter              // Read  DR0 (Deprecated)
#pragma fastcall16 bPWM8_SERVOCLK_ReadPulseWidth           // Read  DR2 (Deprecated)


//-------------------------------------------------
// Prototypes of the PWM8_SERVOCLK API.
//-------------------------------------------------

extern void PWM8_SERVOCLK_EnableInt(void);                        // Proxy Class 1
extern void PWM8_SERVOCLK_DisableInt(void);                       // Proxy Class 1
extern void PWM8_SERVOCLK_Start(void);                            // Proxy Class 1
extern void PWM8_SERVOCLK_Stop(void);                             // Proxy Class 1
extern BYTE PWM8_SERVOCLK_bReadCounter(void);                     // Proxy Class 2
extern void PWM8_SERVOCLK_WritePeriod(BYTE bPeriod);              // Proxy Class 1
extern BYTE PWM8_SERVOCLK_bReadPulseWidth(void);                  // Proxy Class 1
extern void PWM8_SERVOCLK_WritePulseWidth(BYTE bPulseWidth);      // Proxy Class 1

// The following functions are deprecated.
// They may be omitted in future releases
//
extern BYTE bPWM8_SERVOCLK_ReadCounter(void);            // Deprecated
extern BYTE bPWM8_SERVOCLK_ReadPulseWidth(void);         // Deprecated


//--------------------------------------------------
// Constants for PWM8_SERVOCLK API's.
//--------------------------------------------------

#define PWM8_SERVOCLK_CONTROL_REG_START_BIT    ( 0x01 )
#define PWM8_SERVOCLK_INT_REG_ADDR             ( 0x0df )
#define PWM8_SERVOCLK_INT_MASK                 ( 0x01 )


//--------------------------------------------------
// Constants for PWM8_SERVOCLK user defined values
//--------------------------------------------------

#define PWM8_SERVOCLK_PERIOD                   ( 0x02 )
#define PWM8_SERVOCLK_PULSE_WIDTH              ( 0x01 )


//-------------------------------------------------
// Register Addresses for PWM8_SERVOCLK
//-------------------------------------------------

#pragma ioport  PWM8_SERVOCLK_COUNTER_REG:  0x040          //DR0 Count register
BYTE            PWM8_SERVOCLK_COUNTER_REG;
#pragma ioport  PWM8_SERVOCLK_PERIOD_REG:   0x041          //DR1 Period register
BYTE            PWM8_SERVOCLK_PERIOD_REG;
#pragma ioport  PWM8_SERVOCLK_COMPARE_REG:  0x042          //DR2 Compare register
BYTE            PWM8_SERVOCLK_COMPARE_REG;
#pragma ioport  PWM8_SERVOCLK_CONTROL_REG:  0x043          //Control register
BYTE            PWM8_SERVOCLK_CONTROL_REG;
#pragma ioport  PWM8_SERVOCLK_FUNC_REG: 0x140              //Function register
BYTE            PWM8_SERVOCLK_FUNC_REG;
#pragma ioport  PWM8_SERVOCLK_INPUT_REG:    0x141          //Input register
BYTE            PWM8_SERVOCLK_INPUT_REG;
#pragma ioport  PWM8_SERVOCLK_OUTPUT_REG:   0x142          //Output register
BYTE            PWM8_SERVOCLK_OUTPUT_REG;
#pragma ioport  PWM8_SERVOCLK_INT_REG:       0x0df         //Interrupt Mask Register
BYTE            PWM8_SERVOCLK_INT_REG;


//-------------------------------------------------
// PWM8_SERVOCLK Macro 'Functions'
//-------------------------------------------------

#define PWM8_SERVOCLK_Start_M \
   PWM8_SERVOCLK_CONTROL_REG |=  PWM8_SERVOCLK_CONTROL_REG_START_BIT

#define PWM8_SERVOCLK_Stop_M  \
   PWM8_SERVOCLK_CONTROL_REG &= ~PWM8_SERVOCLK_CONTROL_REG_START_BIT

#define PWM8_SERVOCLK_EnableInt_M   \
   M8C_EnableIntMask(PWM8_SERVOCLK_INT_REG, PWM8_SERVOCLK_INT_MASK)

#define PWM8_SERVOCLK_DisableInt_M  \
   M8C_DisableIntMask(PWM8_SERVOCLK_INT_REG, PWM8_SERVOCLK_INT_MASK)


// end of file PWM8_SERVOCLK.h
