include "m8c.inc"

;-----------------------------------------------
; Variable Allocation
;-----------------------------------------------
AREA InterruptRAM (RAM, REL, CON)

_sleepcounter:
_SLEEP_COUNTER:
SLEEP_COUNTER:     BLK   2

export _sleepcounter
export _SLEEP_COUNTER
export SLEEP_ISR
export _SLEEP_ISR


AREA UserModules (ROM, REL, CON)

_SLEEP_ISR:
SLEEP_ISR:
	// we don't modify A or X, so we don't need
	// to save them.
	add [SLEEP_COUNTER+1], 0x01 //note: BIG Endian!
	adc [SLEEP_COUNTER+0], 0x00
	
	and reg[INT_CLR0], 0xbf ; we're already in bank 0 since F=0 on ISR entry
	
	reti