;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   TRIADC_1INT.asm
;;  Version: 2.2, Updated on 2004/08/05 at 10:19:32
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: TriADC Interrupt Service Routines
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2001-2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "TRIADC_1.inc"
include "memory.inc"

;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export _TRIADC_1_CNT1_ISR
export _TRIADC_1_CNT2_ISR
export _TRIADC_1_CNT3_ISR
export _TRIADC_1_PWM16_ISR
export  TRIADC_1_cCounter1U
export  TRIADC_1_cCounter2U
export  TRIADC_1_cCounter3U
export _TRIADC_1_iResult1
export  TRIADC_1_iResult1
export _TRIADC_1_iResult2
export  TRIADC_1_iResult2
export _TRIADC_1_iResult3
export  TRIADC_1_iResult3
export _TRIADC_1_bfStatus
export  TRIADC_1_bfStatus
export  TRIADC_1_bSampC

;-----------------------------------------------
; Variable Allocation
;-----------------------------------------------
AREA InterruptRAM(RAM, REL, CON)

 TRIADC_1_cCounter1U:     BLK   1  ;The Upper byte of the Counter
 TRIADC_1_cCounter2U:     BLK   1  ;The Upper byte of the Counter
 TRIADC_1_cCounter3U:     BLK   1  ;The Upper byte of the Counter
_TRIADC_1_iResult1:
 TRIADC_1_iResult1:       BLK   2  ;A/D value
_TRIADC_1_iResult2:
 TRIADC_1_iResult2:       BLK   2  ;A/D value
_TRIADC_1_iResult3:
 TRIADC_1_iResult3:       BLK   2  ;A/D value
_TRIADC_1_bfStatus:
 TRIADC_1_bfStatus:       BLK   1  ;Data Valid Flag
 TRIADC_1_bSampC:         BLK   1  ;# of times to run A/D


;-----------------------------------------------
;  EQUATES and TABLES
;-----------------------------------------------
; Constant Definitions
LowByte:   equ 1
HighByte:  equ 0


;@PSoC_UserCode_INIT@ (Do not change this line.)
;---------------------------------------------------
; Insert your custom declarations below this banner
;---------------------------------------------------

;------------------------
; Includes
;------------------------

	
;------------------------
;  Constant Definitions
;------------------------


;------------------------
; Variable Allocation
;------------------------


;---------------------------------------------------
; Insert your custom declarations above this banner
;---------------------------------------------------
;@PSoC_UserCode_END@ (Do not change this line.)


AREA UserModules (ROM, REL)
.LITERAL
TRIADC_1MaxNegX4Table:
; Bits  7    8    9   10   11   12   13
   DB  FFh, FEh, FCh, F8h, F0h, E0h, C0h

TRIADC_1MaxPosX4Table:
IF (TRIADC_1_DATA_FORMAT)
; Bits (signed)    7    8    9   10   11   12   13
              DB  01h, 02h, 04h, 08h, 10h, 20h, 40h
ELSE
; Bits (unsigned)  7    8    9   10   11   12   13
              DB  02h, 04h, 08h, 10h, 20h, 40h, 80h
ENDIF
.ENDLITERAL


;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_CNT1_ISR (Counter8 Interrupt)
;
;
;  DESCRIPTION:
;    Increment the upper (software) half on the counter whenever the
;    lower (hardware) half of the counter underflows.  This counter
;    should start out at the most negative value (0xFF). (Channel 1)
;
;-----------------------------------------------------------------------------
;
_TRIADC_1_CNT1_ISR:
   inc [TRIADC_1_cCounter1U]
   ;@PSoC_UserCode_BODY_1@ (Do not change this line.)
   ;---------------------------------------------------
   ; Insert your custom code below this banner
   ;---------------------------------------------------
   ;   NOTE: interrupt service routines must preserve
   ;   the values of the A and X CPU registers.

   ;---------------------------------------------------
   ; Insert your custom code above this banner
   ;---------------------------------------------------
   ;@PSoC_UserCode_END@ (Do not change this line.)
   reti

;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_CNT2_ISR (Counter8 Interrupt)
;
;
;  DESCRIPTION:
;    Increment the upper (software) half on the counter whenever the
;    lower (hardware) half of the counter underflows.  This counter
;    should start out at the most negative value (0xFF). (Channel 2)
;
;-----------------------------------------------------------------------------
;
_TRIADC_1_CNT2_ISR:
   inc [TRIADC_1_cCounter2U]
   ;@PSoC_UserCode_BODY_2@ (Do not change this line.)
   ;---------------------------------------------------
   ; Insert your custom code below this banner
   ;---------------------------------------------------
   ;   NOTE: interrupt service routines must preserve
   ;   the values of the A and X CPU registers.

   ;---------------------------------------------------
   ; Insert your custom code above this banner
   ;---------------------------------------------------
   ;@PSoC_UserCode_END@ (Do not change this line.)
   reti

;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_CNT3_ISR (Counter8 Interrupt)
;
;
;  DESCRIPTION:
;    Increment the upper (software) half on the counter whenever the
;    lower (hardware) half of the counter underflows.  This counter
;    should start out at the most negative value (0xFF). (Channel 3)
;
;-----------------------------------------------------------------------------
;
_TRIADC_1_CNT3_ISR:
   inc [TRIADC_1_cCounter3U]
   ;@PSoC_UserCode_BODY_3@ (Do not change this line.)
   ;---------------------------------------------------
   ; Insert your custom code below this banner
   ;---------------------------------------------------
   ;   NOTE: interrupt service routines must preserve
   ;   the values of the A and X CPU registers.

   ;---------------------------------------------------
   ; Insert your custom code above this banner
   ;---------------------------------------------------
   ;@PSoC_UserCode_END@ (Do not change this line.)
   reti

;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC_1_PWM16_ISR  (PWM16 Interrupt)
;
;  DESCRIPTION:
;  This ISR is called when the ADC has completed an integrate cycle.
;  The ADC values are calculated and stored in a global locations before
;  the end of the ISR.
;
;-----------------------------------------------------------------------------
;
_TRIADC_1_PWM16_ISR:
   and   reg[TRIADC_1_bCounter1_CR0], ~TRIADC_1_fDBLK_ENABLE  ; Disable Counter
   and   reg[TRIADC_1_bCounter2_CR0], ~TRIADC_1_fDBLK_ENABLE  ; Disable Counter
   and   reg[TRIADC_1_bCounter3_CR0], ~TRIADC_1_fDBLK_ENABLE  ; Disable Counter
IF TRIADC_1_NoAZ
   or    reg[TRIADC_1_bfADC1cr2], TRIADC_1_fAutoZero       ; Put Integrator in AutoZero
   or    reg[TRIADC_1_bfADC2cr2], TRIADC_1_fAutoZero       ; Put Integrator in AutoZero
   or    reg[TRIADC_1_bfADC3cr2], TRIADC_1_fAutoZero       ; Put Integrator in AutoZero
ENDIF
   or   reg[TRIADC_1_bfADC1cr3],TRIADC_1_fFSW0             ; Put Integrator in reset
   or   reg[TRIADC_1_bfADC2cr3],TRIADC_1_fFSW0             ; Put Integrator in reset
   or   reg[TRIADC_1_bfADC3cr3],TRIADC_1_fFSW0             ; Put Integrator in reset

                                                           ; Enable interrupts for a short period of time just in case.
                                                           ; Make sure we didn't have a counter interrupt ready to fire
   M8C_EnableGInt
   nop                                                     ; Wait a couple cycles
   M8C_DisableGInt                                         ; Disable interrupt, read to complete processing
   push  A                                                 ; Save the Accumulator


   ; Get ADC1 result
   mov   A,reg[TRIADC_1_bCount1]                           ; Read counter value  (Bogus read puts value in Period register)
   mov   A,reg[TRIADC_1_bCompare1]                         ; Read counter value
   dec   A                                                 ; Decrement by one to make sure we didn't miss a count
   cpl   A                                                 ; Invert the value
   jnc   TRIADC_1_INT_CALCV1                               ; if carry, then inc MSB as well
   inc   [TRIADC_1_cCounter1U]
TRIADC_1_INT_CALCV1:
   mov   [(TRIADC_1_iResult1 + LowByte)],A                 ; Store LSB value
   mov   A, [TRIADC_1_cCounter1U]                          ; Store MSB from temp counter
   mov   [(TRIADC_1_iResult1 + HighByte)],A

   ; Get ADC2 result
   mov   A,reg[TRIADC_1_bCount2]                           ; Read counter value  (Bogus read puts value in Period register)
   mov   A,reg[TRIADC_1_bCompare2]                         ; Read counter value
   dec   A                                                 ; Decrement by one to make sure we didn't miss a count
   cpl   A                                                 ; Invert the value
   jnc   TRIADC_1_INT_CALCV2                               ; if carry, then inc MSB as well
   inc   [TRIADC_1_cCounter2U]
TRIADC_1_INT_CALCV2:
   mov   [(TRIADC_1_iResult2 + LowByte)],A                 ; Store LSB value
   mov   A, [TRIADC_1_cCounter2U]                          ; Store MSB from temp counter
   mov   [(TRIADC_1_iResult2 + HighByte)],A

   ; Get ADC3 result
   mov   A,reg[TRIADC_1_bCount3]                           ; Read counter value  (Bogus read puts value in Period register)
   mov   A,reg[TRIADC_1_bCompare3]                         ; Read counter value
   dec   A                                                 ; Decrement by one to make sure we didn't miss a count
   cpl   A                                                 ; Invert the value
   jnc   TRIADC_1_INT_CALCV3                               ; if carry, then inc MSB as well
   inc   [TRIADC_1_cCounter3U]
TRIADC_1_INT_CALCV3:
   mov   [(TRIADC_1_iResult3 + LowByte)],A                 ; Store LSB value
   mov   A, [TRIADC_1_cCounter3U]                          ; Store MSB from temp counter
   mov   [(TRIADC_1_iResult3 + HighByte)],A

                                                           ; The new value has been stored,
                                                           ; so get counters ready for next reading first.
   mov   reg[TRIADC_1_bPeriod1], ffh                       ; Initialize counter1 to FF - Set to overflow after 256 counts
   mov   reg[TRIADC_1_bPeriod2], ffh                       ; Initialize counter2 to FF - Set to overflow after 256 counts
   mov   reg[TRIADC_1_bPeriod3], ffh                       ; Initialize counter3 to FF - Set to overflow after 256 counts
   or    reg[TRIADC_1_bCounter1_CR0],TRIADC_1_fDBLK_ENABLE ; Enable Counter1
   or    reg[TRIADC_1_bCounter2_CR0],TRIADC_1_fDBLK_ENABLE ; Enable Counter2
   or    reg[TRIADC_1_bCounter3_CR0],TRIADC_1_fDBLK_ENABLE ; Enable Counter3


IF (TRIADC_1_DATA_FORMAT)                                  ; Only check for Negative numbers if SIGNED result
   mov   A, [TRIADC_1_bfStatus]                            ; Get Status with Resolution
   and   A, TRIADC_1_bRES_MASK                             ; Mask of resolution
   index TRIADC_1MaxNegX4Table                             ; Get Maximum negative value from table
   mov   [TRIADC_1_cCounter1U], A                          ; Place result back into MSB of counter
   mov   [TRIADC_1_cCounter2U], A                          ; Place result back into MSB of counter
   mov   [TRIADC_1_cCounter3U], A                          ; Place result back into MSB of counter
ELSE
   mov   [TRIADC_1_cCounter1U], 00h                        ; Place result back into MSB of counter
   mov   [TRIADC_1_cCounter2U], 00h                        ; Place result back into MSB of counter
   mov   [TRIADC_1_cCounter3U], 00h                        ; Place result back into MSB of counter
ENDIF

   ;***********************************************
   ; If the input is muxed with multiple inputs
   ; this is a good place to change inputs.
   ;***********************************************
   ;@PSoC_UserCode_BODY_4@ (Do not change this line.)
   ;---------------------------------------------------
   ; Insert your custom code below this banner
   ;---------------------------------------------------
   ;   NOTE: interrupt service routines must preserve
   ;   the values of the A and X CPU registers. At this
   ;   point A has been preserved on the stack and will
   ;   be restored before the return from interrupt.
   ;   However, if you use the X register, you must
   ;   preserve its value and restore it here.

   ;---------------------------------------------------
   ; Insert your custom code above this banner
   ;---------------------------------------------------
   ;@PSoC_UserCode_END@ (Do not change this line.)

   and   reg[TRIADC_1_bfADC1cr3],~TRIADC_1_fFSW0           ; Take Integrator out of reset
   and   reg[TRIADC_1_bfADC2cr3],~TRIADC_1_fFSW0           ; Take Integrator out of reset
   and   reg[TRIADC_1_bfADC3cr3],~TRIADC_1_fFSW0           ; Take Integrator out of reset
IF TRIADC_1_NoAZ
   and   reg[TRIADC_1_bfADC1cr2],~TRIADC_1_fAutoZero       ; Take Integrator out of AutoZero
   and   reg[TRIADC_1_bfADC2cr2],~TRIADC_1_fAutoZero       ; Take Integrator out of AutoZero
   and   reg[TRIADC_1_bfADC3cr2],~TRIADC_1_fAutoZero       ; Take Integrator out of AutoZero
ENDIF

   ;****************************************************************************
   ;M8C_EnableGInt            ; May want to re-enable interrupts at this point,
   ;                          ; if stack space isn't at a premium.
   ; NOTE:  this will make system more responsive but, will increase the
   ;        overall processing time of the A/D calctime.  If an interrupt is
   ;        taken, it must return within the specified CalcTime to guarantee
   ;        successful acquisition of the next byte.
   ;****************************************************************************

; ADC1
IF (TRIADC_1_DATA_FORMAT)                        ; Only check for Negative numbers if SIGNED result
                                                 ; Negative Overflow Check
   tst   [(TRIADC_1_iResult1 + HighByte)],80h
   jnz   TRIADC_1_NOT_2POVFL1

ENDIF
                                                 ; Postive Overflow Check
                                                 ; Get MSB of Max Positive value x4 + 1
   mov   A,[TRIADC_1_bfStatus]                   ; Get Status with Resolution
   and   A,TRIADC_1_bRES_MASK                    ; Mask of resolution normalized to 0
   index TRIADC_1MaxPosX4Table                   ; Get Maximum positive value x4 + 1 from table
   push  A
   and   A, [(TRIADC_1_iResult1 + HighByte)]
   jz    TRIADC_1_NOT_POVFL1
                                                 ; Positive overflow, fix it - set to Max Positive + 1
   pop   A
   sub   A, 01h
                                                 ; Force most positive * 4 into result
   mov   [(TRIADC_1_iResult1 + HighByte)], A
   mov   [(TRIADC_1_iResult1 + LowByte)], ffh
   jmp   TRIADC_1_NOT_2POVFL1
TRIADC_1_NOT_POVFL1:
   pop   A

TRIADC_1_NOT_2POVFL1:
   asr   [(TRIADC_1_iResult1 + HighByte)]        ; Shift MSB and LSB right twice to divide by four
   rrc   [(TRIADC_1_iResult1 + LowByte)]         ; Remember digital clock 4 times analog clock
   asr   [(TRIADC_1_iResult1 + HighByte)]
   rrc   [(TRIADC_1_iResult1 + LowByte)]

; ADC2
IF (TRIADC_1_DATA_FORMAT)                        ; Only check for Negative numbers if SIGNED result
                                                 ; Negative Overflow Check
   tst   [(TRIADC_1_iResult2 + HighByte)],80h
   jnz   TRIADC_1_NOT_2POVFL2

ENDIF
                                                 ; Postive Overflow Check
                                                 ; Get MSB of Max Positive value x4 + 1
   mov   A,[TRIADC_1_bfStatus]                   ; Get Status with Resolution
   and   A,TRIADC_1_bRES_MASK                    ; Mask of resolution normalized to 0
   index TRIADC_1MaxPosX4Table                   ; Get Maximum positive value x4 + 1 from table
   push  A
   and   A, [(TRIADC_1_iResult2 + HighByte)]
   jz    TRIADC_1_NOT_POVFL2
                                                 ; Positive overflow, fix it - set to Max Positive + 1
   pop   A
   sub   A, 01h
                                                 ; Force most positive * 4 into result
   mov   [(TRIADC_1_iResult2 + HighByte)], A
   mov   [(TRIADC_1_iResult2 + LowByte)], ffh
   jmp   TRIADC_1_NOT_2POVFL2
TRIADC_1_NOT_POVFL2:
   pop   A

TRIADC_1_NOT_2POVFL2:
   asr   [(TRIADC_1_iResult2 + HighByte)]        ; Shift MSB and LSB right twice to divide by four
   rrc   [(TRIADC_1_iResult2 + LowByte)]         ; Remember digital clock 4 times analog clock
   asr   [(TRIADC_1_iResult2 + HighByte)]
   rrc   [(TRIADC_1_iResult2 + LowByte)]

; ADC3
IF (TRIADC_1_DATA_FORMAT)                        ; Only check for Negative numbers if SIGNED result
                                                 ; Negative Overflow Check
   tst   [(TRIADC_1_iResult3 + HighByte)],80h
   jnz   TRIADC_1_NOT_2POVFL3

ENDIF
                                                 ; Postive Overflow Check
                                                 ; Get MSB of Max Positive value x4 + 1
   mov   A,[TRIADC_1_bfStatus]                   ; Get Status with Resolution
   and   A,TRIADC_1_bRES_MASK                    ; Mask of resolution normalized to 0
   index TRIADC_1MaxPosX4Table                   ; Get Maximum positive value x4 + 1 from table
   push  A
   and   A, [(TRIADC_1_iResult3 + HighByte)]
   jz    TRIADC_1_NOT_POVFL3
                                                 ; Positive overflow, fix it - set to Max Positive + 1
   pop   A
   sub   A, 01h
                                                 ; Force most positive * 4 into result
   mov   [(TRIADC_1_iResult3 + HighByte)], A
   mov   [(TRIADC_1_iResult3 + LowByte)], ffh
   jmp   TRIADC_1_NOT_2POVFL3
TRIADC_1_NOT_POVFL3:
   pop   A

TRIADC_1_NOT_2POVFL3:
   asr   [(TRIADC_1_iResult3 + HighByte)]        ; Shift MSB and LSB right twice to divide by four
   rrc   [(TRIADC_1_iResult3 + LowByte)]         ; Remember digital clock 4 times analog clock
   asr   [(TRIADC_1_iResult3 + HighByte)]
   rrc   [(TRIADC_1_iResult3 + LowByte)]


   ;**********************************************
   ; Data is ready at this point.
   ; If processing Data at Interrupt level - add
   ;     User Code to handle the data
   ;**********************************************
   ;@PSoC_UserCode_BODY_5@ (Do not change this line.)
   ;---------------------------------------------------
   ; Insert your custom code below this banner
   ;---------------------------------------------------
   ;   NOTE: interrupt service routines must preserve
   ;   the values of the A and X CPU registers. At this
   ;   point A has been preserved on the stack and will
   ;   be restored before the return from interrupt.
   ;   However, if you use the X register, you must
   ;   preserve its value and restore it here.

   ;---------------------------------------------------
   ; Insert your custom code above this banner
   ;---------------------------------------------------
   ;@PSoC_UserCode_END@ (Do not change this line.)

   pop   A                                       ; Restore A, not used any more

   or    [TRIADC_1_bfStatus],TRIADC_1_fDATA_READY  ; Set Data ready bit

   tst   [TRIADC_1_bSampC], ffh                  ; If sample_counter == 0 -->> continuous data collection
   jz    TRIADC_1_END_PWM16_ISR

   dec   [TRIADC_1_bSampC]                       ; Dec sample counter and check for zero
   jnz   TRIADC_1_END_PWM16_ISR

   ;**********************************************
   ; Turn off ADC
   ;**********************************************
   and   reg[TRIADC_1_fPWM_LSB_CR0], ~TRIADC_1_fDBLK_ENABLE    ; Disable the PWM

   and   reg[TRIADC_1_bCounter1_CR0], ~TRIADC_1_fDBLK_ENABLE           ; Disable the Counter
   and   reg[TRIADC_1_bCounter2_CR0], ~TRIADC_1_fDBLK_ENABLE           ; Disable the Counter
   and   reg[TRIADC_1_bCounter3_CR0], ~TRIADC_1_fDBLK_ENABLE           ; Disable the Counter

IF TRIADC_1_NoAZ
   or    reg[TRIADC_1_bfADC1cr2], TRIADC_1_fAutoZero           ; Put the Integrator into Autozero mode
   or    reg[TRIADC_1_bfADC2cr2], TRIADC_1_fAutoZero           ; Put the Integrator into Autozero mode
   or    reg[TRIADC_1_bfADC3cr2], TRIADC_1_fAutoZero           ; Put the Integrator into Autozero mode
ENDIF

   or    reg[TRIADC_1_bfADC1cr3], TRIADC_1_fFSW0               ; Put Integrator into reset
   or    reg[TRIADC_1_bfADC2cr3], TRIADC_1_fFSW0               ; Put Integrator into reset
   or    reg[TRIADC_1_bfADC3cr3], TRIADC_1_fFSW0               ; Put Integrator into reset

   and   reg[TRIADC_1_bfPWM16_INT_REG], ~TRIADC_1_bfPWM16_Mask      ; Disable interrupts
   and   reg[TRIADC_1_bfCounter1_INT_REG], ~TRIADC_1_bfCounter1_Mask
   and   reg[TRIADC_1_bfCounter2_INT_REG], ~TRIADC_1_bfCounter2_Mask
   and   reg[TRIADC_1_bfCounter3_INT_REG], ~TRIADC_1_bfCounter3_Mask


TRIADC_1_END_PWM16_ISR:
   reti

TRIADC_1_APIINT_END:
