;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   UART_SLAVE.inc
;;  Version: 5.1, Updated on 2004/07/29 at 17:48:41
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION:  Assembler declarations for the UART user module for the
;;                22/24/25/26/27xxx PSoC family of devices.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

;--------------------------------------------------
; Constants for UART_SLAVE API's
;--------------------------------------------------

;mask value for global int reg bit for TX instance
UART_SLAVE_TX_INT_MASK:                       equ 04h
UART_SLAVE_TX_INT_REG:                        equ 0e1h  ;TX interrupt address
UART_SLAVE_RX_INT_MASK:                       equ 08h  ;mask value for global int reg bit for RX instance
UART_SLAVE_RX_INT_REG:                        equ 0e1h  ;RX interrupt address

UART_SLAVE_RXBUF_ENABLE:                    equ   0

; Interrupt control masks
UART_SLAVE_ENABLE_RX_INT:                      equ  0x01
UART_SLAVE_DISABLE_RX_INT:                     equ  0x00
UART_SLAVE_ENABLE_TX_INT:                      equ  0x02
UART_SLAVE_DISABLE_TX_INT:                     equ  0x00

UART_SLAVE_INT_MODE_TX_REG_EMPTY:            equ 0x00
UART_SLAVE_INT_MODE_TX_COMPLETE:             equ 0x01

UART_SLAVE_RX_IGNORE_BELOW:                  equ  1h
UART_SLAVE_RX_BUFFER_SIZE:                   equ  20h
UART_SLAVE_CMD_TERM:                         equ  ah
UART_SLAVE_DELIMITER:                        equ  20h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       WARNING WARNING WARNING
; The following equates are for backwards
; compatibility only and should not be used
; for new designs.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;------------------------------------
;  Parity masks
;------------------------------------
UART_PARITY_NONE:       equ   00h
UART_PARITY_EVEN:       equ   02h
UART_PARITY_ODD:        equ   06h

;------------------------------------
;  TX Status Register masks
;------------------------------------
UART_TX_COMPLETE:       equ   20h
UART_TX_BUFFER_EMPTY:   equ   10h

;------------------------------------
;  RX Status Register masks
;------------------------------------
UART_RX_ACTIVE:         equ   10h
UART_RX_COMPLETE:       equ   08h
UART_RX_PARITY_ERROR:   equ   80h
UART_RX_OVERRUN_ERROR:  equ   40h
UART_RX_FRAMING_ERROR:  equ   20h
UART_RX_NO_ERROR:       equ   E0h
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;             END WARNING
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;------------------------------------
;  Parity masks
;------------------------------------
UART_SLAVE_PARITY_NONE:                 equ   00h
UART_SLAVE_PARITY_EVEN:                 equ   02h
UART_SLAVE_PARITY_ODD:                  equ   06h

;------------------------------------
;  TX Status Register masks
;------------------------------------
UART_SLAVE_TX_COMPLETE:                 equ   20h
UART_SLAVE_TX_BUFFER_EMPTY:             equ   10h

;------------------------------------
;  RX Status Register masks
;------------------------------------
UART_SLAVE_RX_ACTIVE:                   equ   10h
UART_SLAVE_RX_COMPLETE:                 equ   08h
UART_SLAVE_RX_REG_FULL:                 equ   08h
UART_SLAVE_RX_PARITY_ERROR:             equ   80h
UART_SLAVE_RX_OVERRUN_ERROR:            equ   40h
UART_SLAVE_RX_FRAMING_ERROR:            equ   20h
UART_SLAVE_RX_ERROR:                    equ   E0h
UART_SLAVE_RX_ENABLE:                   equ   01h

UART_SLAVE_RX_BUF_ERROR:                equ   F0h  ; Mask for any Rx that may occur.
UART_SLAVE_RX_BUF_OVERRUN:              equ   10h  ; This indicates the software buffer has
                                                        ; been over run.
UART_SLAVE_RX_BUF_CMDTERM:              equ   01h  ; Command terminator has been received.

UART_SLAVE_RX_NO_DATA:                  equ   01h
UART_SLAVE_RX_NO_ERROR:                 equ   E0h


;--------------------------------------------------
; Registers Address Constants for UART_SLAVE
;--------------------------------------------------
;---------------------------------
;  Registers used by TX
;---------------------------------
UART_SLAVE_TX_CONTROL_REG:  equ 2bh            ; Control register
UART_SLAVE_TX_SHIFT_REG:    equ 28h               ; TX Shift Register register
UART_SLAVE_TX_BUFFER_REG:   equ 29h               ; TX Buffer Register
UART_SLAVE_TX_FUNC_REG: equ 28h         ; Function register
UART_SLAVE_TX_INPUT_REG:    equ 29h            ; Input register
UART_SLAVE_TX_OUTPUT_REG:   equ 2ah           ; Output register

;---------------------------------
;  Registers used by RX
;---------------------------------
UART_SLAVE_RX_CONTROL_REG:  equ 2fh            ; Control register
UART_SLAVE_RX_SHIFT_REG:    equ 2ch               ; RX Shift Register register
UART_SLAVE_RX_BUFFER_REG:   equ 2eh               ; RX Buffer Register
UART_SLAVE_RX_FUNC_REG: equ 2ch         ; Function register
UART_SLAVE_RX_INPUT_REG:    equ 2dh            ; Input register
UART_SLAVE_RX_OUTPUT_REG:   equ 2eh           ; Output register

; end of file UART_SLAVE.inc
