;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   RefMux_1.asm
;;  Version: 1.3, Updated on 2004/07/19 at 16:37:52
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: RefMux User Module software implementation file for the
;;               22/24/25/26/27xxx PSoc family of devices.
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2001 - 2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "RefMux_1.inc"
include "m8c.inc"
include "memory.inc"

;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export  RefMux_1_Start
export _RefMux_1_Start

export  RefMux_1_SetPower
export _RefMux_1_SetPower

export  RefMux_1_Stop
export _RefMux_1_Stop

export  RefMux_1_RefSelect
export _RefMux_1_RefSelect

;-----------------------------------------------
;  EQUATES
;-----------------------------------------------
TMUX_MASK:        equ 1Ch              ; Mask for Test Mux control
POWERMASK:        equ 03h

AREA UserModules (ROM, REL)
.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: RefMux_1_Start
;  FUNCTION NAME: RefMux_1_SetPower
;
;  DESCRIPTION:
;   Applies power setting to the module's PSoC block
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;  A  Contains the power setting; 0 = Off
;                                 1 = Low
;                                 2 = Med
;                                 3 = High
;
;  RETURNS:  NA
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 RefMux_1_Start:
_RefMux_1_Start:
 RefMux_1_SetPower:
_RefMux_1_SetPower:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and  A, POWERMASK                  ; mask A to protect unchanged bits
    mov  X, SP                         ; define temp store location

    push A                             ; put power value in temp store
    mov  A, reg[RefMux_1_REFMUX_CR2]   ; read power value
    and  A, ~POWERMASK                 ; clear power bits in A
    or   A, [X]                        ; combine power value with balance of reg.
    mov  reg[RefMux_1_REFMUX_CR2], A   ; move complete value back to register
    pop  A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: RefMux_1_Stop
;
;  DESCRIPTION:
;   Turn off power to user module
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: None
;
;  RETURNS:  NA
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 RefMux_1_Stop:
_RefMux_1_Stop:
    RAM_PROLOGUE RAM_USE_CLASS_1
    and REG[RefMux_1_REFMUX_CR2], ~POWERMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: RefMux_1_InputSelect
;
;  DESCRIPTION:
;   Select one of the input of the TestMux to be connected to the Analog
;   Column bus.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;   A  contains value to select desired RefMux output.
;         Input              Code
;         Off                 00h
;         PMuxOut             10h
;         AGND                14h  (Power must be applied)
;         REFLO               18h
;         REFHI               1Ch
;
;  RETURNS:  NA
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 RefMux_1_RefSelect:
_RefMux_1_RefSelect:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and  A,TMUX_MASK                   ; Mask off test mux control
    mov  X,SP                          ; Get stack location
    push A
    mov  A,reg[RefMux_1_REFMUX_CR2]    ; Write register Test Mux register to select reference
    and  A, ~TMUX_MASK                 ; Clear Mux control bits
    or   A,[X]                         ; Or in the new setting
    mov  reg[RefMux_1_REFMUX_CR2],A    ; Write register Test Mux register to select reference
    pop  A                             ; Restore the stack
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret
.ENDSECTION


; End of File RefMux_1.asm
