;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   SAR6_1.asm
;;  Version: 1.4, Updated on 2004/07/19 at 16:38:06
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION:  SAR6 User Module software implementation file for the
;;                22/24/25/26/27xxx PSoC family of devices.
;;
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************
include "m8c.inc"
include "memory.inc"
include "SAR6_1.inc"

;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export  SAR6_1_Start
export _SAR6_1_Start
export  SAR6_1_SetPower
export _SAR6_1_SetPower
export  SAR6_1_cGetSample
export _SAR6_1_cGetSample
export  SAR6_1_Stop
export _SAR6_1_Stop


;-----------------------------------------------
; WARNING! These exports will be removed in
; a future release.
;-----------------------------------------------
export  SAR6_1_GetSample
export _SAR6_1_GetSample

;-----------------------------------------------
;  Constant Definitions
;-----------------------------------------------
bPWRMASK:  equ 03h              ; Power bitfield in Switched Cap CR3 reg

AREA UserModules (ROM, REL)

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: SAR6_1_Start
;  FUNCTION NAME: SAR6_1_SetPower
;
;  DESCRIPTION:
;     Applies power setting to the module's SoCblocs
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    A   contains the power setting 0=Off, 1=Low, 2=Med, 3=High
;
;  RETURNS:  NA
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 SAR6_1_Start:
_SAR6_1_Start:
    ;; Initialization-time only code goes here.

 SAR6_1_SetPower:
_SAR6_1_SetPower:
    RAM_PROLOGUE RAM_USE_CLASS_2
    and   A, bPWRMASK       ; trim to bits of interest
    mov   X, SP             ; Set stack frame pointer
    push  A

    ;; read CR3 register, modify power bits & write back
    mov   A, reg[SAR6_1_CR3]
    and   A, ~bPWRMASK      ; clear old setting
    or    A, [X]            ; set power in register image
    mov   reg[SAR6_1_CR3], A
    pop   A
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: SAR6_1_cGetSample
;
;  DESCRIPTION:
;    Utilize SAR acceleration hardware to guide a binary search
;    until the output of the 6-bit DAC output is within 1 bit of the
;    input voltage.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;
;  RETURNS:
;    A   2's Complement Value in [-32..+31]
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
PSOC_ANALOG_COL_MASK:  equ 0Ch ; mask for column bits in analog reg address
PSOC_SAR_CTRL:         equ 68h ;
PSOC_SAR_MAGNITUDE:    equ 1Fh ;
PSOC_SAR_SIGN:         equ 20h ;

 SAR6_1_cGetSample:
_SAR6_1_cGetSample:
 SAR6_1_GetSample:  ; WARNING, this label will be removed in a future release.
_SAR6_1_GetSample:  ; WARNING, this label will be removed in a future release.
    RAM_PROLOGUE RAM_USE_CLASS_1

    ; These three lines of code are VERY important to ensure proper SAR6 operation.
    ; 1) The first line will make sure the CPU is stalled when a value is written
    ;    to the analog switch cap register.
    ; 2) Write the inital value to CR0
    ; 3) Setup the Analog Synchronization Control Register so that the next
    ;    six "or" commands work with the SAR hardware to perform a conversion.

    mov  reg[ASY_CR],ASY_CR_SYNCEN
    mov  reg[SAR6_1_CR0], SAR6_1_CR0_INIT
    mov  reg[ASY_CR], PSOC_SAR_CTRL | SAR6_1_SCCOL_MASK


    ;; Drive the binary search engine with read/modify/write instructions.
    ;; NOTE: each of the next 6 instructions stalls the CPU consuming one
    ;; complete analog column clock cycle (input clock divided by 4).
    or   reg[SAR6_1_CR0], 0   ; set sign & try MSB of magnitude
    or   reg[SAR6_1_CR0], 0   ; set MSB of magnitude and try next lower
    or   reg[SAR6_1_CR0], 0   ;                      ... and next ...
    or   reg[SAR6_1_CR0], 0   ;                      ... and next ...
    or   reg[SAR6_1_CR0], 0   ;                      ... and try LSB
    or   reg[SAR6_1_CR0], 0   ; and, finally, set LSB of magnitude.

    ;; Conversion is done, translate the result to 1-byte 2's complement form.
    ;; Negative and positive values are handled differently. To minimize
    ;; aperature jitter, the execution cycles consumed in each case have been
    ;; equalized. The cost of this is 13 cycles for positive values; 5 cycles
    ;; for negative values.
    mov  A, reg[SAR6_1_CR0]
    and  A, PSOC_SAR_MAGNITUDE
    tst  reg[SAR6_1_CR0], PSOC_SAR_SIGN
    jnz  GSNegative  ; Result is zero => sign was 1 (negative).
    nop              ; Delay to equalize number of required cycles.
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
GSNegative:
    cpl  A           ; Take 1's complement of the magnitude
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: SAR6_1_Stop
;
;  DESCRIPTION:
;    Removes power from the switch cap block
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:  None
;
;  RETURNS: NA
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 SAR6_1_Stop:
_SAR6_1_Stop:
    RAM_PROLOGUE RAM_USE_CLASS_1
    and reg[SAR6_1_CR3], ~bPWRMASK
    RAM_EPILOGUE RAM_USE_CLASS_1
    ret
.ENDSECTION

; End of File SAR6_1.asm
