	cpu LMM
	.module main.c
	.area data(ram, con, rel)
_motorEnable::
	.byte 0
	.dbfile ./main.c
	.dbsym e motorEnable _motorEnable c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_slavebufpos::
	.byte 0
	.dbsym e slavebufpos _slavebufpos c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_slavebufchk::
	.byte 0
	.dbsym e slavebufchk _slavebufchk c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_prt2andmask::
	.byte 255
	.dbsym e prt2andmask _prt2andmask c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_prt2ormask::
	.byte 0
	.dbsym e prt2ormask _prt2ormask c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_motorslewcounter::
	.byte 0
	.dbsym e motorslewcounter _motorslewcounter c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogOffsetSampled::
	.byte 0
	.dbsym e analogOffsetSampled _analogOffsetSampled c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_badchars::
	.byte 0
	.dbsym e badchars _badchars c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area text(rom, con, rel)
	.dbfile ./main.c
	.dbfunc e resetState _resetState fV
;              i -> X+0
_resetState::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 92
; //----------------------------------------------------------------------------
; // C main line
; //----------------------------------------------------------------------------
; 
; #include <m8c.h>        // part specific constants and macros
; #include "PSoCAPI.h"    // PSoC API definitions for all User Modules
; #include "util.h"
; #include "ed_slave_int.h"
; #include "error.h"
; 
; #define PINMODE_DIG_IN 			0
; #define PINMODE_DIG_IN_PULLUP   1
; #define PINMODE_DIG_IN_PULLDN   2
; 
; #define PINMODE_DIG_OUT_STRONG  3
; #define PINMODE_DIG_OUT_SLOW    4
; 
; #define PINMODE_SERVO			5
; #define PINMODE_SONAR_PING		6
; #define PINMODE_SONAR_ECHO		7
; 
; #define PINMODE_ANALOG_IN       8
; 
; #define PINMODE_ANALOG_OUT      9
; #define PINMODE_CLOCK_OUT       10
; 
; #define PINMODE_QUADPHASE       11
; #define PINMODE_MONOPHASE       12
; #define PINMODE_MAX             12
; 
; #define MOTORSLEWPERIOD 4
; 
; //********************************************************
; // GLOBALS
; //******************************************************** 
; unsigned int  analog[8];		// we store all of our analog values here, with 2_1 and 2_2 at 8 and 9.
; unsigned int  analogOffsetError[6]; // track the minimum seen value so we can subtract the error offset.
; 
; unsigned char analogFilter[8];
; short analogNext;	// which port are we sampling?
; short analogDelay;  // how many samples have we skipped since updating our main bank of A/Ds?
; short analogResolution; // how many bits of resolution?
; unsigned char motorEnable=0x00;
; 
; unsigned char pwmGoal[4];
; unsigned char pwmActual[4];
; unsigned char pwmSlew[4];
; unsigned char motorDir[4];
; 
; #define SLAVEBUFSIZE 32 // power of two
; unsigned char slavebuf[SLAVEBUFSIZE];
; unsigned char slavebufpos=0;
; unsigned char slavebufchk=0;
; 
; extern long sleepcounter;
; long lastcounter;
; 
; unsigned char prt2andmask=0xff, prt2ormask=0x00;
; 
; unsigned char pinmode[8];
; 
; unsigned char motorslewcounter=0;
; 
; unsigned char analogOffsetSampled=0;
; 
; unsigned char badchars=0;
; 
; //********************************************************
; // FUNCTION PROTOTYPES
; //******************************************************** 
; void resetState(void);
; void doCommand(void);
; void doSlave(void);
; void doSlaveMessage(void);
; void sendAck(unsigned char flags, unsigned char error);
; void sendPacket(unsigned char flags);
; unsigned char chksend(unsigned char chk, unsigned char c);
; unsigned char chksendi(unsigned char chk, unsigned int c);
; void doSleepCounter(void);
; unsigned char setpinmode(unsigned char pin, unsigned char mode);
; void updateAnalog(void);
; void updateMotor(unsigned char i);
; 
; extern unsigned int  qpdata0, qpdata1;
; extern unsigned char qperrs0, qperrs1;
; extern unsigned char qpoffset;
; 
; //********************************************************
; // Reset internal state.
; //******************************************************** 
; void resetState()
; {
	.dbline 95
; 	int i;
; 	
; 	for (i=0;i<8;i++)
	mov [X+1],0
	mov [X+0],0
L2:
	.dbline 96
	.dbline 97
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r1],A
	mov A,[X+0]
	mov [__r0],A
	asl [__r1]
	rlc [__r0]
	add [__r1],<_analog
	adc [__r0],>_analog
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	mvi [__r1],A
	.dbline 98
	mov A,[X+1]
	add A,<_analogFilter
	mov [__r1],A
	mov A,[X+0]
	adc A,>_analogFilter
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 99
L3:
	.dbline 95
	inc [X+1]
	adc [X+0],0
	.dbline 95
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,8
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L2
X0:
	.dbline 101
; 	{
; 		analog[i]=0;
; 		analogFilter[i]=0;
; 	}
; 	
; 	for (i=0;i<6;i++)
	mov [X+1],0
	mov [X+0],0
L6:
	.dbline 102
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r1],A
	mov A,[X+0]
	mov [__r0],A
	asl [__r1]
	rlc [__r0]
	add [__r1],<_analogOffsetError
	adc [__r0],>_analogOffsetError
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,-1
	mvi [__r1],A
	mvi [__r1],A
L7:
	.dbline 101
	inc [X+1]
	adc [X+0],0
	.dbline 101
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,6
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L6
X1:
	.dbline 106
; 		analogOffsetError[i]=65535;
; //	for (i=0;i<6;i++)		// this disables the filter
; //		analogOffsetError[i]=0;
; 
; 	for (i=0;i<4;i++)
	mov [X+1],0
	mov [X+0],0
L10:
	.dbline 107
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,<_analogFilter
	mov [__r1],A
	mov A,[X+0]
	adc A,>_analogFilter
	mov REG[0xd5],A
	mov A,2
	mvi [__r1],A
L11:
	.dbline 106
	inc [X+1]
	adc [X+0],0
	.dbline 106
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,4
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L10
X2:
	.dbline 109
; 		analogFilter[i]=2;
; 	
; 	analogFilter[6]=4;
	mov REG[0xd0],>_analogFilter
	mov [_analogFilter+6],4
	.dbline 110
; 	analogFilter[7]=4;
	mov [_analogFilter+7],4
	.dbline 112
; 	
; 	analogNext=0;
	mov REG[0xd0],>_analogNext
	mov [_analogNext+1],0
	mov [_analogNext],0
	.dbline 113
; 	analogDelay=0;
	mov REG[0xd0],>_analogDelay
	mov [_analogDelay+1],0
	mov [_analogDelay],0
	.dbline 114
; 	analogResolution=14;
	mov REG[0xd0],>_analogResolution
	mov [_analogResolution+1],14
	mov [_analogResolution],0
	.dbline 116
; 	
; 	for (i=0;i<4;i++)
	mov [X+1],0
	mov [X+0],0
L16:
	.dbline 117
	.dbline 118
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,<_pwmGoal
	mov [__r1],A
	mov A,[X+0]
	adc A,>_pwmGoal
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 119
	mov A,[X+1]
	add A,<_pwmActual
	mov [__r1],A
	mov A,[X+0]
	adc A,>_pwmActual
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 120
	mov A,[X+1]
	add A,<_motorDir
	mov [__r1],A
	mov A,[X+0]
	adc A,>_motorDir
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 121
	mov A,[X+1]
	add A,<_pwmSlew
	mov [__r1],A
	mov A,[X+0]
	adc A,>_pwmSlew
	mov REG[0xd5],A
	mov A,51
	mvi [__r1],A
	.dbline 122
L17:
	.dbline 116
	inc [X+1]
	adc [X+0],0
	.dbline 116
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,4
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L16
X3:
	.dbline 124
; 	{
; 		pwmGoal[i]=0;
; 		pwmActual[i]=0;
; 		motorDir[i]=0;
; 		pwmSlew[i]=51;
; 	}
; 	
; 	for (i=0;i<4;i++)
	mov [X+1],0
	mov [X+0],0
L20:
	.dbline 125
	mov A,1
	push A
	mov REG[0xd0],>__r0
	mov A,[X+1]
	push A
	xcall _setpinmode
	add SP,-2
	mov REG[0xd0],>__r0
L21:
	.dbline 124
	inc [X+1]
	adc [X+0],0
	.dbline 124
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,4
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L20
X4:
	.dbline 127
; 		setpinmode(i, PINMODE_DIG_IN_PULLUP);
; 
; 	for (i=4;i<8;i++)
	mov [X+1],4
	mov [X+0],0
L24:
	.dbline 128
	mov A,3
	push A
	mov REG[0xd0],>__r0
	mov A,[X+1]
	push A
	xcall _setpinmode
	add SP,-2
	mov REG[0xd0],>__r0
L25:
	.dbline 127
	inc [X+1]
	adc [X+0],0
	.dbline 127
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,8
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L24
X5:
	.dbline -2
	.dbline 129
; 		setpinmode(i, PINMODE_DIG_OUT_STRONG);
; }
L1:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l i 0 I
	.dbend
	.dbfunc e main _main fV
;              v -> X+0
_main::
	.dbline -1
	push X
	mov X,SP
	add SP,3
	.dbline 132
; 
; void main()
; {
	.dbline 135
; 	unsigned char v;
; 	
; 	PRT2DR=motorEnable; //disable motors (note: HIGH nibble)
	mov REG[0xd0],>_motorEnable
	mov A,[_motorEnable]
	mov REG[0x8],A
	.dbline 137
; 
; 	resetState();
	xcall _resetState
	.dbline 139
; 	
; 	M8C_EnableGInt;
		or  F, 01h

	.dbline 141
; 
; 	PWM8_1_Start();
	push X
	xcall _PWM8_1_Start
	.dbline 142
; 	PWM8_2_Start();
	xcall _PWM8_2_Start
	.dbline 143
; 	PWM8_3_Start();
	xcall _PWM8_3_Start
	.dbline 144
; 	PWM8_4_Start();
	xcall _PWM8_4_Start
	.dbline 146
;  
; 	PWM8_1_WritePulseWidth(0x0);
	mov A,0
	xcall _PWM8_1_WritePulseWidth
	.dbline 147
; 	PWM8_2_WritePulseWidth(0x0);
	mov A,0
	xcall _PWM8_2_WritePulseWidth
	.dbline 148
; 	PWM8_3_WritePulseWidth(0x0);
	mov A,0
	xcall _PWM8_3_WritePulseWidth
	.dbline 149
; 	PWM8_4_WritePulseWidth(0x0);
	mov A,0
	xcall _PWM8_4_WritePulseWidth
	.dbline 151
;  	
;  	PWM8_SLAVECLK_Start();
	xcall _PWM8_SLAVECLK_Start
	.dbline 153
;  	
; 	AMUX4_1_Start();
	xcall _AMUX4_1_Start
	.dbline 154
;  	AMUX4_2_Start();
	xcall _AMUX4_2_Start
	.dbline 155
;  	RefMux_1_Start(RefMux_1_HIGHPOWER);
	mov A,3
	xcall _RefMux_1_Start
	.dbline 157
; 
; 	DelSig_1_Start(DelSig_1_HIGHPOWER);
	mov A,3
	xcall _DelSig_1_Start
	.dbline 158
; 	DelSig_1_StartAD();
	xcall _DelSig_1_StartAD
	.dbline 159
; 	SAR6_1_Start(SAR6_1_FULLPOWER);
	mov A,3
	xcall _SAR6_1_Start
	.dbline 160
; 	SAR6_2_Start(SAR6_2_FULLPOWER);
	mov A,3
	xcall _SAR6_2_Start
	.dbline 162
; 	
;   	ED_SLAVE_init();
	xcall _ED_SLAVE_init
	mov REG[0xd0],>__r0
	pop X
	.dbline 163
;     UART_SLAVE_IntCntl(UART_SLAVE_ENABLE_RX_INT |  UART_SLAVE_ENABLE_TX_INT);
	push X
	mov A,3
	xcall _UART_SLAVE_IntCntl
	.dbline 164
;     UART_SLAVE_Start(UART_SLAVE_PARITY_NONE);
	mov A,0
	xcall _UART_SLAVE_Start
	pop X
	.dbline 166
; 
; 	sleepcounter=0;
	mov REG[0xd0],>_sleepcounter
	mov [_sleepcounter],0
	mov [_sleepcounter+1],0
	mov [_sleepcounter+2],0
	mov [_sleepcounter+3],0
	.dbline 167
;  	INT_MSK0|=0x40; // enable sleep interrupts. 512Hz clock.
	or REG[0xe0],64
	xjmp L30
L29:
	.dbline 170
; 		
; 	while (1)
;  	{
	.dbline 171
;  		updateAnalog();
	xcall _updateAnalog
	xjmp L33
L32:
	.dbline 174
	xcall _doSlave
L33:
	.dbline 173
;  			
;   		while (ED_SLAVE_isData())
	push X
	xcall _ED_SLAVE_isData
	pop X
	cmp A,0
	jnz L32
	.dbline 176
;  			doSlave();
;  	
;  		M8C_DisableGInt;
		and F, FEh

	.dbline 177
;  		v = (lastcounter!=sleepcounter);
	mov REG[0xd0],>_lastcounter
	mov A,[_lastcounter]
	mov REG[0xd0],>_sleepcounter
	cmp A,[_sleepcounter]
	jnz X7
	mov REG[0xd0],>_lastcounter
	mov A,[_lastcounter+1]
	mov REG[0xd0],>_sleepcounter
	cmp A,[_sleepcounter+1]
	jnz X7
	mov REG[0xd0],>_lastcounter
	mov A,[_lastcounter+2]
	mov REG[0xd0],>_sleepcounter
	cmp A,[_sleepcounter+2]
	jnz X7
	mov REG[0xd0],>_lastcounter
	mov A,[_lastcounter+3]
	mov REG[0xd0],>_sleepcounter
	cmp A,[_sleepcounter+3]
	jz L36
X7:
	mov [X+2],1
	mov [X+1],0
	xjmp L37
L36:
	mov [X+2],0
	mov [X+1],0
L37:
	mov REG[0xd0],>__r0
	mov A,[X+2]
	mov [X+0],A
	.dbline 178
;  		M8C_EnableGInt;	
		or  F, 01h

	.dbline 179
;  		if (v)
	cmp [X+0],0
	jz L38
	.dbline 180
;  		{
	.dbline 181
;  			doSleepCounter();
	xcall _doSleepCounter
	.dbline 183
;  
;  			M8C_DisableGInt;
		and F, FEh

	.dbline 184
;  			lastcounter=sleepcounter;
	mov REG[0xd0],>_sleepcounter
	mov A,[_sleepcounter]
	push A
	mov A,[_sleepcounter+1]
	push A
	mov A,[_sleepcounter+2]
	push A
	mov A,[_sleepcounter+3]
	mov REG[0xd0],>_lastcounter
	mov [_lastcounter+3],A
	pop A
	mov [_lastcounter+2],A
	pop A
	mov [_lastcounter+1],A
	pop A
	mov [_lastcounter],A
	.dbline 185
;  			M8C_EnableGInt;
		or  F, 01h

	.dbline 187
; 
;  		}
L38:
	.dbline 188
L30:
	.dbline 169
	xjmp L29
X6:
	.dbline -2
	.dbline 189
; 	}
; }
L28:
	add SP,-3
	pop X
	.dbline 0 ; func end
	jmp .
	.dbsym l v 0 c
	.dbend
	.dbfunc e doSleepCounter _doSleepCounter fV
;              i -> X+0
_doSleepCounter::
	.dbline -1
	push X
	mov X,SP
	add SP,1
	.dbline 192
; 
; void doSleepCounter()
; {
	.dbline 195
; 	unsigned char i;
; 	
; 	motorslewcounter++;
	mov REG[0xd0],>_motorslewcounter
	inc [_motorslewcounter]
	.dbline 196
; 	if (motorslewcounter<MOTORSLEWPERIOD)
	cmp [_motorslewcounter],4
	jnc L41
X8:
	.dbline 197
; 		return;
	xjmp L40
L41:
	.dbline 198
; 	motorslewcounter=0;
	mov REG[0xd0],>_motorslewcounter
	mov [_motorslewcounter],0
	.dbline 200
; 	
; 	for (i=0;i<4;i++)
	mov [X+0],0
	xjmp L46
L43:
	.dbline 201
	.dbline 202
	mov A,[X+0]
	push A
	xcall _updateMotor
	add SP,-1
	.dbline 203
L44:
	.dbline 200
	inc [X+0]
L46:
	.dbline 200
	cmp [X+0],4
	jz X9
	jc L43
X9:
	.dbline -2
	.dbline 204
; 	{
; 		updateMotor(i);
; 	}
; }
L40:
	add SP,-1
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l i 0 c
	.dbend
	.dbfunc e updateMotor _updateMotor fV
;           mode -> X+4
;      actualdir -> X+3
;        goaldir -> X+2
;              v -> X+0
;              i -> X-4
_updateMotor::
	.dbline -1
	push X
	mov X,SP
	add SP,7
	.dbline 207
; 
; void updateMotor(unsigned char i)
; {
	.dbline 211
; 	unsigned char actualdir, goaldir, mode;
; 	int v;
; 	
; 	goaldir=motorDir[i]&3;
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_motorDir
	adc [__r0],>_motorDir
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	and A,3
	mov [X+2],A
	.dbline 212
; 	actualdir=(motorDir[i]>>2)&3;
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_motorDir
	adc [__r0],>_motorDir
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],A
	asr [__r0]
	asr [__r0]
	and [__r0],63
	mov A,[__r0]
	and A,3
	mov [X+3],A
	.dbline 214
; 		
; 	if (goaldir==0) // do nothing if we're disabled.
	cmp [X+2],0
	jnz L48
	.dbline 215
; 		return;
	xjmp L47
L48:
	.dbline 218
; 			
; 	// now, compute our new PWM value
; 	v=pwmActual[i];
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmActual
	adc [__r0],>_pwmActual
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [X+1],A
	mov [X+0],0
	.dbline 220
; 		
; 	if (goaldir==actualdir)
	mov A,[X+2]
	cmp A,[X+3]
	jnz L50
	.dbline 221
; 	{
	.dbline 223
; 		// we're already going in the right direction; make pwmactual follow pwmgoal
; 		if (v<pwmGoal[i])
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r1],A
	mov A,[X+0]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,[__r1]
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jnc L52
	mov A,[__rX]
	jz L52
X12:
	.dbline 224
; 			{
	.dbline 225
; 			v=v+pwmSlew[i];
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmSlew
	adc [__r0],>_pwmSlew
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],0
	add [X+1],A
	adc [X+0],0
	.dbline 226
; 			if (v>pwmGoal[i])
	mov A,[X-4]
	mov [__r1],A
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r1],A
	mov A,[X+0]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,[__r1]
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L54
	mov A,[__rX]
	jz L54
X13:
	.dbline 227
; 				v=pwmGoal[i];
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [X+1],A
	mov [X+0],0
L54:
	.dbline 228
; 			}
L52:
	.dbline 230
; 			
; 		if (v>pwmGoal[i])
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r1],A
	mov A,[X+0]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,[__r1]
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L51
	mov A,[__rX]
	jz L51
X14:
	.dbline 231
; 			{
	.dbline 232
; 			v=v-pwmSlew[i];
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmSlew
	adc [__r0],>_pwmSlew
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],0
	sub [X+1],A
	sbb [X+0],0
	.dbline 233
; 			if (v<pwmGoal[i])
	mov A,[X-4]
	mov [__r1],A
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r1],A
	mov A,[X+0]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,[__r1]
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jnc L51
	mov A,[__rX]
	jz L51
X15:
	.dbline 234
; 				v=pwmGoal[i];
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [X+1],A
	mov [X+0],0
	.dbline 235
; 			}
	.dbline 236
; 	}
	xjmp L51
L50:
	.dbline 238
; 	else
; 	{
	.dbline 240
; 		// we're going the wrong way. Slow down!
; 		v=v-pwmSlew[i];
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmSlew
	adc [__r0],>_pwmSlew
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	sub [X+1],A
	sbb [X+0],0
	.dbline 241
; 		if (v<0)
	mov A,[X+0]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jnc L60
	mov A,[__rX]
	jz L60
X16:
	.dbline 242
; 			v=0;
	mov [X+1],0
	mov [X+0],0
L60:
	.dbline 244
; 			
; 		if (v==0) // if we've slowed down all the way, we can change direction.
	cmp [X+0],0
	jnz L62
	cmp [X+1],0
	jnz L62
X17:
	.dbline 245
; 		{
	.dbline 248
; 			// we've reached zero speed. set the new direction.
; 			
; 			if (goaldir==1)
	cmp [X+2],1
	jnz L64
	.dbline 249
; 				mode=0x05;
	mov [X+4],5
	xjmp L65
L64:
	.dbline 251
; 			else
; 				mode=0x30;
	mov [X+4],48
L65:
	.dbline 254
; 				
; 			// change the direction...
; 			switch (i)
	mov A,[X-4]
	mov [X+6],A
	mov [X+5],0
	cmp [X+5],0
	jnz X18
	cmp [X+6],0
	jz L69
X18:
	cmp [X+5],0
	jnz X19
	cmp [X+6],1
	jz L70
X19:
	cmp [X+5],0
	jnz X20
	cmp [X+6],2
	jz L71
X20:
	cmp [X+5],0
	jnz X21
	cmp [X+6],3
	jz L72
X21:
	xjmp L66
X10:
	.dbline 255
; 				{
L69:
	.dbline 257
; 				case 0:
; 					RDI1LT0=mode;
	mov A,[X+4]
	mov REG[0xbb],A
	.dbline 258
; 					break;
	xjmp L67
L70:
	.dbline 260
; 				case 1:
; 					RDI1LT1=mode;
	mov A,[X+4]
	mov REG[0xbc],A
	.dbline 261
; 					break;
	xjmp L67
L71:
	.dbline 263
; 				case 2:
; 					RDI2LT0=mode;
	mov A,[X+4]
	mov REG[0xc3],A
	.dbline 264
; 					break;
	xjmp L67
L72:
	.dbline 266
; 				case 3:
; 					RDI2LT1=mode;
	mov A,[X+4]
	mov REG[0xc4],A
	.dbline 267
; 					break;
L66:
L67:
	.dbline 270
; 				}
; 
; 			motorDir[i]=(goaldir<<2)|goaldir;
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_motorDir
	adc [__r0],>_motorDir
	mov A,[X+2]
	mov [__r2],A
	asl [__r2]
	asl [__r2]
	mov A,[X+2]
	or [__r2],A
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[__r2]
	mvi [__r1],A
	.dbline 271
; 		}
L62:
	.dbline 272
; 	}
L51:
	.dbline 275
; 		
; 	// write the new pwm value
; 	pwmActual[i]=v;
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmActual
	adc [__r0],>_pwmActual
	mov A,[X+1]
	mov [__r2],A
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[__r2]
	mvi [__r1],A
	.dbline 277
; 		
; 	switch (i)
	mov A,[X-4]
	mov [X+6],A
	mov [X+5],0
	cmp [X+5],0
	jnz X22
	cmp [X+6],0
	jz L76
X22:
	cmp [X+5],0
	jnz X23
	cmp [X+6],1
	jz L77
X23:
	cmp [X+5],0
	jnz X24
	cmp [X+6],2
	jz L78
X24:
	cmp [X+5],0
	jnz X25
	cmp [X+6],3
	jz L79
X25:
	xjmp L73
X11:
	.dbline 278
; 		{
L76:
	.dbline 280
; 		case 0:
; 			PWM8_1_WritePulseWidth(v);
	mov REG[0xd0],>__r0
	mov A,[X+1]
	push X
	xcall _PWM8_1_WritePulseWidth
	pop X
	.dbline 281
; 			break;
	xjmp L74
L77:
	.dbline 283
; 		case 1:
; 			PWM8_2_WritePulseWidth(v);
	mov REG[0xd0],>__r0
	mov A,[X+1]
	push X
	xcall _PWM8_2_WritePulseWidth
	pop X
	.dbline 284
; 			break;
	xjmp L74
L78:
	.dbline 286
; 		case 2:
; 			PWM8_3_WritePulseWidth(v);
	mov REG[0xd0],>__r0
	mov A,[X+1]
	push X
	xcall _PWM8_3_WritePulseWidth
	pop X
	.dbline 287
; 			break;
	xjmp L74
L79:
	.dbline 289
; 		case 3:
; 			PWM8_4_WritePulseWidth(v);
	mov REG[0xd0],>__r0
	mov A,[X+1]
	push X
	xcall _PWM8_4_WritePulseWidth
	pop X
	.dbline 290
; 			break;						
L73:
L74:
	.dbline -2
	.dbline 292
; 		}	
; }
L47:
	add SP,-7
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l mode 4 c
	.dbsym l actualdir 3 c
	.dbsym l goaldir 2 c
	.dbsym l v 0 I
	.dbsym l i -4 c
	.dbend
	.dbfunc e doSlave _doSlave fV
;              c -> X+0
_doSlave::
	.dbline -1
	push X
	mov X,SP
	add SP,3
	.dbline 295
; 
; void doSlave(void)
; {
	.dbline 296
; 	char c=ED_SLAVE_getData();
	push X
	xcall _ED_SLAVE_getData
	pop X
	mov [X+0],A
	.dbline 299
; 	
; 	// wait for header
; 	if (slavebufpos==0 && c!=237)
	mov REG[0xd0],>_slavebufpos
	cmp [_slavebufpos],0
	jnz L81
	cmp [X+0],-19
	jz L81
	.dbline 300
; 	{
	.dbline 301
; 		badchars++;
	mov REG[0xd0],>_badchars
	inc [_badchars]
	.dbline 302
; 		return;
	xjmp L80
L81:
	.dbline 305
; 	}
; 	
; 	slavebuf[slavebufpos++]=c;
	mov REG[0xd0],>_slavebufpos
	mov A,[_slavebufpos]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov [__r0],0
	add A,1
	mov REG[0xd0],>_slavebufpos
	mov [_slavebufpos],A
	mov REG[0xd0],>__r0
	add [__r1],<_slavebuf
	adc [__r0],>_slavebuf
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X+0]
	mvi [__r1],A
	.dbline 307
; 	
; 	if (slavebufpos<2 || slavebufpos<slavebuf[1])
	mov REG[0xd0],>_slavebufpos
	cmp [_slavebufpos],2
	jz X26
	jc L86
X26:
	mov REG[0xd0],>_slavebufpos
	mov A,[_slavebufpos]
	mov REG[0xd0],>_slavebuf
	cmp A,[_slavebuf+1]
	jnc L83
X27:
L86:
	.dbline 308
; 		slavebufchk=(slavebufchk<<1) + c + (slavebufchk&0x80 ? 1 : 0);
	mov REG[0xd0],>_slavebufchk
	tst [_slavebufchk],-128
	jz L88
	mov [X+2],1
	mov [X+1],0
	xjmp L89
L88:
	mov [X+2],0
	mov [X+1],0
L89:
	mov REG[0xd0],>_slavebufchk
	mov A,[_slavebufchk]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov [__r0],0
	asl [__r1]
	rlc [__r0]
	mov A,[X+0]
	add [__r1],A
	adc [__r0],0
	mov A,[X+2]
	add [__r1],A
	mov A,[X+1]
	adc [__r0],A
	mov A,[__r1]
	mov REG[0xd0],>_slavebufchk
	mov [_slavebufchk],A
L83:
	.dbline 311
; 		
; 	// if we're too long, quit!
; 	if (slavebufpos>=SLAVEBUFSIZE)
	mov REG[0xd0],>_slavebufpos
	cmp [_slavebufpos],32
	jz X28
	jc L90
X28:
	.dbline 312
; 		{
	.dbline 313
; 		slavebufpos=0;
	mov REG[0xd0],>_slavebufpos
	mov [_slavebufpos],0
	.dbline 314
; 		slavebufchk=0;
	mov REG[0xd0],>_slavebufchk
	mov [_slavebufchk],0
	.dbline 315
; 		return;
	xjmp L80
L90:
	.dbline 319
; 		}
; 	
; 	// wait for rest of packet. 
; 	if (slavebuf[1]!=slavebufpos)
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+1]
	mov REG[0xd0],>_slavebufpos
	cmp A,[_slavebufpos]
	jz L92
	.dbline 320
; 		return;
	xjmp L80
L92:
	.dbline 322
; 	
; 	if (slavebufchk==slavebuf[slavebufpos-1])
	mov REG[0xd0],>_slavebufpos
	mov A,[_slavebufpos]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_slavebuf-1
	adc [__r0],>_slavebuf-1
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],A
	mov REG[0xd0],>_slavebufchk
	mov A,[_slavebufchk]
	mov REG[0xd0],>__r0
	cmp A,[__r0]
	jnz L95
	.dbline 323
; 		doSlaveMessage();
	xcall _doSlaveMessage
	xjmp L96
L95:
	.dbline 325
; 	else
; 		badchars+=slavebuf[1];
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+1]
	mov REG[0xd0],>_badchars
	add [_badchars],A
L96:
	.dbline 328
; 		
; 	// handle the packet
; 	slavebufpos=0;
	mov REG[0xd0],>_slavebufpos
	mov [_slavebufpos],0
	.dbline 329
; 	slavebufchk=0;
	mov REG[0xd0],>_slavebufchk
	mov [_slavebufchk],0
	.dbline -2
	.dbline 330
; }
L80:
	add SP,-3
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l c 0 c
	.dbend
	.dbfunc e updateAnalog _updateAnalog fV
;              v -> X+0
_updateAnalog::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 333
; 
; void updateAnalog(void)
; {
	.dbline 336
; 	unsigned int v;
; 
; 	v=(SAR6_2_cGetSample()<<10)+0x8000;
	push X
	xcall _SAR6_2_cGetSample
	mov REG[0xd0],>__r0
	pop X
	mov [__r1],A
	mov [__r0],0
	tst [__r1],-128
	jz X29
	mov [__r0],-1
X29:
	mov REG[0xd0],>__r0
	mov A,[__r1]
	mov [__r0],A
	mov [__r1],0
	asl [__r0]
	asl [__r1]
	rlc [__r0]
	mov A,[__r1]
	add A,0
	mov [X+1],A
	mov A,[__r0]
	adc A,-128
	mov [X+0],A
	.dbline 337
; 	analog[6]=analog[6]-(analog[6]>>analogFilter[6])+(v>>analogFilter[6]);
	mov REG[0xd0],>_analog
	mov A,[_analog+12+1]
	push A
	mov A,[_analog+12]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov [__r1],A
	mov REG[0xd0],>_analogFilter
	mov A,[_analogFilter+6]
	mov REG[0xd0],>__r0
	and A,15
	jz X30
X31:
	and F,-5
	mov REG[0xd0],>__r0
	rrc [__r0]
	rrc [__r1]
	dec A
	jnz X31
X30:
	mov REG[0xd0],>_analog
	mov A,[_analog+12+1]
	mov REG[0xd0],>__r0
	sub A,[__r1]
	mov [__r1],A
	mov REG[0xd0],>_analog
	mov A,[_analog+12]
	mov REG[0xd0],>__r0
	sbb A,[__r0]
	mov [__r0],A
	mov A,[X+1]
	mov [__r3],A
	mov A,[X+0]
	mov [__r2],A
	mov REG[0xd0],>_analogFilter
	mov A,[_analogFilter+6]
	mov REG[0xd0],>__r0
	and A,15
	jz X32
X33:
	and F,-5
	mov REG[0xd0],>__r0
	rrc [__r2]
	rrc [__r3]
	dec A
	jnz X33
X32:
	mov REG[0xd0],>__r0
	mov A,[__r1]
	add A,[__r3]
	mov REG[0xd0],>_analog
	mov [_analog+12+1],A
	mov REG[0xd0],>__r0
	mov A,[__r0]
	adc A,[__r2]
	mov REG[0xd0],>_analog
	mov [_analog+12],A
	.dbline 339
; 
; 	v=(SAR6_1_cGetSample()<<10)+0x8000;	
	push X
	xcall _SAR6_1_cGetSample
	mov REG[0xd0],>__r0
	pop X
	mov [__r1],A
	mov [__r0],0
	tst [__r1],-128
	jz X34
	mov [__r0],-1
X34:
	mov REG[0xd0],>__r0
	mov A,[__r1]
	mov [__r0],A
	mov [__r1],0
	asl [__r0]
	asl [__r1]
	rlc [__r0]
	mov A,[__r1]
	add A,0
	mov [X+1],A
	mov A,[__r0]
	adc A,-128
	mov [X+0],A
	.dbline 340
; 	analog[7]=analog[7]-(analog[7]>>analogFilter[7])+(v>>analogFilter[7]);
	mov REG[0xd0],>_analog
	mov A,[_analog+14+1]
	push A
	mov A,[_analog+14]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov [__r1],A
	mov REG[0xd0],>_analogFilter
	mov A,[_analogFilter+7]
	mov REG[0xd0],>__r0
	and A,15
	jz X35
X36:
	and F,-5
	mov REG[0xd0],>__r0
	rrc [__r0]
	rrc [__r1]
	dec A
	jnz X36
X35:
	mov REG[0xd0],>_analog
	mov A,[_analog+14+1]
	mov REG[0xd0],>__r0
	sub A,[__r1]
	mov [__r1],A
	mov REG[0xd0],>_analog
	mov A,[_analog+14]
	mov REG[0xd0],>__r0
	sbb A,[__r0]
	mov [__r0],A
	mov A,[X+1]
	mov [__r3],A
	mov A,[X+0]
	mov [__r2],A
	mov REG[0xd0],>_analogFilter
	mov A,[_analogFilter+7]
	mov REG[0xd0],>__r0
	and A,15
	jz X37
X38:
	and F,-5
	mov REG[0xd0],>__r0
	rrc [__r2]
	rrc [__r3]
	dec A
	jnz X38
X37:
	mov REG[0xd0],>__r0
	mov A,[__r1]
	add A,[__r3]
	mov REG[0xd0],>_analog
	mov [_analog+14+1],A
	mov REG[0xd0],>__r0
	mov A,[__r0]
	adc A,[__r2]
	mov REG[0xd0],>_analog
	mov [_analog+14],A
	.dbline 342
; 
; 	if (!DelSig_1_fIsDataAvailable())
	push X
	xcall _DelSig_1_fIsDataAvailable
	mov REG[0xd0],>__r0
	pop X
	cmp A,0
	jnz L110
	.dbline 343
; 		return;
	xjmp L99
L110:
	.dbline 345
; 
; 	v=DelSig_1_iGetDataClearFlag();
	push X
	xcall _DelSig_1_iGetDataClearFlag
	mov REG[0xd0],>__r0
	mov [__r0],X
	pop X
	mov [X+1],A
	mov A,[__r0]
	mov [X+0],A
	.dbline 347
; 
; 	analogDelay++;			// since the A/D is pipelined, we must throw out 2 samples after changing the mux.
	mov REG[0xd0],>_analogDelay
	inc [_analogDelay+1]
	adc [_analogDelay],0
	.dbline 348
; 	if (analogDelay>=3)
	mov A,[_analogDelay]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_analogDelay
	mov A,[_analogDelay+1]
	sub A,3
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L112
X39:
	.dbline 349
; 	{
	.dbline 350
; 		v=v<<2; // left align
	asl [X+1]
	rlc [X+0]
	asl [X+1]
	rlc [X+0]
	.dbline 352
; 		
; 		analogDelay=0;
	mov REG[0xd0],>_analogDelay
	mov [_analogDelay+1],0
	mov [_analogDelay],0
	.dbline 354
; 		
; 		analog[analogNext]=analog[analogNext]-(analog[analogNext]>>analogFilter[analogNext])+(v>>analogFilter[analogNext]);
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	push A
	mov A,[_analogNext]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov [__r1],A
	asl [__r1]
	rlc [__r0]
	add [__r1],<_analog
	adc [__r0],>_analog
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r2],A
	mvi A,[__r1]
	sub [__r1],2
	mov [__r3],A
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	add A,<_analogFilter
	mov REG[0xd0],>__r0
	mov [__r5],A
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext]
	adc A,>_analogFilter
	mov REG[0xd0],>__r0
	mov REG[0xd4],A
	mvi A,[__r5]
	mov [__r5],A
	mov [__r4],0
	mov A,[__r3]
	push A
	mov A,[__r2]
	mov [__r6],A
	pop A
	mov [__r7],A
	mov A,[__r5]
	and A,15
	jz X40
X41:
	and F,-5
	mov REG[0xd0],>__r0
	rrc [__r6]
	rrc [__r7]
	dec A
	jnz X41
X40:
	mov REG[0xd0],>__r0
	mov A,[__r7]
	sub [__r3],A
	mov A,[__r6]
	sbb [__r2],A
	mov A,[X+1]
	mov [__r7],A
	mov A,[X+0]
	mov [__r6],A
	mov A,[__r5]
	and A,15
	jz X42
X43:
	and F,-5
	mov REG[0xd0],>__r0
	rrc [__r6]
	rrc [__r7]
	dec A
	jnz X43
X42:
	mov REG[0xd0],>__r0
	mov A,[__r7]
	add [__r3],A
	mov A,[__r6]
	adc [__r2],A
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[__r2]
	mvi [__r1],A
	mov A,[__r3]
	mvi [__r1],A
	.dbline 356
; 		
; 		if (v<analogOffsetError[analogNext])
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	push A
	mov A,[_analogNext]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov [__r1],A
	asl [__r1]
	rlc [__r0]
	add [__r1],<_analogOffsetError
	adc [__r0],>_analogOffsetError
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],A
	mvi A,[__r1]
	mov [__r1],A
	mov A,[X+0]
	cmp A,[__r0]
	jnz X45
	mov A,[X+1]
	cmp A,[__r1]
	jz L114
X45:
	jnc L114
X44:
	.dbline 357
; 			analogOffsetError[analogNext]=v;
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	push A
	mov A,[_analogNext]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov [__r1],A
	asl [__r1]
	rlc [__r0]
	add [__r1],<_analogOffsetError
	adc [__r0],>_analogOffsetError
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X+0]
	mvi [__r1],A
	mov A,[X+1]
	mvi [__r1],A
L114:
	.dbline 360
; 			
; 		// rotate the port
; 		analogNext=(analogNext+1)&7;
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	add A,1
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext]
	adc A,0
	mov REG[0xd0],>__r0
	mov [__r0],A
	mov A,[__r1]
	and A,7
	mov REG[0xd0],>_analogNext
	mov [_analogNext+1],A
	mov REG[0xd0],>__r0
	mov A,[__r0]
	and A,0
	mov REG[0xd0],>_analogNext
	mov [_analogNext],A
	.dbline 361
; 		if (analogNext>=6)
	mov A,[_analogNext]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	sub A,6
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L116
X46:
	.dbline 362
; 			analogNext=0;
	mov REG[0xd0],>_analogNext
	mov [_analogNext+1],0
	mov [_analogNext],0
L116:
	.dbline 364
; 			
; 		AMUX4_1_InputSelect(analogNext>>1);
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	push A
	mov A,[_analogNext]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov [__r1],A
	asr [__r0]
	rrc [__r1]
	mov A,[__r1]
	push X
	xcall _AMUX4_1_InputSelect
	pop X
	.dbline 365
; 		AMUX4_2_InputSelect(analogNext>>1);
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	push A
	mov A,[_analogNext]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov [__r1],A
	asr [__r0]
	rrc [__r1]
	mov A,[__r1]
	push X
	xcall _AMUX4_2_InputSelect
	pop X
	.dbline 367
; 		
; 		if (analogNext&1)
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	and A,1
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext]
	and A,0
	mov REG[0xd0],>__r0
	cmp A,0
	jnz X47
	cmp [__r1],0
	jz L118
X47:
	.dbline 368
; 			ABF_CR0=ABF_CR0|0x80;
	or F,0x10  ; iopage = 1
	or REG[0x62],-128
	and F,0xEF ; iopage = 0
	xjmp L119
L118:
	.dbline 370
; 		else
; 			ABF_CR0=ABF_CR0&0x7f;
	or F,0x10  ; iopage = 1
	and REG[0x62],127
	and F,0xEF ; iopage = 0
L119:
	.dbline 371
L112:
	.dbline -2
	.dbline 373
; 	}
; 	
; }
L99:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l v 0 i
	.dbend
	.dbfunc e doSlaveMessage _doSlaveMessage fV
;           mask -> X+6
;            err -> X+5
;            dir -> X+4
;            len -> X+3
;              v -> X+2
;           port -> X+1
;              i -> X+0
_doSlaveMessage::
	.dbline -1
	push X
	mov X,SP
	add SP,7
	.dbline 379
; 
; 
; #define OFFSET 3
; 
; void doSlaveMessage()
; {
	.dbline 381
; 	unsigned char port, v, dir, i, mask;
; 	unsigned char len=slavebuf[1]-4;
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+1]
	sub A,4
	mov [X+3],A
	.dbline 384
; 	unsigned char err;
; 
; 	if (slavebuf[OFFSET]=='*' && len==1)
	cmp [_slavebuf+3],42
	jnz L122
	cmp [X+3],1
	jnz L122
	.dbline 385
; 	{
	.dbline 386
; 		sendPacket(slavebuf[2]);
	mov A,[_slavebuf+2]
	push A
	xcall _sendPacket
	add SP,-1
	.dbline 387
; 		return;
	xjmp L120
L122:
	.dbline 391
; 	}
; 
; 	// pwm slew: Wps
; 	if (slavebuf[OFFSET]=='W' && len==3)
	mov REG[0xd0],>_slavebuf
	cmp [_slavebuf+3],87
	jnz L126
	cmp [X+3],3
	jnz L126
	.dbline 392
; 	{
	.dbline 393
; 		port=slavebuf[OFFSET+1];
	mov A,[_slavebuf+4]
	mov [X+1],A
	.dbline 394
; 		v=slavebuf[OFFSET+2];
	mov A,[_slavebuf+5]
	mov [X+2],A
	.dbline 396
; 
; 		if (port>3)
	cmp [X+1],3
	jc L131
	jz L131
X48:
	.dbline 397
; 		{
	.dbline 398
; 			sendAck(slavebuf[2], EBADPORT);
	mov A,1
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 399
; 			return;
	xjmp L120
L131:
	.dbline 402
; 		}
; 			
; 		pwmSlew[port]=v;
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmSlew
	adc [__r0],>_pwmSlew
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X+2]
	mvi [__r1],A
	.dbline 403
; 		sendAck(slavebuf[2], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 404
; 		return;
	xjmp L120
L126:
	.dbline 408
; 		
; 	}
; 	
; 	if (slavebuf[OFFSET]=='F' && len==3)
	mov REG[0xd0],>_slavebuf
	cmp [_slavebuf+3],70
	jnz L135
	cmp [X+3],3
	jnz L135
	.dbline 409
; 	{
	.dbline 410
; 		port=slavebuf[OFFSET+1];
	mov A,[_slavebuf+4]
	mov [X+1],A
	.dbline 411
; 		v=slavebuf[OFFSET+2];
	mov A,[_slavebuf+5]
	mov [X+2],A
	.dbline 413
; 
; 		if (port>7)
	cmp [X+1],7
	jc L140
	jz L140
X49:
	.dbline 414
; 		{
	.dbline 415
; 			sendAck(slavebuf[2], EBADPORT);
	mov A,1
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 416
; 			return;
	xjmp L120
L140:
	.dbline 418
; 		}
; 		if (v>15)
	cmp [X+2],15
	jc L143
	jz L143
X50:
	.dbline 419
; 		{
	.dbline 420
; 			sendAck(slavebuf[2], EBADPARAM);
	mov A,2
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 421
; 			return;
	xjmp L120
L143:
	.dbline 424
; 		}
; 			
; 		analogFilter[port]=v;
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_analogFilter
	adc [__r0],>_analogFilter
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X+2]
	mvi [__r1],A
	.dbline 425
; 		sendAck(slavebuf[2], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 426
; 		return;
	xjmp L120
L135:
	.dbline 430
; 	}
; 	
; 	// digital write: Dpv
; 	if (slavebuf[OFFSET]=='D' && len==3)
	mov REG[0xd0],>_slavebuf
	cmp [_slavebuf+3],68
	jnz L147
	cmp [X+3],3
	jnz L147
	.dbline 431
; 	{
	.dbline 432
; 		port=slavebuf[OFFSET+1];
	mov A,[_slavebuf+4]
	mov [X+1],A
	.dbline 433
; 		v=slavebuf[OFFSET+2];
	mov A,[_slavebuf+5]
	mov [X+2],A
	.dbline 434
; 		if (port>3 || v>1)
	cmp [X+1],3
	jz X51
	jnc L154
X51:
	cmp [X+2],1
	jc L152
	jz L152
X52:
L154:
	.dbline 435
; 		{
	.dbline 436
; 			sendAck(slavebuf[2], EBADPORT);
	mov A,1
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 437
; 			return;
	xjmp L120
L152:
	.dbline 440
; 		}
; 		
; 		if (v>1)
	cmp [X+2],1
	jc L156
	jz L156
X53:
	.dbline 441
; 		{
	.dbline 442
; 			sendAck(slavebuf[2], EBADPARAM);
	mov A,2
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 443
; 			return;
	xjmp L120
L156:
	.dbline 446
; 		}
; 		
; 		if (v)
	cmp [X+2],0
	jz L159
	.dbline 447
; 			v=0xff;
	mov [X+2],-1
L159:
	.dbline 449
; 			
; 		port=1<<port;
	mov REG[0xd0],>__r0
	mov [__r0],1
	mov A,[X+1]
	and A,7
	jz X54
X55:
	mov REG[0xd0],>__r0
	asl [__r0]
	dec A
	jnz X55
X54:
	mov REG[0xd0],>__r0
	mov A,[__r0]
	mov [X+1],A
	.dbline 451
; 
; 		PRT2DR=(PRT2DR&prt2andmask&(~port))|prt2ormask|(v&port);
	mov A,REG[0x8]
	mov [__r0],A
	mov REG[0xd0],>_prt2andmask
	mov A,[_prt2andmask]
	mov REG[0xd0],>__r0
	and [__r0],A
	mov A,[X+1]
	cpl A
	and [__r0],A
	mov REG[0xd0],>_prt2ormask
	mov A,[_prt2ormask]
	mov REG[0xd0],>__r0
	or [__r0],A
	mov A,[X+2]
	and A,[X+1]
	or [__r0],A
	mov A,[__r0]
	mov REG[0x8],A
	.dbline 453
; 		
; 		sendAck(slavebuf[2], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 454
; 		return;
	xjmp L120
L147:
	.dbline 458
; 	}
; 	
; 	// set mode:   Cpm
; 	if (slavebuf[OFFSET]=='C' && len==3)
	mov REG[0xd0],>_slavebuf
	cmp [_slavebuf+3],67
	jnz L162
	cmp [X+3],3
	jnz L162
	.dbline 459
; 	{
	.dbline 460
; 		port=slavebuf[OFFSET+1];
	mov A,[_slavebuf+4]
	mov [X+1],A
	.dbline 461
; 		v=slavebuf[OFFSET+2];
	mov A,[_slavebuf+5]
	mov [X+2],A
	.dbline 462
; 		err=setpinmode(port, v);
	mov A,[X+2]
	push A
	mov A,[X+1]
	push A
	xcall _setpinmode
	add SP,-2
	mov [X+5],A
	.dbline 464
; 
; 		if (err)
	cmp [X+5],0
	jz L167
	.dbline 465
; 		{
	.dbline 466
; 			sendAck(slavebuf[2], err);
	mov A,[X+5]
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 467
; 			return;		
	xjmp L120
L167:
	.dbline 470
; 		}
; 		
; 		if (v==PINMODE_QUADPHASE)
	cmp [X+2],11
	jnz L170
	.dbline 471
; 		{
	.dbline 472
; 			for (i=0;i<4;i++)
	mov [X+0],0
	xjmp L175
L172:
	.dbline 473
	mov A,11
	push A
	mov A,[X+0]
	push A
	xcall _setpinmode
	add SP,-2
	mov REG[0xd0],>__r0
L173:
	.dbline 472
	inc [X+0]
L175:
	.dbline 472
	cmp [X+0],4
	jz X56
	jc L172
X56:
	.dbline 475
; 				setpinmode(i, PINMODE_QUADPHASE);	
; 			
; 			qpoffset=0x00;  // quadrature phase
	mov REG[0xd0],>_qpoffset
	mov [_qpoffset],0
	.dbline 476
; 			M8C_EnableIntMask(INT_MSK0, INT_MSK0_GPIO);		
	or REG[0xe0],32
	.dbline 477
; 		}
	xjmp L171
L170:
	.dbline 478
; 		else if (v==PINMODE_MONOPHASE)
	cmp [X+2],12
	jnz L176
	.dbline 479
; 		{
	.dbline 480
; 			setpinmode(0, PINMODE_MONOPHASE);
	mov A,12
	push A
	mov A,0
	push A
	xcall _setpinmode
	mov REG[0xd0],>__r0
	.dbline 481
; 			setpinmode(1, PINMODE_DIG_IN_PULLUP);
	mov A,1
	push A
	push A
	xcall _setpinmode
	add SP,-4
	mov REG[0xd0],>__r0
	.dbline 482
; 			setpinmode(2, PINMODE_MONOPHASE);
	mov A,12
	push A
	mov A,2
	push A
	xcall _setpinmode
	mov REG[0xd0],>__r0
	.dbline 483
; 			setpinmode(3, PINMODE_DIG_IN_PULLUP);		
	mov A,1
	push A
	mov A,3
	push A
	xcall _setpinmode
	add SP,-4
	.dbline 484
; 			qpoffset=0x10;  // mono phase
	mov REG[0xd0],>_qpoffset
	mov [_qpoffset],16
	.dbline 485
; 			M8C_EnableIntMask(INT_MSK0, INT_MSK0_GPIO);		
	or REG[0xe0],32
	.dbline 486
; 		}
	xjmp L177
L176:
	.dbline 488
; 		else
; 		{
	.dbline 489
; 			for (i=0;i<4;i++)
	mov [X+0],0
	xjmp L181
L178:
	.dbline 490
; 			{
	.dbline 491
; 				if (pinmode[i]==PINMODE_QUADPHASE || pinmode[i]==PINMODE_MONOPHASE)
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pinmode
	adc [__r0],>_pinmode
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r1],A
	mov [__r0],0
	cmp [__r0],0
	jnz X57
	cmp A,11
	jz L184
X57:
	mov REG[0xd0],>__r0
	cmp [__r0],0
	jnz L182
	cmp [__r1],12
	jnz L182
X58:
L184:
	.dbline 492
; 				{
	.dbline 493
; 					setpinmode(i, PINMODE_DIG_IN_PULLUP);	
	mov A,1
	push A
	mov A,[X+0]
	push A
	xcall _setpinmode
	add SP,-2
	mov REG[0xd0],>__r0
	.dbline 494
; 				}
L182:
	.dbline 495
L179:
	.dbline 489
	inc [X+0]
L181:
	.dbline 489
	cmp [X+0],4
	jz X59
	jc L178
X59:
	.dbline 496
; 			}						
; 			M8C_DisableIntMask(INT_MSK0, INT_MSK0_GPIO);		
	and REG[0xe0],-33
	.dbline 497
; 			}
L177:
L171:
	.dbline 499
; 						
; 		sendAck(slavebuf[2], err);
	mov A,[X+5]
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 500
; 		return;		
	xjmp L120
L162:
	.dbline 506
; 	}
; 
; 	// Motor: Mpdv  [port, direction, pwm value]
; 	// direction, [0,1,2] (0=disabled, 1=forw, 2=back. Braking occurs with either forw/back 
; 	// when pwm is small. When disabled, pwm is ignored. (this disables slewing))
; 	if (slavebuf[OFFSET]=='M' && len==4)
	mov REG[0xd0],>_slavebuf
	cmp [_slavebuf+3],77
	jnz L186
	cmp [X+3],4
	jnz L186
	.dbline 507
; 	{
	.dbline 508
; 		port=slavebuf[OFFSET+1];
	mov A,[_slavebuf+4]
	mov [X+1],A
	.dbline 509
; 		dir=slavebuf[OFFSET+2];
	mov A,[_slavebuf+5]
	mov [X+4],A
	.dbline 510
; 		v=slavebuf[OFFSET+3];
	mov A,[_slavebuf+6]
	mov [X+2],A
	.dbline 512
; 
; 		if (port>3)
	cmp [X+1],3
	jc L192
	jz L192
X60:
	.dbline 513
; 		{
	.dbline 514
; 			sendAck(slavebuf[2], EBADPORT);
	mov A,1
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 515
; 			return;
	xjmp L120
L192:
	.dbline 518
; 		}
; 		
; 		if (dir>2)
	cmp [X+4],2
	jc L195
	jz L195
X61:
	.dbline 519
; 		{
	.dbline 520
; 			sendAck(slavebuf[2], EBADPARAM);
	mov A,2
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 521
; 			return;
	xjmp L120
L195:
	.dbline 526
; 		}
; 
; 		// due to routing issues, motor ports 1 and 3 are wired up
; 		// backwards. So we reverse the direction of odd motors below.
; 		if (dir>0 && (dir&1))
	cmp [X+4],0
	jc L198
	jz L198
X62:
	tst [X+4],1
	jz L198
	.dbline 527
; 		{
	.dbline 528
; 			dir=2-dir;
	mov REG[0xd0],>__r0
	mov A,2
	sub A,[X+4]
	mov [X+4],A
	.dbline 529
; 		}
L198:
	.dbline 531
; 		
; 		motorDir[port]=(motorDir[port]&0x0c)|dir;
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_motorDir
	adc [__r0],>_motorDir
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	dec [__r1]
	mov [__r2],A
	and [__r2],12
	mov A,[X+4]
	or [__r2],A
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[__r2]
	mvi [__r1],A
	.dbline 532
; 		pwmGoal[port]=v;
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X+2]
	mvi [__r1],A
	.dbline 537
; 		
; 		// if they're disabling the motor, *really* shut it down
; 		// and set actual to zero so they don't accidentally start
; 		// it back up too fast.
; 		mask=(1<<port)<<4; // convert the port to a mask.
	mov [__r0],1
	mov A,[X+1]
	and A,7
	jz X63
X64:
	mov REG[0xd0],>__r0
	asl [__r0]
	dec A
	jnz X64
X63:
	mov REG[0xd0],>__r0
	mov A,[__r0]
	asl A
	asl A
	asl A
	asl A
	mov [X+6],A
	.dbline 538
; 		if (dir==0)
	cmp [X+4],0
	jnz L200
	.dbline 539
; 		{
	.dbline 540
; 			pwmActual[port]=0;
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmActual
	adc [__r0],>_pwmActual
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 541
; 			pwmGoal[port]=0;
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 543
; 
; 			motorEnable&=(~mask);
	mov A,[X+6]
	cpl A
	mov REG[0xd0],>_motorEnable
	and [_motorEnable],A
	.dbline 544
; 		}
	xjmp L201
L200:
	.dbline 546
; 		else
; 		{
	.dbline 547
; 			motorEnable|=mask;	
	mov REG[0xd0],>_motorEnable
	mov A,[_motorEnable]
	or A,[X+6]
	mov [_motorEnable],A
	.dbline 548
; 		}
L201:
	.dbline 550
; 
; 		PRT2DR=(PRT2DR&0x0f)|motorEnable;
	mov A,REG[0x8]
	mov REG[0xd0],>__r0
	mov [__r0],A
	and [__r0],15
	mov REG[0xd0],>_motorEnable
	mov A,[_motorEnable]
	mov REG[0xd0],>__r0
	or [__r0],A
	mov A,[__r0]
	mov REG[0x8],A
	.dbline 552
; 		
; 		sendAck(slavebuf[2], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 553
; 		return;
	xjmp L120
L186:
	.dbline 557
; 	}
; 	
; 	// all stop! Set PWM goal to zero.
; 	if (slavebuf[OFFSET]=='X' && len==1)
	mov REG[0xd0],>_slavebuf
	cmp [_slavebuf+3],88
	jnz L203
	cmp [X+3],1
	jnz L203
	.dbline 558
; 	{
	.dbline 559
; 		for (i=0;i<4;i++)
	mov [X+0],0
	xjmp L209
L206:
	.dbline 560
	.dbline 561
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 562
L207:
	.dbline 559
	inc [X+0]
L209:
	.dbline 559
	cmp [X+0],4
	jz X65
	jc L206
X65:
	.dbline 564
; 		{
; 			pwmGoal[i]=0;
; 		}
; 		
; 		sendAck(slavebuf[2], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 565
; 		return;
	xjmp L120
L203:
	.dbline 568
; 	}
; 	
; 	sendAck(slavebuf[2], EUNKNOWNCMD);
	mov A,3
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 569
; 	return;
	.dbline -2
L120:
	add SP,-7
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l mask 6 c
	.dbsym l err 5 c
	.dbsym l dir 4 c
	.dbsym l len 3 c
	.dbsym l v 2 c
	.dbsym l port 1 c
	.dbsym l i 0 c
	.dbend
	.dbfunc e chksend _chksend fc
;              c -> X-5
;            chk -> X-4
_chksend::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 574
; 
; }
; 
; unsigned char chksend(unsigned char chk, unsigned char c)
; {
	.dbline 575
; 	ED_SLAVE_putData(c);
	push X
	mov A,[X-5]
	xcall _ED_SLAVE_putData
	pop X
	.dbline 576
; 	return (chk<<1)+c+(chk&0x80 ? 1: 0);
	tst [X-4],-128
	jz L214
	mov [X+1],1
	mov [X+0],0
	xjmp L215
L214:
	mov [X+1],0
	mov [X+0],0
L215:
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	asl [__r1]
	rlc [__r0]
	mov A,[X-5]
	add [__r1],A
	adc [__r0],0
	mov A,[X+1]
	add [__r1],A
	mov A,[X+0]
	adc [__r0],A
	mov A,[__r1]
	.dbline -2
L212:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l c -5 c
	.dbsym l chk -4 c
	.dbend
	.dbfunc e chksendi _chksendi fc
;              c -> X-6
;            chk -> X-4
_chksendi::
	.dbline -1
	push X
	mov X,SP
	.dbline 580
; }
; 
; unsigned char chksendi(unsigned char chk, unsigned int c)
; {
	.dbline 581
; 	chk = chksend(chk, c>>8);
	mov REG[0xd0],>__r0
	mov A,[X-6]
	push A
	mov A,[X-4]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X-4],A
	.dbline 582
; 	chk = chksend(chk, c&0xff);
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X-4],A
	.dbline 583
; 	return chk;
	mov A,[X-4]
	.dbline -2
L216:
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l c -6 i
	.dbsym l chk -4 c
	.dbend
	.dbfunc e sendAck _sendAck fV
;            chk -> X+0
;          error -> X-5
;          flags -> X-4
_sendAck::
	.dbline -1
	push X
	mov X,SP
	add SP,1
	.dbline 588
; }
; 
; // note: convention that error==0 means no error
; void sendAck(unsigned char flags, unsigned char error)
; {
	.dbline 589
; 	unsigned char chk=0;
	mov [X+0],0
	.dbline 591
; 	
; 	chk = chksend(chk, 237);
	mov A,-19
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 592
; 	chk = chksend(chk, 5);
	mov A,5
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 593
; 	chk = chksend(chk, flags);
	mov A,[X-4]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 594
; 	chk = chksend(chk, error);
	mov A,[X-5]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 595
; 	chk = chksend(chk, chk);
	mov A,[X+0]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline -2
	.dbline 596
; }
L217:
	add SP,-1
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l chk 0 c
	.dbsym l error -5 c
	.dbsym l flags -4 c
	.dbend
	.dbfunc e sendPacket _sendPacket fV
;             v2 -> X+4
;             v1 -> X+2
;            chk -> X+1
;              i -> X+0
;          flags -> X-4
_sendPacket::
	.dbline -1
	push X
	mov X,SP
	add SP,6
	.dbline 599
; 
; void sendPacket(unsigned char flags)
; {
	.dbline 600
; 	unsigned char chk=0;
	mov [X+1],0
	.dbline 604
; 	unsigned char i;
; 	unsigned int v1, v2;
; 		
; 	chk = chksend(chk, 237);
	mov A,-19
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 605
; 	chk = chksend(chk, 49);
	mov A,49
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 606
; 	chk = chksend(chk, flags);
	mov A,[X-4]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 607
; 	chk = chksend(chk, '*'); // i'm a state packet
	mov A,42
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-4
	mov [X+1],A
	.dbline 609
; 
; 	M8C_DisableGInt; // atomically sample quad phase data.
		and F, FEh

	.dbline 610
; 	v1=qpdata0;
	mov REG[0xd0],>_qpdata0
	mov A,[_qpdata0+1]
	mov [X+3],A
	mov A,[_qpdata0]
	mov [X+2],A
	.dbline 611
; 	v2=qpdata1;
	mov REG[0xd0],>_qpdata1
	mov A,[_qpdata1+1]
	mov [X+5],A
	mov A,[_qpdata1]
	mov [X+4],A
	.dbline 612
; 	M8C_EnableGInt;
		or  F, 01h

	.dbline 615
; 	
; 	// PIN MODES
; 	for (i=0;i<4;i+=2)
	mov [X+0],0
	xjmp L222
L219:
	.dbline 616
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pinmode
	adc [__r0],>_pinmode
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],A
	mov A,[X+0]
	mov [__r3],A
	mov [__r2],0
	add [__r3],<_pinmode+1
	adc [__r2],>_pinmode+1
	mov A,[__r2]
	mov REG[0xd4],A
	mvi A,[__r3]
	asl A
	asl A
	asl A
	asl A
	or [__r0],A
	mov A,[__r0]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+1],A
L220:
	.dbline 615
	add [X+0],2
L222:
	.dbline 615
	cmp [X+0],4
	jz X66
	jc L219
X66:
	.dbline 618
; 		chk = chksend(chk, pinmode[i] | (pinmode[i+1]<<4));
; 
; 	chk = chksend(chk, PRT2DR);
	mov A,REG[0x8]
	mov REG[0xd0],>__r0
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 620
; 	
; 	chk = chksendi(chk, v1);
	mov A,[X+2]
	push A
	mov A,[X+3]
	push A
	mov A,[X+1]
	push A
	xcall _chksendi
	mov [X+1],A
	.dbline 621
; 	chk = chksend(chk, qperrs0);
	mov REG[0xd0],>_qperrs0
	mov A,[_qperrs0]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-5
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 622
; 	chk = chksendi(chk, v2);
	mov A,[X+4]
	push A
	mov A,[X+5]
	push A
	mov A,[X+1]
	push A
	xcall _chksendi
	mov [X+1],A
	.dbline 623
; 	chk = chksend(chk, qperrs1);
	mov REG[0xd0],>_qperrs1
	mov A,[_qperrs1]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-5
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 625
; 
; 	for (i=0;i<4;i++)
	mov [X+0],0
	xjmp L227
L224:
	.dbline 626
	.dbline 627
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 628
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmActual
	adc [__r0],>_pwmActual
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 629
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmSlew
	adc [__r0],>_pwmSlew
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 630
L225:
	.dbline 625
	inc [X+0]
L227:
	.dbline 625
	cmp [X+0],4
	jz X67
	jc L224
X67:
	.dbline 632
; 	{
; 		chk = chksend(chk, pwmGoal[i]);
; 		chk = chksend(chk, pwmActual[i]);
; 		chk = chksend(chk, pwmSlew[i]);
; 	}
; 	
; 	for (i=0;i<4;i+=2)
	mov [X+0],0
	xjmp L231
L228:
	.dbline 633
	.dbline 634
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_motorDir+1
	adc [__r0],>_motorDir+1
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	asl A
	asl A
	asl A
	asl A
	mov [__r0],A
	mov A,[X+0]
	mov [__r3],A
	mov [__r2],0
	add [__r3],<_motorDir
	adc [__r2],>_motorDir
	mov A,[__r2]
	mov REG[0xd4],A
	mvi A,[__r3]
	or [__r0],A
	mov A,[__r0]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 635
L229:
	.dbline 632
	add [X+0],2
L231:
	.dbline 632
	cmp [X+0],4
	jz X68
	jc L228
X68:
	.dbline 638
; 	{
; 		chk = chksend(chk, (motorDir[i+1]<<4) | motorDir[i]);
; 	}
; 	
; 	// ANALOG
; 	for (i=0;i<8;i++)
	mov [X+0],0
	xjmp L236
L233:
	.dbline 639
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	asl [__r1]
	rlc [__r0]
	mov A,[__r1]
	add A,<_analog
	mov [__r3],A
	mov A,[__r0]
	adc A,>_analog
	mov REG[0xd4],A
	mvi A,[__r3]
	mov [__r2],A
	mvi A,[__r3]
	mov [__r3],A
	add [__r1],<_analogOffsetError
	adc [__r0],>_analogOffsetError
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],A
	mvi A,[__r1]
	mov [__r1],A
	mov A,[__r3]
	sub A,[__r1]
	mov [__r1],A
	mov A,[__r2]
	sbb A,[__r0]
	push A
	mov A,[__r1]
	push A
	mov A,[X+1]
	push A
	xcall _chksendi
	add SP,-3
	mov REG[0xd0],>__r0
	mov [X+1],A
L234:
	.dbline 638
	inc [X+0]
L236:
	.dbline 638
	cmp [X+0],8
	jz X69
	jc L233
X69:
	.dbline 641
; 		chk = chksendi(chk, analog[i]-analogOffsetError[i]); 
; 
; 	for (i=0;i<8;i+=2)
	mov [X+0],0
	xjmp L240
L237:
	.dbline 642
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_analogFilter+1
	adc [__r0],>_analogFilter+1
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	asl A
	asl A
	asl A
	asl A
	mov [__r0],A
	mov A,[X+0]
	mov [__r3],A
	mov [__r2],0
	add [__r3],<_analogFilter
	adc [__r2],>_analogFilter
	mov A,[__r2]
	mov REG[0xd4],A
	mvi A,[__r3]
	or [__r0],A
	mov A,[__r0]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+1],A
L238:
	.dbline 641
	add [X+0],2
L240:
	.dbline 641
	cmp [X+0],8
	jz X70
	jc L237
X70:
	.dbline 644
; 		chk = chksend(chk, (analogFilter[i+1]<<4) | analogFilter[i]);
; 	
; 	chk = chksend(chk, badchars);
	mov REG[0xd0],>_badchars
	mov A,[_badchars]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 646
; 	
; 	chk = chksend(chk, chk);
	mov A,[X+1]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline -2
	.dbline 647
; }
L218:
	add SP,-6
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l v2 4 i
	.dbsym l v1 2 i
	.dbsym l chk 1 c
	.dbsym l i 0 c
	.dbsym l flags -4 c
	.dbend
	.dbfunc e setpinmode _setpinmode fc
;            dm0 -> X+6
;            dm1 -> X+5
;            dm2 -> X+4
;        andmask -> X+3
;             gs -> X+2
;         ormask -> X+1
;           mask -> X+0
;           mode -> X-5
;            pin -> X-4
_setpinmode::
	.dbline -1
	push X
	mov X,SP
	add SP,9
	.dbline 651
; 
; // returns non-zero on error
; unsigned char setpinmode(unsigned char pin, unsigned char mode)
; {
	.dbline 653
; unsigned char mask;
; unsigned char dm2, dm1, dm0, gs=0;
	mov [X+2],0
	.dbline 654
; unsigned char ormask=0, andmask=0xff;
	mov [X+1],0
	.dbline 654
	mov [X+3],-1
	.dbline 688
; 
; // Summary of Tech Ref Manual info:
; // Each pin described by three bits, called DM2, DM1, and DM0.
; // Each bit is stored in a different register.
; //
; // DM: 2 1 0	Pin Output High    Pin Output Low    Notes
; // ----------   ----------------   ----------------  -------------------
; //     0 0 0         Strong           Resistive		 "pull down", set out=1
; //     0 0 1         Strong            Strong        "totem pole"
; //     0 1 0          Hi-Z              Hi-Z         Digital Input Enabled
; //     0 1 1        Resistive          Strong        "pull up", set out=0
; //     1 0 0          Weak              Hi-Z         
; //     1 0 1          Weak              Weak         "weak totem pole"
; //     1 1 0          Hi-Z				Hi-Z         Analog Input
; //     1 1 1          Hi-Z              Weak         I2C-Compat.
; //
; // PRTxGS port connects the pin to its corresponding global bus.
; // If DM210=010, it connects to global input
; // Otherwise, it connects to global output.
; //
; // Note: 
; // If using pull-ups, you MUST write '0's to the corresponding bit whenever
; // you write to PRTxDR. Likewise, when using pull-downs, you MUST write '1's to 
; // the corresponding bit.
; //
; // Here's our general scheme: for a given pin, it can have any of a number of
; // "standard" modes (dig in/out, analog in for some pins). The "special" modes, 
; // such as servo, sonar_echo, are activated by setting the corresponding GS pin.
; // We "preconfigure" all of the special modes so that by setting the GS pin, it 
; // becomes appropriately connected. Note that this means that any given pin can only
; // have a single "special" function.
; 
; // catch illegal arguments 
; if (pin>3)   // illegal pin number
	cmp [X-4],3
	jc L243
	jz L243
X72:
	.dbline 689
; 	return EBADPORT;
	mov REG[0xd0],>__r0
	mov A,1
	xjmp L242
L243:
	.dbline 691
; 
; if (pin>PINMODE_MAX)
	cmp [X-4],12
	jc L245
	jz L245
X73:
	.dbline 692
; 	return EBADPARAM;
	mov REG[0xd0],>__r0
	mov A,2
	xjmp L242
L245:
	.dbline 695
; 
; // Look-up table for our mode pins.
; switch (mode)
	mov A,[X-5]
	mov [X+8],A
	mov [X+7],0
	cmp [X+7],0
	jnz X74
	cmp [X+8],0
	jz L250
X74:
	cmp [X+7],0
	jnz X75
	cmp [X+8],1
	jz L251
X75:
	cmp [X+7],0
	jnz X76
	cmp [X+8],2
	jz L252
X76:
	cmp [X+7],0
	jnz X77
	cmp [X+8],3
	jz L253
X77:
	cmp [X+7],0
	jnz X78
	cmp [X+8],4
	jz L254
X78:
	cmp [X+7],0
	jnz X79
	cmp [X+8],8
	jz L256
X79:
	cmp [X+7],0
	jnz X80
	cmp [X+8],9
	jz L256
X80:
	cmp [X+7],0
	jnz X81
	cmp [X+8],11
	jz L255
X81:
	cmp [X+7],0
	jnz X82
	cmp [X+8],12
	jz L255
X82:
	xjmp L247
X71:
	.dbline 696
; 	{
L250:
	.dbline 698
; 	case PINMODE_DIG_IN:
; 		dm2=0x00; dm1=0xff; dm0=0x00;
	mov [X+4],0
	.dbline 698
	mov [X+5],-1
	.dbline 698
	mov [X+6],0
	.dbline 699
; 		break;
	xjmp L248
L251:
	.dbline 702
; 	
; 	case PINMODE_DIG_IN_PULLUP:
; 		dm2=0x00; dm1=0xff; dm0=0xff;
	mov [X+4],0
	.dbline 702
	mov [X+5],-1
	.dbline 702
	mov [X+6],-1
	.dbline 703
; 		ormask=0xff;
	mov [X+1],-1
	.dbline 704
; 		break;
	xjmp L248
L252:
	.dbline 707
; 
; 	case PINMODE_DIG_IN_PULLDN:
; 		dm2=0x00; dm1=0x00; dm0=0x00;
	mov [X+4],0
	.dbline 707
	mov [X+5],0
	.dbline 707
	mov [X+6],0
	.dbline 708
; 		andmask=0x00;
	mov [X+3],0
	.dbline 709
; 		break;
	xjmp L248
L253:
	.dbline 712
; 
; 	case PINMODE_DIG_OUT_STRONG:
; 		dm2=0x00; dm1=0x00; dm0=0xff;
	mov [X+4],0
	.dbline 712
	mov [X+5],0
	.dbline 712
	mov [X+6],-1
	.dbline 713
; 		break;
	xjmp L248
L254:
	.dbline 716
; 		
; 	case PINMODE_DIG_OUT_SLOW:
; 		dm2=0xff; dm1=0x00; dm0=0xff;
	mov [X+4],-1
	.dbline 716
	mov [X+5],0
	.dbline 716
	mov [X+6],-1
	.dbline 717
; 		break;
	xjmp L248
L255:
	.dbline 721
; 		
; 	case PINMODE_MONOPHASE:
; 	case PINMODE_QUADPHASE:
; 		dm2=0x00; dm1=0xff; dm0=0x00; gs=0xff;
	mov [X+4],0
	.dbline 721
	mov [X+5],-1
	.dbline 721
	mov [X+6],0
	.dbline 721
	mov [X+2],-1
	.dbline 722
; 		ormask=0xff;
	mov [X+1],-1
	.dbline 723
; 		break;	
	xjmp L248
L256:
	.dbline 727
; 	
; 	case PINMODE_ANALOG_OUT:
; 	case PINMODE_ANALOG_IN:
; 		dm2=0xff; dm1=0xff; dm0=0x00;
	mov [X+4],-1
	.dbline 727
	mov [X+5],-1
	.dbline 727
	mov [X+6],0
	.dbline 728
; 		break;	
	xjmp L248
L247:
	.dbline 731
; 
; 	default:
; 		return EBADPARAM; // unknown pin type
	mov REG[0xd0],>__r0
	mov A,2
	xjmp L242
L248:
	.dbline 734
; 	}
; 
; 	mask=1<<pin;
	mov REG[0xd0],>__r0
	mov [__r0],1
	mov A,[X-4]
	and A,7
	jz X83
X84:
	mov REG[0xd0],>__r0
	asl [__r0]
	dec A
	jnz X84
X83:
	mov REG[0xd0],>__r0
	mov A,[__r0]
	mov [X+0],A
	.dbline 735
; 	PRT2DM2=(PRT2DM2&(~mask)) | (dm2&mask);
	mov A,REG[0xb]
	mov [__r0],A
	mov A,[X+0]
	cpl A
	and [__r0],A
	mov A,[X+4]
	and A,[X+0]
	or [__r0],A
	mov A,[__r0]
	mov REG[0xb],A
	.dbline 736
; 	PRT2DM1=(PRT2DM1&(~mask)) | (dm1&mask);
	or F,0x10  ; iopage = 1
	mov A,REG[0x9]
	mov [__r0],A
	mov A,[X+0]
	cpl A
	and [__r0],A
	mov A,[X+5]
	and A,[X+0]
	or [__r0],A
	mov A,[__r0]
	mov REG[0x9],A
	.dbline 737
; 	PRT2DM0=(PRT2DM0&(~mask)) | (dm0&mask);
	mov A,REG[0x8]
	mov [__r0],A
	mov A,[X+0]
	cpl A
	and [__r0],A
	mov A,[X+6]
	and A,[X+0]
	or [__r0],A
	mov A,[__r0]
	mov REG[0x8],A
	and F,0xEF ; iopage = 0
	.dbline 738
; 	PRT2GS =(PRT2GS&(~mask))  | (gs&mask);
	mov A,REG[0xa]
	mov [__r0],A
	mov A,[X+0]
	cpl A
	and [__r0],A
	mov A,[X+2]
	and A,[X+0]
	or [__r0],A
	mov A,[__r0]
	mov REG[0xa],A
	.dbline 739
; 	prt2andmask = (prt2andmask&(~mask)) | (andmask&mask);
	mov A,[X+0]
	cpl A
	mov [__r0],A
	mov REG[0xd0],>_prt2andmask
	mov A,[_prt2andmask]
	mov REG[0xd0],>__r0
	and A,[__r0]
	mov [__r0],A
	mov A,[X+3]
	and A,[X+0]
	or [__r0],A
	mov A,[__r0]
	mov REG[0xd0],>_prt2andmask
	mov [_prt2andmask],A
	.dbline 740
; 	prt2ormask  = (prt2ormask&(~mask))  | (ormask&mask);
	mov REG[0xd0],>__r0
	mov A,[X+0]
	cpl A
	mov [__r0],A
	mov REG[0xd0],>_prt2ormask
	mov A,[_prt2ormask]
	mov REG[0xd0],>__r0
	and A,[__r0]
	mov [__r0],A
	mov A,[X+1]
	and A,[X+0]
	or [__r0],A
	mov A,[__r0]
	mov REG[0xd0],>_prt2ormask
	mov [_prt2ormask],A
	.dbline 742
; 	
; 	PRT2DR=(PRT2DR&prt2andmask) | prt2ormask;
	mov A,REG[0x8]
	mov REG[0xd0],>__r0
	mov [__r0],A
	mov REG[0xd0],>_prt2andmask
	mov A,[_prt2andmask]
	mov REG[0xd0],>__r0
	and [__r0],A
	mov REG[0xd0],>_prt2ormask
	mov A,[_prt2ormask]
	mov REG[0xd0],>__r0
	or [__r0],A
	mov A,[__r0]
	mov REG[0x8],A
	.dbline 744
; 
; 	pinmode[pin]=mode;
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pinmode
	adc [__r0],>_pinmode
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X-5]
	mvi [__r1],A
	.dbline 746
; 
; 	return ESUCCESS;
	mov A,0
	.dbline -2
L242:
	add SP,-9
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l dm0 6 c
	.dbsym l dm1 5 c
	.dbsym l dm2 4 c
	.dbsym l andmask 3 c
	.dbsym l gs 2 c
	.dbsym l ormask 1 c
	.dbsym l mask 0 c
	.dbsym l mode -5 c
	.dbsym l pin -4 c
	.dbend
	.area data(ram, con, rel)
	.dbfile ./main.c
_pinmode::
	.byte 0,0,0,0,0,0,0,0
	.dbsym e pinmode _pinmode A[8:8]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_lastcounter::
	.byte 0,0,0,0
	.dbsym e lastcounter _lastcounter L
	.area data(ram, con, rel)
	.dbfile ./main.c
_slavebuf::
	.word 0,0,0,0,0
	.word 0,0,0,0,0
	.word 0,0,0,0,0
	.byte 0,0
	.dbsym e slavebuf _slavebuf A[32:32]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_motorDir::
	.byte 0,0,0,0
	.dbsym e motorDir _motorDir A[4:4]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_pwmSlew::
	.byte 0,0,0,0
	.dbsym e pwmSlew _pwmSlew A[4:4]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_pwmActual::
	.byte 0,0,0,0
	.dbsym e pwmActual _pwmActual A[4:4]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_pwmGoal::
	.byte 0,0,0,0
	.dbsym e pwmGoal _pwmGoal A[4:4]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogResolution::
	.byte 0,0
	.dbsym e analogResolution _analogResolution S
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogDelay::
	.byte 0,0
	.dbsym e analogDelay _analogDelay S
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogNext::
	.byte 0,0
	.dbsym e analogNext _analogNext S
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogFilter::
	.byte 0,0,0,0,0,0,0,0
	.dbsym e analogFilter _analogFilter A[8:8]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogOffsetError::
	.word 0,0,0,0,0
	.byte 0,0
	.dbsym e analogOffsetError _analogOffsetError A[12:6]i
	.area data(ram, con, rel)
	.dbfile ./main.c
_analog::
	.word 0,0,0,0,0
	.byte 0,0,0,0,0,0
	.dbsym e analog _analog A[16:8]i
