;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: DelSig_1.inc
;;   Version: 1.0, Updated on 2004/08/11 at 11:08:56
;;
;;  DESCRIPTION: Assembler declarations for the Delta-Sigma A/D Converter
;;               with a 2nd-order modulator and based on a type 2 decimator.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"

;--------------------------------------------------
; Constants for DelSig_1 API's.
;--------------------------------------------------

DelSig_1_INT_REG:                  equ  0e1h
DelSig_1_INT_MASK:                 equ  02h     ; Interrupt mask

DelSig_1_OFF:                      equ  0
DelSig_1_LOWPOWER:                 equ  1
DelSig_1_MEDPOWER:                 equ  2
DelSig_1_HIGHPOWER:                equ  3

DelSig_1_DATA_READY_BIT:           equ  10h
DelSig_1_2S_COMPLEMENT:            equ  0

;--------------------------------------------------
; Register Address Constants for DelSig_1
;--------------------------------------------------

DelSig_1_PWM_DR0_MSB:              equ 0x24    ; Period reg
DelSig_1_PWM_DR0_LSB:              equ 0x20    ; Period reg
DelSig_1_PWM_DR1_MSB:              equ 0x25    ; Down count reg
DelSig_1_PWM_DR1_LSB:              equ 0x21    ; Down count reg
DelSig_1_PWM_DR2_MSB:              equ 0x26    ; Compare reg
DelSig_1_PWM_DR2_LSB:              equ 0x22    ; Compare reg
DelSig_1_PWM_CR0_MSB:              equ 0x27    ; Control reg
DelSig_1_PWM_CR0_LSB:              equ 0x23    ; Control reg
DelSig_1_PWM_FN_MSB:               equ 0x24    ; Function reg
DelSig_1_PWM_FN_LSB:               equ 0x20    ; Function reg
DelSig_1_PWM_SL_MSB:               equ 0x25    ; Input  select reg
DelSig_1_PWM_SL_LSB:               equ 0x21    ; Input  select reg
DelSig_1_PWM_OS_MSB:               equ 0x26    ; Output select reg
DelSig_1_PWM_OS_LSB:               equ 0x22    ; Output select reg

DelSig_1_AtoD1cr0:                 equ 0x9c    ; SC Block 1 Control Reg 0
DelSig_1_AtoD1cr1:                 equ 0x9d    ; SC Block 1 Control Reg 1
DelSig_1_AtoD1cr2:                 equ 0x9e    ; SC Block 1 Control Reg 2
DelSig_1_AtoD1cr3:                 equ 0x9f    ; SC Block 1 Control Reg 3
DelSig_1_AtoD2cr0:                 equ 0x8c    ; SC Block 2 Control Reg 0
DelSig_1_AtoD2cr1:                 equ 0x8d    ; SC Block 2 Control Reg 1
DelSig_1_AtoD2cr2:                 equ 0x8e    ; SC Block 2 Control Reg 2
DelSig_1_AtoD2cr3:                 equ 0x8f    ; SC Block 2 Control Reg 3


; end of file DelSig_1.inc
