	.module glcd.c
	.area data(ram, con, rel)
_GLCD_ConsoleX::
	.blkb 1
	.area idata
	.byte 0
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.dbsym e GLCD_ConsoleX _GLCD_ConsoleX c
_GLCD_ConsoleY::
	.blkb 1
	.area idata
	.byte 0
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.dbsym e GLCD_ConsoleY _GLCD_ConsoleY c
_GLCD_ConsoleTop::
	.blkb 1
	.area idata
	.byte 4
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.dbsym e GLCD_ConsoleTop _GLCD_ConsoleTop c
_GLCD_ConsoleHeight::
	.blkb 1
	.area idata
	.byte 4
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.dbsym e GLCD_ConsoleHeight _GLCD_ConsoleHeight c
_GLCD_ConsoleLeft::
	.blkb 1
	.area idata
	.byte 2
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.dbsym e GLCD_ConsoleLeft _GLCD_ConsoleLeft c
_GLCD_ConsoleWidth::
	.blkb 1
	.area idata
	.byte 21
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.dbsym e GLCD_ConsoleWidth _GLCD_ConsoleWidth c
_GLCD_ConsoleNewlinePending::
	.blkb 1
	.area idata
	.byte 0
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.dbsym e GLCD_ConsoleNewlinePending _GLCD_ConsoleNewlinePending c
_GLCD_DrawCharXor::
	.blkb 1
	.area idata
	.byte 0
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.dbsym e GLCD_DrawCharXor _GLCD_DrawCharXor c
	.area text(rom, con, rel)
	.dbfile ./glcd.c
	.dbfunc e GLCD_Init _GLCD_Init fV
_GLCD_Init::
	.dbline -1
	.dbline 59
; #include <stdlib.h>
; 
; #include "GLCD.h"
; #include "fnt58.h"
; 
; #define DELAY asm("nop \n nop \n nop");
; 
; // Getting maximum performance out of graphics module requires 
; // some careful hackery.
; //
; // C versions of all the calls are also available, but they 
; // can be 2-4 times slower!
; //
; // Line functions use basic drawing algorithms and internal
; // precision of 200th of a pixel in fixed-point format. With a 
; // screen width of 128, this ensures that the maximum pixel
; // error is less than 1 for a line of any slope.
; //
; // these functions are for internal use (and hence not included in
; // header file).
; void GLCD_WriteData(BYTE v, BYTE chipsel);
; void GLCD_WriteDataBulk(BYTE v, BYTE chipsel);
; void GLCD_WriteInstruction(BYTE v, BYTE chipsel);
; void GLCD_SetupBulkWrite(void);
; 
; BYTE GLCD_ReadData(BYTE chipsel);
; BYTE GLCD_ReadDataBulk(BYTE chipsel);
; BYTE GLCD_ReadStatus(BYTE chipsel);
; void GLCD_SetupBulkRead(void);
; 
; void GLCD_WaitUntilNotBusy(BYTE chipsel);
; 
; // internal but higher-level commands
; void GLCD_DisplayOnOff(BYTE on, BYTE chipsel);
; void GLCD_SetYAddress(BYTE v, BYTE chipsel);
; void GLCD_SetXAddress(BYTE v, BYTE chipsel);
; void GLCD_SetStartZAddress(BYTE v, BYTE chipsel);
; 
; 
; BYTE GLCD_ConsoleX=0;
; BYTE GLCD_ConsoleY=0;
; BYTE GLCD_ConsoleTop=4;
; BYTE GLCD_ConsoleHeight=4;
; BYTE GLCD_ConsoleLeft=2;
; BYTE GLCD_ConsoleWidth=21;
; 
; BYTE GLCD_ConsoleNewlinePending=0;
; 
; BYTE GLCD_DrawCharXor=0;
; 
; #pragma fastcall GLCD_WriteInstruction
; #pragma fastcall GLCD_WriteData
; #pragma fastcall GLCD_ReadData
; #pragma fastcall GLCD_ReadStatus
; #pragma fastcall GLCD_WaitUntilNotBusy
; 
; 
; void GLCD_Init()
; {
	.dbline 60
; 	DATABUS_READ;
	or F,0x10  ; iopage = 1
	mov REG[0x8],0
	.dbline 60
	mov REG[0x9],-1
	and F,0xEF ; iopage = 0
	.dbline 61
; 	CONTROLS = CS1 | CS2| RST;
	mov REG[0x4],28
	.dbline 63
; 	
; 	GLCD_WaitUntilNotBusy(CHIPSEL1);
	push X
	mov A,8
	xcall _GLCD_WaitUntilNotBusy
	.dbline 64
; 	GLCD_WaitUntilNotBusy(CHIPSEL2);
	mov A,4
	xcall _GLCD_WaitUntilNotBusy
	pop X
	.dbline 66
; 	
; 	GLCD_DisplayOnOff(1, CHIPSEL1);
	mov A,8
	push A
	mov A,1
	push A
	xcall _GLCD_DisplayOnOff
	.dbline 67
; 	GLCD_DisplayOnOff(1, CHIPSEL2);
	mov A,4
	push A
	mov A,1
	push A
	xcall _GLCD_DisplayOnOff
	add SP,-4
	.dbline 68
; 	GLCD_Clear();
	xcall _GLCD_Clear
	.dbline -2
	.dbline 69
; }
L1:
	.dbline 0 ; func end
	ret
	.dbend
	.dbfunc e GLCD_DisplayOnOff _GLCD_DisplayOnOff fV
;        chipsel -> X-5
;             on -> X-4
_GLCD_DisplayOnOff::
	.dbline -1
	push X
	mov X,SP
	.dbline 145
; 
; /*
; Reference C implementations:
; (see optimized assembly versions)
; 
; void GLCD_WaitUntilNotBusy(BYTE chipsel)
; {
; 	while (GLCD_ReadStatus(chipsel)&0x80);
; }
; 
; void GLCD_WriteInstruction(BYTE v, BYTE chipsel)
; {
; 	DATABUS_WRITE;
; 	DATABUS=v;
; 	
; 	CONTROLS = chipsel | RST;
; 	DELAY;
; 
; 	CONTROLS = chipsel | ENABLE | RST;
; 	DELAY;
; 	CONTROLS = chipsel | RST;
; 	
; 	DATABUS_READ;
; }
; 
; 
; void GLCD_WriteData(BYTE v, BYTE chipsel)
; {
; 	DATABUS_WRITE;
; 	DATABUS=v;
; 
; 	CONTROLS = chipsel | DI | RST;
; 	DELAY;
; 	CONTROLS = chipsel | DI | ENABLE | RST;
; 	DELAY;
; 	CONTROLS = chipsel | DI | RST;
; 	
; 	DATABUS_READ;
; 	
; }
; 
; BYTE GLCD_ReadData(BYTE chipsel)
; {
; 	BYTE v;
; 	
; 	DATABUS_READ;
; 	
; 	CONTROLS = chipsel | DI | RW | RST;
; 	DELAY;
; 	CONTROLS = chipsel | DI | RW | ENABLE | RST;
; 	DELAY;
; 	v=DATABUS;
; 	CONTROLS = chipsel | DI | RW | RST;
; 	
; 	return v;	
; }
; 
; BYTE GLCD_ReadStatus(BYTE chipsel)
; {
; 	BYTE v;
; 	
; 	DATABUS_READ;
; 	
; 	CONTROLS = chipsel | RW | RST;
; 	DELAY;
; 	CONTROLS = chipsel | RW | ENABLE | RST;
; 	DELAY;
; 	v=DATABUS;
; 	CONTROLS = chipsel | RW | RST;
; 	
; 	return v;	
; }
;  */
;  
; void GLCD_DisplayOnOff(BYTE on, BYTE chipsel)
; {
	.dbline 146
; 	GLCD_WriteInstruction(0x3e | on, chipsel);
	push X
	mov A,[X-5]
	push A
	mov A,[X-4]
	or A,62
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline -2
	.dbline 147
; }
L2:
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l chipsel -5 c
	.dbsym l on -4 c
	.dbend
	.dbfunc e GLCD_SetYAddress _GLCD_SetYAddress fV
;        chipsel -> X-5
;              v -> X-4
_GLCD_SetYAddress::
	.dbline -1
	push X
	mov X,SP
	.dbline 150
; 
; void GLCD_SetYAddress(BYTE v, BYTE chipsel)
; {
	.dbline 151
; 	GLCD_WriteInstruction(0x40 | v, chipsel);	
	push X
	mov A,[X-5]
	push A
	mov A,[X-4]
	or A,64
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline -2
	.dbline 152
; }
L3:
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l chipsel -5 c
	.dbsym l v -4 c
	.dbend
	.dbfunc e GLCD_SetXAddress _GLCD_SetXAddress fV
;        chipsel -> X-5
;              v -> X-4
_GLCD_SetXAddress::
	.dbline -1
	push X
	mov X,SP
	.dbline 155
; 
; void GLCD_SetXAddress(BYTE v, BYTE chipsel)
; {
	.dbline 156
; 	GLCD_WriteInstruction(0xb8 | v, chipsel);	
	push X
	mov A,[X-5]
	push A
	mov A,[X-4]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline -2
	.dbline 157
; }
L4:
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l chipsel -5 c
	.dbsym l v -4 c
	.dbend
	.dbfunc e GLCD_SetStartZAddress _GLCD_SetStartZAddress fV
;        chipsel -> X-5
;              v -> X-4
_GLCD_SetStartZAddress::
	.dbline -1
	push X
	mov X,SP
	.dbline 160
; 
; void GLCD_SetStartZAddress(BYTE v, BYTE chipsel)
; {
	.dbline 161
; 	GLCD_WriteInstruction(0xc0 | v, chipsel);	
	push X
	mov A,[X-5]
	push A
	mov A,[X-4]
	or A,-64
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline -2
	.dbline 162
; }
L5:
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l chipsel -5 c
	.dbsym l v -4 c
	.dbend
	.dbfunc e GLCD_Clear _GLCD_Clear fV
_GLCD_Clear::
	.dbline -1
	.dbline 165
; 
; void GLCD_Clear()
; {
	.dbline 166
; 	GLCD_Fill(0,0);
	mov A,0
	push A
	push A
	xcall _GLCD_Fill
	add SP,-2
	.dbline 167
; 	GLCD_ConsoleNewlinePending=0;
	mov [_GLCD_ConsoleNewlinePending],0
	.dbline -2
	.dbline 168
; }
L6:
	.dbline 0 ; func end
	ret
	.dbend
	.dbfunc e GLCD_Fill _GLCD_Fill fV
;           xadr -> X+2
;           yadr -> X+0
;  backgroundodd -> X-5
; backgroundeven -> X-4
_GLCD_Fill::
	.dbline -1
	push X
	mov X,SP
	add SP,4
	.dbline 171
; 	
; void GLCD_Fill(BYTE backgroundeven, BYTE backgroundodd)
; {
	.dbline 175
; 	int xadr;
; 	int yadr;
; 	
; 	for (xadr=0;xadr<8;xadr++)
	mov [X+3],0
	mov [X+2],0
L8:
	.dbline 176
; 	{
	.dbline 177
; 		GLCD_SetXAddress(xadr, CHIPSEL1);
	mov A,8
	push A
	mov A,[X+3]
	push A
	xcall _GLCD_SetXAddress
	.dbline 178
; 		GLCD_SetXAddress(xadr, CHIPSEL2);
	mov A,4
	push A
	mov A,[X+3]
	push A
	xcall _GLCD_SetXAddress
	add SP,-4
	.dbline 179
; 		GLCD_SetYAddress(0, CHIPSEL1);
	mov A,8
	push A
	mov A,0
	push A
	xcall _GLCD_SetYAddress
	.dbline 180
; 		GLCD_SetYAddress(0, CHIPSEL2);
	mov A,4
	push A
	mov A,0
	push A
	xcall _GLCD_SetYAddress
	add SP,-4
	.dbline 182
; 		
; 		for (yadr=0;yadr<64;yadr+=2)
	mov [X+1],0
	mov [X+0],0
L12:
	.dbline 183
	.dbline 184
	push X
	mov A,8
	push A
	mov A,[X-4]
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline 185
	push X
	mov A,8
	push A
	mov A,[X-5]
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline 186
L13:
	.dbline 182
	add [X+1],2
	adc [X+0],0
	.dbline 182
	mov A,[X+0]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,64
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L12
X0:
	.dbline 188
; 		{
; 			GLCD_WriteData(backgroundeven, CHIPSEL1);			
; 			GLCD_WriteData(backgroundodd, CHIPSEL1);			
; 		}
; 		
; 		for (yadr=64;yadr<128;yadr+=2)
	mov [X+1],64
	mov [X+0],0
L16:
	.dbline 189
	.dbline 190
	push X
	mov A,4
	push A
	mov A,[X-4]
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline 191
	push X
	mov A,4
	push A
	mov A,[X-5]
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline 192
L17:
	.dbline 188
	add [X+1],2
	adc [X+0],0
	.dbline 188
	mov A,[X+0]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,-128
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L16
X1:
	.dbline 193
L9:
	.dbline 175
	inc [X+3]
	adc [X+2],0
	.dbline 175
	mov A,[X+2]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+3]
	sub A,8
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L8
X2:
	.dbline 194
; 		{
; 			GLCD_WriteData(backgroundeven, CHIPSEL2);			
; 			GLCD_WriteData(backgroundodd, CHIPSEL2);			
; 		}
; 	}
; 	GLCD_ConsoleNewlinePending=0;
	mov [_GLCD_ConsoleNewlinePending],0
	.dbline -2
	.dbline 195
; }
L7:
	add SP,-4
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l xadr 2 I
	.dbsym l yadr 0 I
	.dbsym l backgroundodd -5 c
	.dbsym l backgroundeven -4 c
	.dbend
	.dbfunc e GLCD_DrawImage _GLCD_DrawImage fV
;           xadr -> X+4
;            idx -> X+2
;           yadr -> X+0
;              i -> X-5
_GLCD_DrawImage::
	.dbline -1
	push X
	mov X,SP
	add SP,6
	.dbline 198
; 
; void GLCD_DrawImage(const BYTE *i)
; {
	.dbline 203
; 	int xadr;
; 	int yadr;
; 	int idx;
; 
; 	idx=0;
	mov [X+3],0
	mov [X+2],0
	.dbline 205
; 	
; 	for (xadr=0;xadr<8;xadr++)
	mov [X+5],0
	mov [X+4],0
L21:
	.dbline 206
; 	{
	.dbline 207
; 		GLCD_SetXAddress(xadr, CHIPSEL1);
	mov A,8
	push A
	mov A,[X+5]
	push A
	xcall _GLCD_SetXAddress
	.dbline 208
; 		GLCD_SetXAddress(xadr, CHIPSEL2);
	mov A,4
	push A
	mov A,[X+5]
	push A
	xcall _GLCD_SetXAddress
	add SP,-4
	.dbline 209
; 		GLCD_SetYAddress(0, CHIPSEL1);
	mov A,8
	push A
	mov A,0
	push A
	xcall _GLCD_SetYAddress
	.dbline 210
; 		GLCD_SetYAddress(0, CHIPSEL2);
	mov A,4
	push A
	mov A,0
	push A
	xcall _GLCD_SetYAddress
	add SP,-4
	.dbline 212
; 
; 		for (yadr=0;yadr<64;yadr++)
	mov [X+1],0
	mov [X+0],0
L25:
	.dbline 213
	.dbline 214
	push X
	mov A,8
	push A
	mov A,[X+3]
	mov [__r1],A
	mov A,[X+2]
	mov [__r0],A
	mov A,[__r1]
	add A,1
	mov [X+3],A
	mov A,[__r0]
	adc A,0
	mov [X+2],A
	mov A,[X-4]
	add [__r1],A
	mov A,[X-5]
	adc [__r0],A
	mov A,[__r0]
	push X
	mov X,[__r1]
	romx
	pop X
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline 215
L26:
	.dbline 212
	inc [X+1]
	adc [X+0],0
	.dbline 212
	mov A,[X+0]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,64
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L25
X3:
	.dbline 217
; 		{
; 			GLCD_WriteData(i[idx++], CHIPSEL1);			
; 		}
; 		
; 		for (yadr=64;yadr<128;yadr++)
	mov [X+1],64
	mov [X+0],0
L29:
	.dbline 218
	.dbline 219
	push X
	mov A,4
	push A
	mov A,[X+3]
	mov [__r1],A
	mov A,[X+2]
	mov [__r0],A
	mov A,[__r1]
	add A,1
	mov [X+3],A
	mov A,[__r0]
	adc A,0
	mov [X+2],A
	mov A,[X-4]
	add [__r1],A
	mov A,[X-5]
	adc [__r0],A
	mov A,[__r0]
	push X
	mov X,[__r1]
	romx
	pop X
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline 220
L30:
	.dbline 217
	inc [X+1]
	adc [X+0],0
	.dbline 217
	mov A,[X+0]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,-128
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L29
X4:
	.dbline 222
L22:
	.dbline 205
	inc [X+5]
	adc [X+4],0
	.dbline 205
	mov A,[X+4]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+5]
	sub A,8
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L21
X5:
	.dbline 224
; 		{
; 			GLCD_WriteData(i[idx++], CHIPSEL2);			
; 		}
; 
; 	}
; 	
; 	GLCD_ConsoleNewlinePending=0;
	mov [_GLCD_ConsoleNewlinePending],0
	.dbline -2
	.dbline 225
; }
L20:
	add SP,-6
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l xadr 4 I
	.dbsym l idx 2 I
	.dbsym l yadr 0 I
	.dbsym l i -5 pc
	.dbend
	.dbfunc e GLCD_Plot _GLCD_Plot fV
;            adr -> X+3
;              b -> X+2
;              d -> X+1
;        chipsel -> X+0
;           mode -> X-6
;              y -> X-5
;              x -> X-4
_GLCD_Plot::
	.dbline -1
	push X
	mov X,SP
	add SP,4
	.dbline 228
; 
; void GLCD_Plot(BYTE x, BYTE y, BYTE mode)
; {
	.dbline 234
; 	BYTE chipsel;
; 	BYTE b;
; 	BYTE d;
; 	BYTE adr;
; 
; 	y=y&0x3f;
	and [X-5],63
	.dbline 235
; 	x=x&0x7f;
	and [X-4],127
	.dbline 238
; 		
; 	// which pixel to modify?
; 	d=y&7;
	mov A,[X-5]
	and A,7
	mov [X+1],A
	.dbline 239
; 	if (d<4) // 0123
	cmp [X+1],4
	jnc L34
X6:
	.dbline 240
; 		{
	.dbline 241
; 		if (d<2)  // 01
	cmp [X+1],2
	jnc L36
X7:
	.dbline 242
; 			{
	.dbline 243
; 				if (d==0)
	cmp [X+1],0
	jnz L38
	.dbline 244
; 					d=1;
	mov [X+1],1
	xjmp L35
L38:
	.dbline 246
; 				else
; 					d=2;
	mov [X+1],2
	.dbline 247
; 			}
	xjmp L35
L36:
	.dbline 249
; 		else	// 23
; 			{
	.dbline 250
; 				if (d==2)
	cmp [X+1],2
	jnz L40
	.dbline 251
; 					d=4;
	mov [X+1],4
	xjmp L35
L40:
	.dbline 253
; 				else
; 					d=8; 
	mov [X+1],8
	.dbline 254
; 			}
	.dbline 255
; 		}
	xjmp L35
L34:
	.dbline 257
; 	else // 4567
; 		{
	.dbline 258
; 		if (d<6)  // 45
	cmp [X+1],6
	jnc L42
X8:
	.dbline 259
; 			{
	.dbline 260
; 				if (d==4)
	cmp [X+1],4
	jnz L44
	.dbline 261
; 					d=16;
	mov [X+1],16
	xjmp L43
L44:
	.dbline 263
; 				else
; 					d=32;
	mov [X+1],32
	.dbline 264
; 			}
	xjmp L43
L42:
	.dbline 266
; 		else	// 67
; 			{
	.dbline 267
; 				if (d==6)
	cmp [X+1],6
	jnz L46
	.dbline 268
; 					d=64;
	mov [X+1],64
	xjmp L47
L46:
	.dbline 270
; 				else
; 					d=128; 
	mov [X+1],-128
L47:
	.dbline 271
; 			}
L43:
	.dbline 273
; 		
; 		}
L35:
	.dbline 275
; 	
; 	if (x>=64)
	cmp [X-4],64
	jz X9
	jc L48
X9:
	.dbline 276
; 		{
	.dbline 277
; 		adr=x-64;
	mov A,[X-4]
	sub A,64
	mov [X+3],A
	.dbline 278
; 		chipsel=CHIPSEL2;
	mov [X+0],4
	.dbline 279
; 		}
	xjmp L49
L48:
	.dbline 281
; 	else
; 		{
	.dbline 282
; 		adr=x;
	mov A,[X-4]
	mov [X+3],A
	.dbline 283
; 		chipsel=CHIPSEL1;
	mov [X+0],8
	.dbline 284
; 		}
L49:
	.dbline 286
; 			
; 	GLCD_SetYAddress(adr, chipsel);
	mov A,[X+0]
	push A
	mov A,[X+3]
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 287
; 	GLCD_SetXAddress(y/8, chipsel);
	mov A,[X+0]
	push A
	mov A,8
	push A
	mov A,[X-5]
	push A
	xcall __divmodu_8X8_8
	pop A
	add SP,-1
	push A
	xcall _GLCD_SetXAddress
	add SP,-2
	.dbline 288
; 	GLCD_ReadData(chipsel); // dummy read.
	push X
	mov A,[X+0]
	xcall _GLCD_ReadData
	pop X
	.dbline 289
; 	b=GLCD_ReadData(chipsel); // read the background
	push X
	mov A,[X+0]
	xcall _GLCD_ReadData
	pop X
	mov [X+2],A
	.dbline 291
;  
; 	if (mode==MODE_PLOT)
	cmp [X-6],1
	jnz L50
	.dbline 292
; 		b=b|d;
	mov A,[X+2]
	or A,[X+1]
	mov [X+2],A
	xjmp L51
L50:
	.dbline 293
; 	else if (mode==MODE_XOR)
	cmp [X-6],2
	jnz L52
	.dbline 294
; 		b=b^d;
	mov A,[X+2]
	xor A,[X+1]
	mov [X+2],A
	xjmp L53
L52:
	.dbline 295
; 	else if (mode==MODE_ERASE)
	cmp [X-6],0
	jnz L54
	.dbline 296
; 		b=b&(~d);
	mov A,[X+1]
	cpl A
	and [X+2],A
L54:
L53:
L51:
	.dbline 298
; 	
; 	GLCD_SetYAddress(adr, chipsel);
	mov A,[X+0]
	push A
	mov A,[X+3]
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 299
; 	GLCD_WriteData(b, chipsel);
	push X
	mov A,[X+0]
	push A
	mov A,[X+2]
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline -2
	.dbline 300
; }
L33:
	add SP,-4
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l adr 3 c
	.dbsym l b 2 c
	.dbsym l d 1 c
	.dbsym l chipsel 0 c
	.dbsym l mode -6 c
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
	.dbfunc e GLCD_DrawChar _GLCD_DrawChar fc
;         offset -> X+2
;    currentchip -> X+1
;            cnt -> X+0
;           font -> X-8
;              c -> X-6
;              y -> X-5
;              x -> X-4
_GLCD_DrawChar::
	.dbline -1
	push X
	mov X,SP
	add SP,4
	.dbline 303
; 
; BYTE GLCD_DrawChar(BYTE x, BYTE y, BYTE c, const BYTE *font)
; {
	.dbline 304
; 	int offset=4+(c&0x7f)*font[3];
	mov A,[X-6]
	mov [__r1],A
	mov [__r0],0
	and [__r1],127
	and [__r0],0
	mov A,[X-7]
	add A,3
	mov [__r3],A
	mov A,[X-8]
	adc A,0
	push X
	mov X,[__r3]
	romx
	pop X
	mov [__r3],A
	mov [__r2],0
	mov [__rX],0
	mov [__rY],0
X10:
	cmp [__r0],0
	jnz X13
	cmp [__r1],0
	jz X12
X13:
	and F,-5
	rrc [__r0]
	rrc [__r1]
	jnc X11
	mov A,[__r3]
	add [__rX],A
	mov A,[__r2]
	adc [__rY],A
X11:
	asl [__r3]
	rlc [__r2]
	jmp X10
X12:
	mov [__r1],[__rX]
	mov [__r0],[__rY]
	mov A,[__r1]
	add A,4
	mov [X+3],A
	mov A,[__r0]
	adc A,0
	mov [X+2],A
	.dbline 305
; 	BYTE cnt=0;
	mov [X+0],0
	.dbline 309
; 	BYTE currentchip;
; 
; 	// Convert given coordinates into LCD's coordinates:
; 	cnt=y;
	mov A,[X-5]
	mov [X+0],A
	.dbline 310
; 	y=x;
	mov A,[X-4]
	mov [X-5],A
	.dbline 311
; 	x=cnt/8;
	mov A,8
	push A
	mov A,[X+0]
	push A
	xcall __divmodu_8X8_8
	pop A
	mov [X-4],A
	add SP,-1
	.dbline 312
; 	cnt=0;
	mov [X+0],0
	.dbline 314
; 	
; 	if (y<0)
	cmp [X-5],0
	jnc L57
X14:
	.dbline 315
; 		{
	.dbline 316
; 		GLCD_SetYAddress(0, CHIPSEL1);
	mov A,8
	push A
	mov A,0
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 317
; 		currentchip=CHIPSEL1;
	mov [X+1],8
	.dbline 318
; 		}
	xjmp L58
L57:
	.dbline 319
; 	else if (y<64)
	cmp [X-5],64
	jnc L59
X15:
	.dbline 320
; 		{
	.dbline 321
; 		GLCD_SetYAddress(y, CHIPSEL1);
	mov A,8
	push A
	mov A,[X-5]
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 322
; 		currentchip=CHIPSEL1;
	mov [X+1],8
	.dbline 323
; 		}
	xjmp L60
L59:
	.dbline 325
; 	else
; 		{
	.dbline 326
; 		GLCD_SetYAddress(y-64, CHIPSEL2);
	mov A,4
	push A
	mov A,[X-5]
	sub A,64
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 327
; 		currentchip=CHIPSEL2;
	mov [X+1],4
	.dbline 328
; 		}
L60:
L58:
	.dbline 330
; 	
; 	GLCD_SetXAddress(x, currentchip);
	mov A,[X+1]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_SetXAddress
	add SP,-2
	.dbline 332
; 	
; 	for (cnt=0; cnt< font[1];cnt++)
	mov [X+0],0
	xjmp L64
L61:
	.dbline 333
; 	{
	.dbline 334
; 		if (y>=0 && y<128)
	cmp [X-5],0
	jz X16
	jc L65
X16:
	cmp [X-5],-128
	jnc L65
X17:
	.dbline 335
; 			GLCD_WriteData(font[offset+cnt]^GLCD_DrawCharXor, currentchip);
	push X
	mov A,[X+1]
	push A
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	mov A,[X+3]
	add A,[__r1]
	mov [__r1],A
	mov A,[X+2]
	adc A,[__r0]
	mov [__r0],A
	mov A,[X-7]
	add [__r1],A
	mov A,[X-8]
	adc [__r0],A
	mov A,[__r0]
	push X
	mov X,[__r1]
	romx
	pop X
	mov [__r0],A
	mov A,[_GLCD_DrawCharXor]
	xor [__r0],A
	mov A,[__r0]
	pop X
	xcall _GLCD_WriteData
	pop X
L65:
	.dbline 337
; 
; 		y++;
	inc [X-5]
	.dbline 338
; 		if (y==64)
	cmp [X-5],64
	jnz L67
	.dbline 339
; 			{
	.dbline 340
; 			GLCD_SetYAddress(0, CHIPSEL2);
	mov A,4
	push A
	mov A,0
	push A
	xcall _GLCD_SetYAddress
	.dbline 341
; 			currentchip=CHIPSEL2;
	mov [X+1],4
	.dbline 342
; 			GLCD_SetXAddress(x, currentchip);
	mov A,[X+1]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_SetXAddress
	add SP,-4
	.dbline 343
; 			}
L67:
	.dbline 344
L62:
	.dbline 332
	inc [X+0]
L64:
	.dbline 332
	mov A,[X-7]
	add A,1
	mov [__r1],A
	mov A,[X-8]
	adc A,0
	push X
	mov X,[__r1]
	romx
	pop X
	mov [__r0],A
	mov A,[X+0]
	cmp A,[__r0]
	jz X18
	jc L61
X18:
	.dbline 345
; 	}
; 	return font[1];
	mov A,[X-7]
	add A,1
	mov [__r1],A
	mov A,[X-8]
	adc A,0
	push X
	mov X,[__r1]
	romx
	pop X
	.dbline -2
L56:
	add SP,-4
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l offset 2 I
	.dbsym l currentchip 1 c
	.dbsym l cnt 0 c
	.dbsym l font -8 pc
	.dbsym l c -6 c
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
	.dbfunc e GLCD_DrawString _GLCD_DrawString fc
;         offset -> X+2
;            idx -> X+0
;           font -> X-9
;              c -> X-7
;              y -> X-5
;              x -> X-4
_GLCD_DrawString::
	.dbline -1
	push X
	mov X,SP
	add SP,3
	.dbline 349
; }
; 
; BYTE GLCD_DrawString(BYTE x, BYTE y, char *c, const BYTE *font)
; {
	.dbline 350
; 	int idx=0;
	mov [X+1],0
	mov [X+0],0
	.dbline 351
; 	BYTE offset=0;
	mov [X+2],0
	xjmp L71
L70:
	.dbline 354
	.dbline 355
	mov A,[X-9]
	push A
	mov A,[X-8]
	push A
	mov A,[X+1]
	add A,[X-6]
	mov [__r1],A
	mvi A,[__r1]
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	add A,[X+2]
	push A
	xcall _GLCD_DrawChar
	add SP,-5
	add [X+2],A
	.dbline 356
	inc [X+1]
	adc [X+0],0
	.dbline 357
L71:
	.dbline 353
; 	
; 	while (c[idx]!=0)
	mov A,[X+1]
	add A,[X-6]
	mov [__r1],A
	mvi A,[__r1]
	jnz L70
	.dbline 359
; 	{
; 		offset+=GLCD_DrawChar(x+offset, y, c[idx], font);
; 		idx++;
; 	}
; 	
; 	return offset;
	mov A,[X+2]
	.dbline -2
L69:
	add SP,-3
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l offset 2 c
	.dbsym l idx 0 I
	.dbsym l font -9 pc
	.dbsym l c -7 pc
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
	.dbfunc e GLCD_DrawStringC _GLCD_DrawStringC fc
;         offset -> X+2
;            idx -> X+0
;           font -> X-9
;              c -> X-7
;              y -> X-5
;              x -> X-4
_GLCD_DrawStringC::
	.dbline -1
	push X
	mov X,SP
	add SP,3
	.dbline 363
; }
; 
; BYTE GLCD_DrawStringC(BYTE x, BYTE y, const char *c, const BYTE *font)
; {
	.dbline 364
; 	int idx=0;
	mov [X+1],0
	mov [X+0],0
	.dbline 365
; 	BYTE offset=0;
	mov [X+2],0
	xjmp L75
L74:
	.dbline 368
	.dbline 369
	mov A,[X-9]
	push A
	mov A,[X-8]
	push A
	mov A,[X+1]
	add A,[X-6]
	mov [__r1],A
	mov A,[X+0]
	adc A,[X-7]
	push X
	mov X,[__r1]
	romx
	pop X
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	add A,[X+2]
	push A
	xcall _GLCD_DrawChar
	add SP,-5
	add [X+2],A
	.dbline 370
	inc [X+1]
	adc [X+0],0
	.dbline 371
L75:
	.dbline 367
; 	
; 	while (c[idx]!=0)
	mov A,[X+1]
	add A,[X-6]
	mov [__r1],A
	mov A,[X+0]
	adc A,[X-7]
	push X
	mov X,[__r1]
	romx
	pop X
	cmp A,0
	jnz L74
	.dbline 373
; 	{
; 		offset+=GLCD_DrawChar(x+offset, y, c[idx], font);
; 		idx++;
; 	}
; 	
; 	return offset;
	mov A,[X+2]
	.dbline -2
L73:
	add SP,-3
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l offset 2 c
	.dbsym l idx 0 I
	.dbsym l font -9 pc
	.dbsym l c -7 pc
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
	.dbfunc e GLCD_ConsoleWriteString _GLCD_ConsoleWriteString fV
;            idx -> X+0
;              c -> X-5
_GLCD_ConsoleWriteString::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 377
; }
; 
; void GLCD_ConsoleWriteString(char *c)
; {
	.dbline 378
; 	int idx=0;
	mov [X+1],0
	mov [X+0],0
	xjmp L79
L78:
	.dbline 381
	.dbline 382
	mov A,[X+1]
	add A,[X-4]
	mov [__r1],A
	mvi A,[__r1]
	push A
	xcall _GLCD_ConsoleWriteChar
	add SP,-1
	.dbline 383
	inc [X+1]
	adc [X+0],0
	.dbline 384
L79:
	.dbline 380
; 	
; 	while (c[idx]!=0)
	mov A,[X+1]
	add A,[X-4]
	mov [__r1],A
	mvi A,[__r1]
	jnz L78
	.dbline -2
	.dbline 385
; 	{
; 		GLCD_ConsoleWriteChar(c[idx]);
; 		idx++;
; 	}
; }
L77:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l idx 0 I
	.dbsym l c -5 pc
	.dbend
	.dbfunc e GLCD_ConsoleWriteStringC _GLCD_ConsoleWriteStringC fV
;            idx -> X+0
;              c -> X-5
_GLCD_ConsoleWriteStringC::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 388
; 
; void GLCD_ConsoleWriteStringC(const char *c)
; {
	.dbline 389
; 	int idx=0;
	mov [X+1],0
	mov [X+0],0
	xjmp L83
L82:
	.dbline 392
	.dbline 393
	mov A,[X+1]
	add A,[X-4]
	mov [__r1],A
	mov A,[X+0]
	adc A,[X-5]
	push X
	mov X,[__r1]
	romx
	pop X
	push A
	xcall _GLCD_ConsoleWriteChar
	add SP,-1
	.dbline 394
	inc [X+1]
	adc [X+0],0
	.dbline 395
L83:
	.dbline 391
; 	
; 	while (c[idx]!=0)
	mov A,[X+1]
	add A,[X-4]
	mov [__r1],A
	mov A,[X+0]
	adc A,[X-5]
	push X
	mov X,[__r1]
	romx
	pop X
	cmp A,0
	jnz L82
	.dbline -2
	.dbline 396
; 	{
; 		GLCD_ConsoleWriteChar(c[idx]);
; 		idx++;
; 	}
; }
L81:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l idx 0 I
	.dbsym l c -5 pc
	.dbend
	.dbfunc e GLCD_ConsoleWriteChar _GLCD_ConsoleWriteChar fV
;              c -> X-4
_GLCD_ConsoleWriteChar::
	.dbline -1
	push X
	mov X,SP
	.dbline 403
; 
; // we delay the printing/scrolling of newlines so we can get
; // a maximum amount of display area out of the LCD. (If we
; // didn't, then we "lose" a line due to always scrolling up
; // after the bottom line.)
; void GLCD_ConsoleWriteChar(char c)
; {
	.dbline 404
; 	if (GLCD_ConsoleNewlinePending)
	cmp [_GLCD_ConsoleNewlinePending],0
	jz L86
	.dbline 405
; 		{
	.dbline 406
; 		GLCD_ConsoleNewlinePending=0;
	mov [_GLCD_ConsoleNewlinePending],0
	.dbline 408
; 		
; 		GLCD_ConsoleX=0;
	mov [_GLCD_ConsoleX],0
	.dbline 409
; 		GLCD_ConsoleY++;
	inc [_GLCD_ConsoleY]
	.dbline 410
; 		if (GLCD_ConsoleY>=GLCD_ConsoleHeight)
	mov A,[_GLCD_ConsoleY]
	cmp A,[_GLCD_ConsoleHeight]
	jz X19
	jc L88
X19:
	.dbline 411
; 			{
	.dbline 412
; 			GLCD_ConsoleY=GLCD_ConsoleHeight-1;
	mov A,[_GLCD_ConsoleHeight]
	sub A,1
	mov [_GLCD_ConsoleY],A
	.dbline 413
; 			GLCD_ConsoleScroll();
	xcall _GLCD_ConsoleScroll
	.dbline 414
; 			GLCD_ConsoleEraseLine(GLCD_ConsoleY);
	mov A,[_GLCD_ConsoleY]
	push A
	xcall _GLCD_ConsoleEraseLine
	add SP,-1
	.dbline 415
; 			}
L88:
	.dbline 416
; 		}
L86:
	.dbline 418
; 		
; 	if (c==13) // \r
	cmp [X-4],13
	jnz L90
	.dbline 419
; 		return;
	xjmp L85
L90:
	.dbline 421
; 		
; 	if (c==10) // \n
	cmp [X-4],10
	jnz L92
	.dbline 422
; 		{
	.dbline 423
; 		GLCD_ConsoleNewlinePending=1;
	mov [_GLCD_ConsoleNewlinePending],1
	.dbline 424
; 		return;
	xjmp L85
L92:
	.dbline 427
; 		}
; 		
; 	if (c==9) // tab
	cmp [X-4],9
	jnz L94
	.dbline 428
; 		{
	.dbline 429
; 		GLCD_ConsoleX+=3;
	add [_GLCD_ConsoleX],3
	.dbline 430
; 		if (GLCD_ConsoleX>=GLCD_ConsoleWidth)
	mov A,[_GLCD_ConsoleX]
	cmp A,[_GLCD_ConsoleWidth]
	jz X20
	jc L85
X20:
	.dbline 431
; 			{
	.dbline 432
; 			GLCD_ConsoleX=0;
	mov [_GLCD_ConsoleX],0
	.dbline 433
; 			GLCD_ConsoleY++;
	inc [_GLCD_ConsoleY]
	.dbline 434
; 			if (GLCD_ConsoleY>=GLCD_ConsoleHeight)
	mov A,[_GLCD_ConsoleY]
	cmp A,[_GLCD_ConsoleHeight]
	jz X21
	jc L85
X21:
	.dbline 435
; 				{
	.dbline 436
; 				GLCD_ConsoleY=GLCD_ConsoleHeight-1;
	mov A,[_GLCD_ConsoleHeight]
	sub A,1
	mov [_GLCD_ConsoleY],A
	.dbline 437
; 				GLCD_ConsoleScroll();
	xcall _GLCD_ConsoleScroll
	.dbline 438
; 				GLCD_ConsoleEraseLine(GLCD_ConsoleY);
	mov A,[_GLCD_ConsoleY]
	push A
	xcall _GLCD_ConsoleEraseLine
	add SP,-1
	.dbline 439
; 				}
	.dbline 440
; 			}
	.dbline 441
; 		return;
	xjmp L85
L94:
	.dbline 444
; 		}
; 	
; 	if (c==8) // backspace
	cmp [X-4],8
	jnz L100
	.dbline 445
; 		{
	.dbline 446
; 		if (GLCD_ConsoleX==0 && GLCD_ConsoleY==0)
	cmp [_GLCD_ConsoleX],0
	jnz L102
	cmp [_GLCD_ConsoleY],0
	jnz L102
	.dbline 447
; 			return;
	xjmp L85
L102:
	.dbline 449
; 		
; 		if (GLCD_ConsoleX>0)
	cmp [_GLCD_ConsoleX],0
	jc L104
	jz L104
X22:
	.dbline 450
; 			{
	.dbline 451
; 			GLCD_ConsoleX--;
	dec [_GLCD_ConsoleX]
	.dbline 452
; 			return;
	xjmp L85
L104:
	.dbline 455
; 			}
; 		
; 		GLCD_ConsoleY--;
	dec [_GLCD_ConsoleY]
	.dbline 456
; 		GLCD_ConsoleX=GLCD_ConsoleWidth-1;
	mov A,[_GLCD_ConsoleWidth]
	sub A,1
	mov [_GLCD_ConsoleX],A
	.dbline 457
; 		return;		
	xjmp L85
L100:
	.dbline 460
; 		}
; 
; 	GLCD_DrawChar((GLCD_ConsoleX+GLCD_ConsoleLeft)*5, (GLCD_ConsoleY+GLCD_ConsoleTop)*8, c, fnt58);
	mov A,>_fnt58
	push A
	mov A,<_fnt58
	push A
	mov A,[X-4]
	push A
	mov A,[_GLCD_ConsoleY]
	add A,[_GLCD_ConsoleTop]
	asl A
	asl A
	asl A
	push A
	mov A,[_GLCD_ConsoleX]
	add A,[_GLCD_ConsoleLeft]
	mov REG[0xe8],A
	mov REG[0xe9],5
	nop
	mov A,REG[0xeb]
	push A
	xcall _GLCD_DrawChar
	add SP,-5
	.dbline 461
; 	GLCD_ConsoleX++;
	inc [_GLCD_ConsoleX]
	.dbline 462
; 	if (GLCD_ConsoleX>=GLCD_ConsoleWidth)
	mov A,[_GLCD_ConsoleX]
	cmp A,[_GLCD_ConsoleWidth]
	jz X23
	jc L106
X23:
	.dbline 463
; 		{
	.dbline 464
; 		GLCD_ConsoleX=0;
	mov [_GLCD_ConsoleX],0
	.dbline 465
; 		GLCD_ConsoleY++;
	inc [_GLCD_ConsoleY]
	.dbline 466
; 		if (GLCD_ConsoleY>=GLCD_ConsoleHeight)
	mov A,[_GLCD_ConsoleY]
	cmp A,[_GLCD_ConsoleHeight]
	jz X24
	jc L108
X24:
	.dbline 467
; 			{
	.dbline 468
; 			GLCD_ConsoleY=GLCD_ConsoleHeight-1;
	mov A,[_GLCD_ConsoleHeight]
	sub A,1
	mov [_GLCD_ConsoleY],A
	.dbline 469
; 			GLCD_ConsoleScroll();
	xcall _GLCD_ConsoleScroll
	.dbline 470
; 			GLCD_ConsoleEraseLine(GLCD_ConsoleY);
	mov A,[_GLCD_ConsoleY]
	push A
	xcall _GLCD_ConsoleEraseLine
	add SP,-1
	.dbline 471
; 			}
L108:
	.dbline 472
L106:
	.dbline -2
	.dbline 473
; 		}
; }
L85:
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l c -4 c
	.dbend
	.dbfunc e GLCD_DrawLine _GLCD_DrawLine fV
;              t -> X+4
;           step -> X+2
;        stepacc -> X+0
;              m -> X-8
;             y1 -> X-7
;             x1 -> X-6
;             y0 -> X-5
;             x0 -> X-4
_GLCD_DrawLine::
	.dbline -1
	push X
	mov X,SP
	add SP,7
	.dbline 477
; 
; void GLCD_DrawLine( char x0, char y0, 
; 					char x1, char y1, unsigned char m)
; {
	.dbline 482
; 	int step, stepacc;
; 	BYTE t;
; 		
; 	// ensure that (x0,y0) is always left of (x1,y1)
; 	if (x0>x1)
	mov A,[X-4]
	cmp A,[X-6]
	jc L111
	jz L111
X25:
	.dbline 483
; 		{
	.dbline 484
; 		t=x0;
	mov A,[X-4]
	mov [X+4],A
	.dbline 485
; 		x0=x1;
	mov A,[X-6]
	mov [X-4],A
	.dbline 486
; 		x1=t;
	mov A,[X+4]
	mov [X-6],A
	.dbline 487
; 		t=y0;
	mov A,[X-5]
	mov [X+4],A
	.dbline 488
; 		y0=y1;
	mov A,[X-7]
	mov [X-5],A
	.dbline 489
; 		y1=t;
	mov A,[X+4]
	mov [X-7],A
	.dbline 490
; 		}
L111:
	.dbline 493
; 		
; 	// are we moving faster in the X or Y direction?	
; 	if (abs(x1-x0)>abs(y1-y0))
	mov A,[X-6]
	mov [__r1],A
	mov [__r0],0
	mov A,[X-4]
	sub [__r1],A
	sbb [__r0],0
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	xcall _abs
	mov A,[__r1]
	mov [X+6],A
	mov A,[__r0]
	mov [X+5],A
	mov A,[X-7]
	mov [__r3],A
	mov [__r2],0
	mov A,[X-5]
	sub [__r3],A
	sbb [__r2],0
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	xcall _abs
	add SP,-4
	mov A,[X+5]
	xor A,-128
	mov [__rY],A
	mov A,[__r0]
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+6]
	sub A,[__r1]
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L113
	mov A,[__rX]
	jz L113
X26:
	.dbline 494
; 		{
	.dbline 497
; 		// we're moving in the X direction faster, so step in X
; 		// and compute y.
; 		stepacc=y0*128;
	mov A,[X-5]
	mov [__r1],A
	mov [__r0],0
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	mov A,[__r1]
	mov [X+1],A
	mov A,[__r0]
	mov [X+0],A
	.dbline 498
; 		step=(y1-y0)*128/(x1-x0);
	mov A,[X-7]
	mov [__r1],A
	mov [__r0],0
	mov A,[X-5]
	mov [__r2],0
	sub [__r1],A
	sbb [__r0],0
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	mov A,[X-6]
	mov [__r3],A
	mov A,[X-4]
	sub [__r3],A
	sbb [__r2],0
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	xcall __divmod_16X16_16
	pop A
	mov [X+3],A
	pop A
	mov [X+2],A
	add SP,-2
	xjmp L116
L115:
	.dbline 501
; 		
; 		while (x0!=x1)
; 			{
	.dbline 502
; 				GLCD_Plot(x0,stepacc/128, m);
	mov A,[X-8]
	push A
	mov A,0
	push A
	mov A,-128
	push A
	mov A,[X+0]
	push A
	mov A,[X+1]
	push A
	xcall __divmod_16X16_16
	pop A
	mov [__r1],A
	pop A
	add SP,-2
	mov A,[__r1]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_Plot
	add SP,-3
	.dbline 503
; 				stepacc+=step;
	mov A,[X+3]
	add [X+1],A
	mov A,[X+2]
	adc [X+0],A
	.dbline 504
; 				if (x0<x1)
	mov A,[X-4]
	cmp A,[X-6]
	jnc L118
X27:
	.dbline 505
; 					x0++;
	inc [X-4]
	xjmp L119
L118:
	.dbline 507
; 				else
; 					x0--;
	dec [X-4]
L119:
	.dbline 508
L116:
	.dbline 500
	mov A,[X-4]
	cmp A,[X-6]
	jnz L115
	.dbline 509
; 			}
; 		}
	xjmp L114
L113:
	.dbline 511
; 	else
; 		{
	.dbline 513
; 		// we're moving faster in the Y direction, so step in Y
; 		stepacc=x0*128;
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	mov A,[__r1]
	mov [X+1],A
	mov A,[__r0]
	mov [X+0],A
	.dbline 514
; 		step=(x1-x0)*128/(y1-y0);
	mov A,[X-6]
	mov [__r1],A
	mov [__r0],0
	mov A,[X-4]
	mov [__r2],0
	sub [__r1],A
	sbb [__r0],0
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	mov A,[X-7]
	mov [__r3],A
	mov A,[X-5]
	sub [__r3],A
	sbb [__r2],0
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	xcall __divmod_16X16_16
	pop A
	mov [X+3],A
	pop A
	mov [X+2],A
	add SP,-2
	xjmp L121
L120:
	.dbline 517
; 		
; 		while (y0!=y1)
; 			{
	.dbline 518
; 				GLCD_Plot((stepacc+64)/128, y0, m);
	mov A,[X-8]
	push A
	mov A,[X-5]
	push A
	mov A,[X+1]
	add A,64
	mov [__r1],A
	mov A,[X+0]
	adc A,0
	mov [__r0],A
	mov A,0
	push A
	mov A,-128
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	xcall __divmod_16X16_16
	pop A
	mov [__r1],A
	pop A
	add SP,-2
	mov A,[__r1]
	push A
	xcall _GLCD_Plot
	add SP,-3
	.dbline 519
; 				stepacc+=step;
	mov A,[X+3]
	add [X+1],A
	mov A,[X+2]
	adc [X+0],A
	.dbline 520
; 				if (y0<y1)
	mov A,[X-5]
	cmp A,[X-7]
	jnc L123
X28:
	.dbline 521
; 					y0++;
	inc [X-5]
	xjmp L124
L123:
	.dbline 523
; 				else
; 					y0--;
	dec [X-5]
L124:
	.dbline 524
L121:
	.dbline 516
	mov A,[X-5]
	cmp A,[X-7]
	jnz L120
	.dbline 525
L114:
	.dbline -2
	.dbline 526
; 			}
; 		}
; }
L110:
	add SP,-7
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l t 4 c
	.dbsym l step 2 I
	.dbsym l stepacc 0 I
	.dbsym l m -8 c
	.dbsym l y1 -7 c
	.dbsym l x1 -6 c
	.dbsym l y0 -5 c
	.dbsym l x0 -4 c
	.dbend
	.dbfunc e GLCD_ConsoleHome _GLCD_ConsoleHome fV
;           line -> X+0
_GLCD_ConsoleHome::
	.dbline -1
	push X
	mov X,SP
	add SP,1
	.dbline 529
; 
; void GLCD_ConsoleHome()
; {
	.dbline 532
; 	BYTE line;
; 	
; 	for (line=0;line<GLCD_ConsoleHeight;line++)
	mov [X+0],0
	xjmp L129
L126:
	.dbline 533
	.dbline 534
	mov A,[X+0]
	push A
	xcall _GLCD_ConsoleEraseLine
	add SP,-1
	.dbline 535
L127:
	.dbline 532
	inc [X+0]
L129:
	.dbline 532
	mov A,[X+0]
	cmp A,[_GLCD_ConsoleHeight]
	jz X29
	jc L126
X29:
	.dbline 536
; 	{
; 		GLCD_ConsoleEraseLine(line);
; 	}
; 	GLCD_ConsoleX=0;
	mov [_GLCD_ConsoleX],0
	.dbline 537
; 	GLCD_ConsoleY=0;
	mov [_GLCD_ConsoleY],0
	.dbline 538
; 	GLCD_ConsoleNewlinePending=0;
	mov [_GLCD_ConsoleNewlinePending],0
	.dbline -2
	.dbline 539
; }
L125:
	add SP,-1
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l line 0 c
	.dbend
	.dbfunc e GLCD_ConsoleEraseLine _GLCD_ConsoleEraseLine fV
;             x1 -> X+2
;        chipsel -> X+1
;             x0 -> X+0
;           line -> X-4
_GLCD_ConsoleEraseLine::
	.dbline -1
	push X
	mov X,SP
	add SP,3
	.dbline 542
; 
; void GLCD_ConsoleEraseLine(BYTE line)
; {
	.dbline 546
; 	BYTE x0, x1;
; 	BYTE chipsel;
; 			
; 	x0=GLCD_ConsoleLeft*5;
	mov A,[_GLCD_ConsoleLeft]
	mov REG[0xe8],A
	mov REG[0xe9],5
	nop
	mov A,REG[0xeb]
	mov [X+0],A
	.dbline 547
; 	x1=(GLCD_ConsoleLeft+GLCD_ConsoleWidth)*5;
	mov A,[_GLCD_ConsoleLeft]
	add A,[_GLCD_ConsoleWidth]
	mov REG[0xe8],A
	mov REG[0xe9],5
	nop
	mov A,REG[0xeb]
	mov [X+2],A
	.dbline 549
; 	
; 	line=(line+GLCD_ConsoleTop);
	mov A,[_GLCD_ConsoleTop]
	add [X-4],A
	.dbline 551
; 
; 	GLCD_SetXAddress(line, CHIPSEL1);
	mov A,8
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_SetXAddress
	.dbline 552
; 	GLCD_SetXAddress(line, CHIPSEL2);
	mov A,4
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_SetXAddress
	add SP,-4
	.dbline 554
; 	
; 	if (x0<64)
	cmp [X+0],64
	jnc L131
X30:
	.dbline 555
; 	{
	.dbline 556
; 		GLCD_SetYAddress(x0, CHIPSEL1);
	mov A,8
	push A
	mov A,[X+0]
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 557
; 		chipsel=CHIPSEL1;
	mov [X+1],8
	.dbline 558
; 	}
	xjmp L134
L131:
	.dbline 560
; 	else
; 	{
	.dbline 561
; 		GLCD_SetYAddress(x0-64,CHIPSEL2);
	mov A,4
	push A
	mov A,[X+0]
	sub A,64
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 562
; 		chipsel=CHIPSEL2;
	mov [X+1],4
	.dbline 563
; 	}
	xjmp L134
L133:
	.dbline 566
; 			
; 	while (x0<x1)
; 	{
	.dbline 567
; 		GLCD_WriteData(0, chipsel);			
	push X
	mov X,[X+1]
	mov A,0
	xcall _GLCD_WriteData
	pop X
	.dbline 569
; 	
; 		x0++;
	inc [X+0]
	.dbline 570
; 		if (x0==64)
	cmp [X+0],64
	jnz L136
	.dbline 571
; 		{
	.dbline 572
; 			GLCD_SetYAddress(0, CHIPSEL2);
	mov A,4
	push A
	mov A,0
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 573
; 			chipsel=CHIPSEL2;
	mov [X+1],4
	.dbline 574
; 		}
L136:
	.dbline 575
L134:
	.dbline 565
	mov A,[X+0]
	cmp A,[X+2]
	jz X31
	jc L133
X31:
	.dbline -2
	.dbline 576
; 	}
; }
L130:
	add SP,-3
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l x1 2 c
	.dbsym l chipsel 1 c
	.dbsym l x0 0 c
	.dbsym l line -4 c
	.dbend
	.dbfunc e GLCD_ConsoleScroll _GLCD_ConsoleScroll fV
;           ymin -> X+14
;           ymax -> X+13
;           line -> X+12
;              y -> X+11
;              b -> X+3
;        bufsize -> X+2
;        chipsel -> X+1
;              i -> X+0
_GLCD_ConsoleScroll::
	.dbline -1
	push X
	mov X,SP
	add SP,15
	.dbline 579
; 
; void GLCD_ConsoleScroll()
; {
	.dbline 588
; 	BYTE line;
; 	BYTE i;
; 	BYTE b[8];
; 	BYTE ymin,ymax;
; 	BYTE bufsize;
; 	BYTE chipsel;
; 	BYTE y;
; 	
; 	ymin=GLCD_ConsoleLeft*5;
	mov A,[_GLCD_ConsoleLeft]
	mov REG[0xe8],A
	mov REG[0xe9],5
	nop
	mov A,REG[0xeb]
	mov [X+14],A
	.dbline 589
; 	ymax=(GLCD_ConsoleLeft+GLCD_ConsoleWidth)*5;
	mov A,[_GLCD_ConsoleLeft]
	add A,[_GLCD_ConsoleWidth]
	mov REG[0xe8],A
	mov REG[0xe9],5
	nop
	mov A,REG[0xeb]
	mov [X+13],A
	.dbline 591
; 	
; 	for (line=GLCD_ConsoleTop;line<(GLCD_ConsoleTop+GLCD_ConsoleHeight);line++)
	mov A,[_GLCD_ConsoleTop]
	mov [X+12],A
	xjmp L142
L139:
	.dbline 592
; 		{
	.dbline 594
; 				
; 		y=ymin;
	mov A,[X+14]
	mov [X+11],A
	.dbline 595
; 		bufsize=8;
	mov [X+2],8
	xjmp L144
L143:
	.dbline 597
; 		while (y<ymax)
; 			{
	.dbline 598
; 				GLCD_SetXAddress(line+1, CHIPSEL1);
	mov A,8
	push A
	mov A,[X+12]
	add A,1
	push A
	xcall _GLCD_SetXAddress
	.dbline 599
; 				GLCD_SetXAddress(line+1, CHIPSEL2);
	mov A,4
	push A
	mov A,[X+12]
	add A,1
	push A
	xcall _GLCD_SetXAddress
	add SP,-4
	.dbline 601
; 
; 				if ((y+bufsize)>=ymax)
	mov A,[X+11]
	add A,[X+2]
	cmp A,[X+13]
	jz X32
	jc L146
X32:
	.dbline 602
; 					bufsize=ymax-y;
	mov A,[X+13]
	sub A,[X+11]
	mov [X+2],A
L146:
	.dbline 603
; 				if ((y+bufsize)>=64 && y<64)
	mov A,[X+11]
	add A,[X+2]
	cmp A,64
	jz X33
	jc L148
X33:
	cmp [X+11],64
	jnc L148
X34:
	.dbline 604
; 					bufsize=64-y;
	mov A,64
	sub A,[X+11]
	mov [X+2],A
L148:
	.dbline 606
; 				
; 				if (y<64)
	cmp [X+11],64
	jnc L150
X35:
	.dbline 607
; 					{
	.dbline 608
; 					chipsel=CHIPSEL1;
	mov [X+1],8
	.dbline 609
; 					GLCD_SetYAddress(y, chipsel);
	mov A,[X+1]
	push A
	mov A,[X+11]
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 610
; 					}
	xjmp L151
L150:
	.dbline 612
; 				else
; 					{
	.dbline 613
; 					chipsel=CHIPSEL2;
	mov [X+1],4
	.dbline 614
; 					GLCD_SetYAddress(y-64, chipsel);
	mov A,[X+1]
	push A
	mov A,[X+11]
	sub A,64
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 615
; 					}
L151:
	.dbline 617
; 				
; 				GLCD_ReadData(chipsel); // dummy read
	push X
	mov A,[X+1]
	xcall _GLCD_ReadData
	pop X
	.dbline 618
; 				for (i=0;i<bufsize;i++)	
	mov [X+0],0
	xjmp L155
L152:
	.dbline 619
	push X
	mov A,[X+1]
	xcall _GLCD_ReadData
	pop X
	mov [__r0],A
	mov A,[X+0]
	mov [__r3],A
	mov [__r2],0
	mov [__r5],X
	add [__r5],3
	mov A,[__r5]
	add [__r3],A
	mov A,[__r4]
	adc [__r2],A
	mov A,[__r0]
	mvi [__r3],A
L153:
	.dbline 618
	inc [X+0]
L155:
	.dbline 618
	mov A,[X+0]
	cmp A,[X+2]
	jz X36
	jc L152
X36:
	.dbline 621
; 					b[i]=GLCD_ReadData(chipsel);
; 					
; 				GLCD_SetXAddress(line, CHIPSEL1);
	mov A,8
	push A
	mov A,[X+12]
	push A
	xcall _GLCD_SetXAddress
	.dbline 622
; 				GLCD_SetXAddress(line, CHIPSEL2);
	mov A,4
	push A
	mov A,[X+12]
	push A
	xcall _GLCD_SetXAddress
	add SP,-4
	.dbline 624
; 
; 				if (y<64)
	cmp [X+11],64
	jnc L156
X37:
	.dbline 625
; 					{
	.dbline 626
; 					chipsel=CHIPSEL1;
	mov [X+1],8
	.dbline 627
; 					GLCD_SetYAddress(y, chipsel);
	mov A,[X+1]
	push A
	mov A,[X+11]
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 628
; 					}
	xjmp L157
L156:
	.dbline 630
; 				else
; 					{
	.dbline 631
; 					chipsel=CHIPSEL2;
	mov [X+1],4
	.dbline 632
; 					GLCD_SetYAddress(y-64, chipsel);
	mov A,[X+1]
	push A
	mov A,[X+11]
	sub A,64
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 633
; 					}
L157:
	.dbline 635
; 
; 				for (i=0;i<bufsize;i++)	
	mov [X+0],0
	xjmp L161
L158:
	.dbline 636
	push X
	mov A,[X+1]
	push A
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	mov [__r3],X
	add [__r3],3
	mov A,[__r3]
	add [__r1],A
	mov A,[__r2]
	adc [__r0],A
	mvi A,[__r1]
	pop X
	xcall _GLCD_WriteData
	pop X
L159:
	.dbline 635
	inc [X+0]
L161:
	.dbline 635
	mov A,[X+0]
	cmp A,[X+2]
	jz X38
	jc L158
X38:
	.dbline 638
	mov A,[X+2]
	add [X+11],A
	.dbline 639
L144:
	.dbline 596
	mov A,[X+11]
	cmp A,[X+13]
	jz X39
	jc L143
X39:
	.dbline 640
L140:
	.dbline 591
	inc [X+12]
L142:
	.dbline 591
	mov A,[_GLCD_ConsoleTop]
	add A,[_GLCD_ConsoleHeight]
	mov [__r0],A
	mov A,[X+12]
	cmp A,[__r0]
	jz X40
	jc L139
X40:
	.dbline -2
	.dbline 641
; 					GLCD_WriteData(b[i],chipsel);
; 					
; 				y+=bufsize;
; 			}
; 		}
; }
L138:
	add SP,-15
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l ymin 14 c
	.dbsym l ymax 13 c
	.dbsym l line 12 c
	.dbsym l y 11 c
	.dbsym l b 3 A[8:8]c
	.dbsym l bufsize 2 c
	.dbsym l chipsel 1 c
	.dbsym l i 0 c
	.dbend
	.dbfunc e GLCD_DrawRow _GLCD_DrawRow fV
;    currentchip -> X+1
;            cnt -> X+0
;            len -> X-8
;           data -> X-7
;              y -> X-5
;              x -> X-4
_GLCD_DrawRow::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 644
; 
; void GLCD_DrawRow(BYTE x, BYTE y, BYTE *data, BYTE len)
; {
	.dbline 645
; 	BYTE cnt=0;
	mov [X+0],0
	.dbline 649
; 	BYTE currentchip;
; 	
; 	// Convert given coordinates into LCD's coordinates:
; 	cnt=y;
	mov A,[X-5]
	mov [X+0],A
	.dbline 650
; 	y=x;
	mov A,[X-4]
	mov [X-5],A
	.dbline 651
; 	x=cnt/8;
	mov A,8
	push A
	mov A,[X+0]
	push A
	xcall __divmodu_8X8_8
	pop A
	mov [X-4],A
	add SP,-1
	.dbline 653
; 	
; 	if (y<0)
	cmp [X-5],0
	jnc L163
X41:
	.dbline 654
; 		{
	.dbline 655
; 		GLCD_SetYAddress(0, CHIPSEL1);
	mov A,8
	push A
	mov A,0
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 656
; 		currentchip=CHIPSEL1;
	mov [X+1],8
	.dbline 657
; 		}
	xjmp L164
L163:
	.dbline 658
; 	else if (y<64)
	cmp [X-5],64
	jnc L165
X42:
	.dbline 659
; 		{
	.dbline 660
; 		GLCD_SetYAddress(y, CHIPSEL1);
	mov A,8
	push A
	mov A,[X-5]
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 661
; 		currentchip=CHIPSEL1;
	mov [X+1],8
	.dbline 662
; 		}
	xjmp L166
L165:
	.dbline 664
; 	else
; 		{
	.dbline 665
; 		GLCD_SetYAddress(y-64, CHIPSEL2);
	mov A,4
	push A
	mov A,[X-5]
	sub A,64
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 666
; 		currentchip=CHIPSEL2;
	mov [X+1],4
	.dbline 667
; 		}
L166:
L164:
	.dbline 669
; 	
; 	GLCD_SetXAddress(x, currentchip);
	mov A,[X+1]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_SetXAddress
	add SP,-2
	.dbline 671
; 	
; 	for (cnt=0;cnt<len;cnt++)
	mov [X+0],0
	xjmp L170
L167:
	.dbline 672
; 	{
	.dbline 673
; 		if (y>=0 && y<128)
	cmp [X-5],0
	jz X43
	jc L171
X43:
	cmp [X-5],-128
	jnc L171
X44:
	.dbline 674
; 			GLCD_WriteData(data[cnt], currentchip);
	push X
	mov A,[X+1]
	push A
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	mov A,[X-6]
	add [__r1],A
	mov A,[X-7]
	adc [__r0],A
	mvi A,[__r1]
	pop X
	xcall _GLCD_WriteData
	pop X
L171:
	.dbline 676
; 
; 		y++;
	inc [X-5]
	.dbline 677
; 		if (y==64)
	cmp [X-5],64
	jnz L173
	.dbline 678
; 			{
	.dbline 679
; 			GLCD_SetYAddress(0, CHIPSEL2);
	mov A,4
	push A
	mov A,0
	push A
	xcall _GLCD_SetYAddress
	.dbline 680
; 			currentchip=CHIPSEL2;
	mov [X+1],4
	.dbline 681
; 			GLCD_SetXAddress(x, currentchip);
	mov A,[X+1]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_SetXAddress
	add SP,-4
	.dbline 682
; 			}
L173:
	.dbline 683
L168:
	.dbline 671
	inc [X+0]
L170:
	.dbline 671
	mov A,[X+0]
	cmp A,[X-8]
	jz X45
	jc L167
X45:
	.dbline -2
	.dbline 684
; 	}
; }
L162:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l currentchip 1 c
	.dbsym l cnt 0 c
	.dbsym l len -8 c
	.dbsym l data -7 pc
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
	.dbfunc e GLCD_ReadRow _GLCD_ReadRow fV
;    currentchip -> X+1
;            cnt -> X+0
;            len -> X-8
;           data -> X-7
;              y -> X-5
;              x -> X-4
_GLCD_ReadRow::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 688
; 
; 
; void GLCD_ReadRow(BYTE x, BYTE y, BYTE *data, BYTE len)
; {
	.dbline 689
; 	BYTE cnt=0;
	mov [X+0],0
	.dbline 693
; 	BYTE currentchip;
; 	
; 	// Convert given coordinates into LCD's coordinates:
; 	cnt=y;
	mov A,[X-5]
	mov [X+0],A
	.dbline 694
; 	y=x;
	mov A,[X-4]
	mov [X-5],A
	.dbline 695
; 	x=cnt/8;
	mov A,8
	push A
	mov A,[X+0]
	push A
	xcall __divmodu_8X8_8
	pop A
	mov [X-4],A
	add SP,-1
	.dbline 697
; 	
; 	if (y<0)
	cmp [X-5],0
	jnc L176
X46:
	.dbline 698
; 		{
	.dbline 699
; 		GLCD_SetYAddress(0, CHIPSEL1);
	mov A,8
	push A
	mov A,0
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 700
; 		currentchip=CHIPSEL1;
	mov [X+1],8
	.dbline 701
; 		}
	xjmp L177
L176:
	.dbline 702
; 	else if (y<64)
	cmp [X-5],64
	jnc L178
X47:
	.dbline 703
; 		{
	.dbline 704
; 		GLCD_SetYAddress(y, CHIPSEL1);
	mov A,8
	push A
	mov A,[X-5]
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 705
; 		currentchip=CHIPSEL1;
	mov [X+1],8
	.dbline 706
; 		}
	xjmp L179
L178:
	.dbline 708
; 	else
; 		{
	.dbline 709
; 		GLCD_SetYAddress(y-64, CHIPSEL2);
	mov A,4
	push A
	mov A,[X-5]
	sub A,64
	push A
	xcall _GLCD_SetYAddress
	add SP,-2
	.dbline 710
; 		currentchip=CHIPSEL2;
	mov [X+1],4
	.dbline 711
; 		}
L179:
L177:
	.dbline 713
; 	
; 	GLCD_SetXAddress(x, currentchip);
	mov A,[X+1]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_SetXAddress
	add SP,-2
	.dbline 715
; 	
; 	for (cnt=0;cnt<len;cnt++)
	mov [X+0],0
	xjmp L183
L180:
	.dbline 716
; 	{
	.dbline 717
; 		if (y>=0 && y<128)
	cmp [X-5],0
	jz X48
	jc L184
X48:
	cmp [X-5],-128
	jnc L184
X49:
	.dbline 718
; 			data[cnt]=GLCD_ReadData(currentchip);
	push X
	mov A,[X+1]
	xcall _GLCD_ReadData
	pop X
	mov [__r0],A
	mov A,[X+0]
	mov [__r3],A
	mov [__r2],0
	mov A,[X-6]
	add [__r3],A
	mov A,[X-7]
	adc [__r2],A
	mov A,[__r0]
	mvi [__r3],A
L184:
	.dbline 720
; 
; 		y++;
	inc [X-5]
	.dbline 721
; 		if (y==64)
	cmp [X-5],64
	jnz L186
	.dbline 722
; 			{
	.dbline 723
; 			GLCD_SetYAddress(0, CHIPSEL2);
	mov A,4
	push A
	mov A,0
	push A
	xcall _GLCD_SetYAddress
	.dbline 724
; 			currentchip=CHIPSEL2;
	mov [X+1],4
	.dbline 725
; 			GLCD_SetXAddress(x, currentchip);
	mov A,[X+1]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_SetXAddress
	add SP,-4
	.dbline 726
; 			}
L186:
	.dbline 727
L181:
	.dbline 715
	inc [X+0]
L183:
	.dbline 715
	mov A,[X+0]
	cmp A,[X-8]
	jz X50
	jc L180
X50:
	.dbline -2
	.dbline 728
; 	}
; }
L175:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l currentchip 1 c
	.dbsym l cnt 0 c
	.dbsym l len -8 c
	.dbsym l data -7 pc
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
