	cpu LMM
	.module glcd.c
	.area data(ram, con, rel)
_GLCD_ConsoleX::
	.byte 0
	.dbfile ./glcd.c
	.dbsym e GLCD_ConsoleX _GLCD_ConsoleX c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
_GLCD_ConsoleY::
	.byte 0
	.dbsym e GLCD_ConsoleY _GLCD_ConsoleY c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
_GLCD_ConsoleTop::
	.byte 4
	.dbsym e GLCD_ConsoleTop _GLCD_ConsoleTop c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
_GLCD_ConsoleHeight::
	.byte 4
	.dbsym e GLCD_ConsoleHeight _GLCD_ConsoleHeight c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
_GLCD_ConsoleLeft::
	.byte 2
	.dbsym e GLCD_ConsoleLeft _GLCD_ConsoleLeft c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
_GLCD_ConsoleWidth::
	.byte 25
	.dbsym e GLCD_ConsoleWidth _GLCD_ConsoleWidth c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
_GLCD_ConsoleNewlinePending::
	.byte 0
	.dbsym e GLCD_ConsoleNewlinePending _GLCD_ConsoleNewlinePending c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
_GLCD_DrawCharXor::
	.byte 0
	.dbsym e GLCD_DrawCharXor _GLCD_DrawCharXor c
	.area data(ram, con, rel)
	.dbfile ./glcd.c
	.area text(rom, con, rel)
	.dbfile ./glcd.c
	.dbfunc e GLCD_Init _GLCD_Init fV
_GLCD_Init::
	.dbline -1
	.dbline 60
; #include <stdlib.h>
; 
; #include "GLCD.h"
; #include "fnt58.h"
; #include "fnt46.h"
; 
; #define DELAY asm("nop \n nop \n nop");
; 
; // Getting maximum performance out of graphics module requires 
; // some careful hackery.
; //
; // C versions of all the calls are also available, but they 
; // can be 2-4 times slower!
; //
; // Line functions use basic drawing algorithms and internal
; // precision of 200th of a pixel in fixed-point format. With a 
; // screen width of 128, this ensures that the maximum pixel
; // error is less than 1 for a line of any slope.
; //
; // these functions are for internal use (and hence not included in
; // header file).
; void GLCD_WriteData(BYTE v, BYTE chipsel);
; void GLCD_WriteDataBulk(BYTE v, BYTE chipsel);
; void GLCD_WriteInstruction(BYTE v, BYTE chipsel);
; void GLCD_SetupBulkWrite(void);
; 
; BYTE GLCD_ReadData(BYTE chipsel);
; BYTE GLCD_ReadDataBulk(BYTE chipsel);
; BYTE GLCD_ReadStatus(BYTE chipsel);
; void GLCD_SetupBulkRead(void);
; 
; void GLCD_WaitUntilNotBusy(BYTE chipsel);
; 
; // internal but higher-level commands
; void GLCD_DisplayOnOff(BYTE on, BYTE chipsel);
; void GLCD_SetYAddress(BYTE v, BYTE chipsel);
; void GLCD_SetXAddress(BYTE v, BYTE chipsel);
; void GLCD_SetStartZAddress(BYTE v, BYTE chipsel);
; 
; 
; BYTE GLCD_ConsoleX=0;
; BYTE GLCD_ConsoleY=0;
; BYTE GLCD_ConsoleTop=4;
; BYTE GLCD_ConsoleHeight=4;
; BYTE GLCD_ConsoleLeft=2;
; BYTE GLCD_ConsoleWidth=25;
; 
; BYTE GLCD_ConsoleNewlinePending=0;
; 
; BYTE GLCD_DrawCharXor=0;
; 
; #pragma fastcall GLCD_WriteInstruction
; #pragma fastcall GLCD_WriteData
; #pragma fastcall GLCD_ReadData
; #pragma fastcall GLCD_ReadStatus
; #pragma fastcall GLCD_WaitUntilNotBusy
; 
; 
; void GLCD_Init()
; {
	.dbline 61
; 	DATABUS_READ;
	or F,0x10  ; iopage = 1
	mov REG[0x8],0
	.dbline 61
	mov REG[0x9],-1
	and F,0xEF ; iopage = 0
	.dbline 62
; 	CONTROLS = CS1 | CS2| RST;
	mov REG[0x4],28
	.dbline 64
; 	
; 	GLCD_WaitUntilNotBusy(CHIPSEL1);
	push X
	mov A,8
	xcall _GLCD_WaitUntilNotBusy
	.dbline 65
; 	GLCD_WaitUntilNotBusy(CHIPSEL2);
	mov A,4
	xcall _GLCD_WaitUntilNotBusy
	pop X
	.dbline 67
; 	
; 	GLCD_DisplayOnOff(1, CHIPSEL1);
	mov A,8
	push A
	mov A,1
	push A
	xcall _GLCD_DisplayOnOff
	.dbline 68
; 	GLCD_DisplayOnOff(1, CHIPSEL2);
	mov A,4
	push A
	mov A,1
	push A
	xcall _GLCD_DisplayOnOff
	add SP,-4
	.dbline 69
; 	GLCD_Clear();
	xcall _GLCD_Clear
	.dbline -2
	.dbline 70
; }
L1:
	.dbline 0 ; func end
	ret
	.dbend
	.dbfunc e GLCD_DisplayOnOff _GLCD_DisplayOnOff fV
;        chipsel -> X-5
;             on -> X-4
_GLCD_DisplayOnOff::
	.dbline -1
	push X
	mov X,SP
	.dbline 146
; 
; /*
; Reference C implementations:
; (see optimized assembly versions)
; 
; void GLCD_WaitUntilNotBusy(BYTE chipsel)
; {
; 	while (GLCD_ReadStatus(chipsel)&0x80);
; }
; 
; void GLCD_WriteInstruction(BYTE v, BYTE chipsel)
; {
; 	DATABUS_WRITE;
; 	DATABUS=v;
; 	
; 	CONTROLS = chipsel | RST;
; 	DELAY;
; 
; 	CONTROLS = chipsel | ENABLE | RST;
; 	DELAY;
; 	CONTROLS = chipsel | RST;
; 	
; 	DATABUS_READ;
; }
; 
; 
; void GLCD_WriteData(BYTE v, BYTE chipsel)
; {
; 	DATABUS_WRITE;
; 	DATABUS=v;
; 
; 	CONTROLS = chipsel | DI | RST;
; 	DELAY;
; 	CONTROLS = chipsel | DI | ENABLE | RST;
; 	DELAY;
; 	CONTROLS = chipsel | DI | RST;
; 	
; 	DATABUS_READ;
; 	
; }
; 
; BYTE GLCD_ReadData(BYTE chipsel)
; {
; 	BYTE v;
; 	
; 	DATABUS_READ;
; 	
; 	CONTROLS = chipsel | DI | RW | RST;
; 	DELAY;
; 	CONTROLS = chipsel | DI | RW | ENABLE | RST;
; 	DELAY;
; 	v=DATABUS;
; 	CONTROLS = chipsel | DI | RW | RST;
; 	
; 	return v;	
; }
; 
; BYTE GLCD_ReadStatus(BYTE chipsel)
; {
; 	BYTE v;
; 	
; 	DATABUS_READ;
; 	
; 	CONTROLS = chipsel | RW | RST;
; 	DELAY;
; 	CONTROLS = chipsel | RW | ENABLE | RST;
; 	DELAY;
; 	v=DATABUS;
; 	CONTROLS = chipsel | RW | RST;
; 	
; 	return v;	
; }
;  */
;  
; void GLCD_DisplayOnOff(BYTE on, BYTE chipsel)
; {
	.dbline 147
; 	GLCD_WriteInstruction(0x3e | on, chipsel);
	push X
	mov A,[X-5]
	push A
	mov REG[0xd0],>__r0
	mov A,[X-4]
	or A,62
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline -2
	.dbline 148
; }
L2:
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l chipsel -5 c
	.dbsym l on -4 c
	.dbend
	.dbfunc e GLCD_Clear _GLCD_Clear fV
_GLCD_Clear::
	.dbline -1
	.dbline 170
; 
; #define GLCD_SetYAddress(v, chipsel) 		GLCD_WriteInstruction(0x40 | (v), (chipsel));
; #define GLCD_SetXAddress(v, chipsel)        GLCD_WriteInstruction(0xb8 | (v), (chipsel));
; #define GLCD_SetStartZAddress(v, chipsel)   GLCD_WriteInstruction(0xc0 | (v), (chipsel));
; 
; /*
; void GLCD_SetYAddress(BYTE v, BYTE chipsel)
; {
; 	GLCD_WriteInstruction(0x40 | v, chipsel);	
; }
; 
; void GLCD_SetXAddress(BYTE v, BYTE chipsel)
; {
; 	GLCD_WriteInstruction(0xb8 | v, chipsel);	
; }
; void GLCD_SetStartZAddress(BYTE v, BYTE chipsel)
; {
; 	GLCD_WriteInstruction(0xc0 | v, chipsel);	
; }
; */
; void GLCD_Clear()
; {
	.dbline 171
; 	GLCD_Fill(0,0);
	mov A,0
	push A
	push A
	xcall _GLCD_Fill
	add SP,-2
	.dbline 172
; 	GLCD_ConsoleNewlinePending=0;
	mov REG[0xd0],>_GLCD_ConsoleNewlinePending
	mov [_GLCD_ConsoleNewlinePending],0
	.dbline -2
	.dbline 173
; }
L3:
	.dbline 0 ; func end
	ret
	.dbend
	.dbfunc e GLCD_Fill _GLCD_Fill fV
;           xadr -> X+2
;           yadr -> X+0
;  backgroundodd -> X-5
; backgroundeven -> X-4
_GLCD_Fill::
	.dbline -1
	push X
	mov X,SP
	add SP,4
	.dbline 176
; 	
; void GLCD_Fill(BYTE backgroundeven, BYTE backgroundodd)
; {
	.dbline 180
; 	int xadr;
; 	int yadr;
; 	
; 	for (xadr=0;xadr<8;xadr++)
	mov [X+3],0
	mov [X+2],0
L5:
	.dbline 181
; 	{
	.dbline 182
; 		GLCD_SetXAddress(xadr, CHIPSEL1);
	push X
	mov A,8
	push A
	mov REG[0xd0],>__r0
	mov A,[X+3]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 182
	.dbline 183
; 		GLCD_SetXAddress(xadr, CHIPSEL2);
	push X
	mov A,4
	push A
	mov REG[0xd0],>__r0
	mov A,[X+3]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	.dbline 183
	.dbline 184
; 		GLCD_SetYAddress(0, CHIPSEL1);
	mov X,8
	mov A,64
	xcall _GLCD_WriteInstruction
	.dbline 184
	.dbline 185
; 		GLCD_SetYAddress(0, CHIPSEL2);
	mov X,4
	mov A,64
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 185
	.dbline 187
; 		
; 		for (yadr=0;yadr<64;yadr+=2)
	mov [X+1],0
	mov [X+0],0
L9:
	.dbline 188
	.dbline 189
	push X
	mov A,8
	push A
	mov A,[X-4]
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline 190
	push X
	mov A,8
	push A
	mov A,[X-5]
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline 191
L10:
	.dbline 187
	add [X+1],2
	adc [X+0],0
	.dbline 187
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,64
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L9
X0:
	.dbline 193
; 		{
; 			GLCD_WriteData(backgroundeven, CHIPSEL1);			
; 			GLCD_WriteData(backgroundodd, CHIPSEL1);			
; 		}
; 		
; 		for (yadr=64;yadr<128;yadr+=2)
	mov [X+1],64
	mov [X+0],0
L13:
	.dbline 194
	.dbline 195
	push X
	mov A,4
	push A
	mov A,[X-4]
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline 196
	push X
	mov A,4
	push A
	mov A,[X-5]
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline 197
L14:
	.dbline 193
	add [X+1],2
	adc [X+0],0
	.dbline 193
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,-128
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L13
X1:
	.dbline 198
L6:
	.dbline 180
	inc [X+3]
	adc [X+2],0
	.dbline 180
	mov A,[X+2]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+3]
	sub A,8
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L5
X2:
	.dbline 199
; 		{
; 			GLCD_WriteData(backgroundeven, CHIPSEL2);			
; 			GLCD_WriteData(backgroundodd, CHIPSEL2);			
; 		}
; 	}
; 	GLCD_ConsoleNewlinePending=0;
	mov REG[0xd0],>_GLCD_ConsoleNewlinePending
	mov [_GLCD_ConsoleNewlinePending],0
	.dbline -2
	.dbline 200
; }
L4:
	add SP,-4
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l xadr 2 I
	.dbsym l yadr 0 I
	.dbsym l backgroundodd -5 c
	.dbsym l backgroundeven -4 c
	.dbend
	.dbfunc e GLCD_DrawImage _GLCD_DrawImage fV
;           xadr -> X+4
;            idx -> X+2
;           yadr -> X+0
;              i -> X-5
_GLCD_DrawImage::
	.dbline -1
	push X
	mov X,SP
	add SP,6
	.dbline 203
; 
; void GLCD_DrawImage(const BYTE *i)
; {
	.dbline 208
; 	int xadr;
; 	int yadr;
; 	int idx;
; 
; 	idx=0;
	mov [X+3],0
	mov [X+2],0
	.dbline 210
; 	
; 	for (xadr=0;xadr<8;xadr++)
	mov [X+5],0
	mov [X+4],0
L18:
	.dbline 211
; 	{
	.dbline 212
; 		GLCD_SetXAddress(xadr, CHIPSEL1);
	push X
	mov A,8
	push A
	mov REG[0xd0],>__r0
	mov A,[X+5]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 212
	.dbline 213
; 		GLCD_SetXAddress(xadr, CHIPSEL2);
	push X
	mov A,4
	push A
	mov REG[0xd0],>__r0
	mov A,[X+5]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	.dbline 213
	.dbline 214
; 		GLCD_SetYAddress(0, CHIPSEL1);
	mov X,8
	mov A,64
	xcall _GLCD_WriteInstruction
	.dbline 214
	.dbline 215
; 		GLCD_SetYAddress(0, CHIPSEL2);
	mov X,4
	mov A,64
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 215
	.dbline 217
; 
; 		for (yadr=0;yadr<64;yadr++)
	mov [X+1],0
	mov [X+0],0
L22:
	.dbline 218
	.dbline 219
	push X
	mov A,8
	push A
	mov REG[0xd0],>__r0
	mov A,[X+3]
	mov [__r1],A
	mov A,[X+2]
	mov [__r0],A
	mov A,[__r1]
	add A,1
	mov [X+3],A
	mov A,[__r0]
	adc A,0
	mov [X+2],A
	mov A,[X-4]
	add [__r1],A
	mov A,[X-5]
	adc [__r0],A
	mov A,[__r0]
	push X
	mov X,[__r1]
	romx
	pop X
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline 220
L23:
	.dbline 217
	inc [X+1]
	adc [X+0],0
	.dbline 217
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,64
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L22
X3:
	.dbline 222
; 		{
; 			GLCD_WriteData(i[idx++], CHIPSEL1);			
; 		}
; 		
; 		for (yadr=64;yadr<128;yadr++)
	mov [X+1],64
	mov [X+0],0
L26:
	.dbline 223
	.dbline 224
	push X
	mov A,4
	push A
	mov REG[0xd0],>__r0
	mov A,[X+3]
	mov [__r1],A
	mov A,[X+2]
	mov [__r0],A
	mov A,[__r1]
	add A,1
	mov [X+3],A
	mov A,[__r0]
	adc A,0
	mov [X+2],A
	mov A,[X-4]
	add [__r1],A
	mov A,[X-5]
	adc [__r0],A
	mov A,[__r0]
	push X
	mov X,[__r1]
	romx
	pop X
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline 225
L27:
	.dbline 222
	inc [X+1]
	adc [X+0],0
	.dbline 222
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,-128
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L26
X4:
	.dbline 227
L19:
	.dbline 210
	inc [X+5]
	adc [X+4],0
	.dbline 210
	mov A,[X+4]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+5]
	sub A,8
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L18
X5:
	.dbline 229
; 		{
; 			GLCD_WriteData(i[idx++], CHIPSEL2);			
; 		}
; 
; 	}
; 	
; 	GLCD_ConsoleNewlinePending=0;
	mov REG[0xd0],>_GLCD_ConsoleNewlinePending
	mov [_GLCD_ConsoleNewlinePending],0
	.dbline -2
	.dbline 230
; }
L17:
	add SP,-6
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l xadr 4 I
	.dbsym l idx 2 I
	.dbsym l yadr 0 I
	.dbsym l i -5 pc
	.dbend
	.dbfunc e GLCD_Plot _GLCD_Plot fV
;            adr -> X+3
;              b -> X+2
;              d -> X+1
;        chipsel -> X+0
;           mode -> X-6
;              y -> X-5
;              x -> X-4
_GLCD_Plot::
	.dbline -1
	push X
	mov X,SP
	add SP,4
	.dbline 233
; 
; void GLCD_Plot(BYTE x, BYTE y, BYTE mode)
; {
	.dbline 239
; 	BYTE chipsel;
; 	BYTE b;
; 	BYTE d;
; 	BYTE adr;
; 
; 	y=y&0x3f;
	and [X-5],63
	.dbline 240
; 	x=x&0x7f;
	and [X-4],127
	.dbline 243
; 		
; 	// which pixel to modify?
; 	d=y&7;
	mov A,[X-5]
	and A,7
	mov [X+1],A
	.dbline 244
; 	if (d<4) // 0123
	cmp [X+1],4
	jnc L31
X6:
	.dbline 245
; 		{
	.dbline 246
; 		if (d<2)  // 01
	cmp [X+1],2
	jnc L33
X7:
	.dbline 247
; 			{
	.dbline 248
; 				if (d==0)
	cmp [X+1],0
	jnz L35
	.dbline 249
; 					d=1;
	mov [X+1],1
	xjmp L32
L35:
	.dbline 251
; 				else
; 					d=2;
	mov [X+1],2
	.dbline 252
; 			}
	xjmp L32
L33:
	.dbline 254
; 		else	// 23
; 			{
	.dbline 255
; 				if (d==2)
	cmp [X+1],2
	jnz L37
	.dbline 256
; 					d=4;
	mov [X+1],4
	xjmp L32
L37:
	.dbline 258
; 				else
; 					d=8; 
	mov [X+1],8
	.dbline 259
; 			}
	.dbline 260
; 		}
	xjmp L32
L31:
	.dbline 262
; 	else // 4567
; 		{
	.dbline 263
; 		if (d<6)  // 45
	cmp [X+1],6
	jnc L39
X8:
	.dbline 264
; 			{
	.dbline 265
; 				if (d==4)
	cmp [X+1],4
	jnz L41
	.dbline 266
; 					d=16;
	mov [X+1],16
	xjmp L40
L41:
	.dbline 268
; 				else
; 					d=32;
	mov [X+1],32
	.dbline 269
; 			}
	xjmp L40
L39:
	.dbline 271
; 		else	// 67
; 			{
	.dbline 272
; 				if (d==6)
	cmp [X+1],6
	jnz L43
	.dbline 273
; 					d=64;
	mov [X+1],64
	xjmp L44
L43:
	.dbline 275
; 				else
; 					d=128; 
	mov [X+1],-128
L44:
	.dbline 276
; 			}
L40:
	.dbline 278
; 		
; 		}
L32:
	.dbline 280
; 	
; 	if (x>=64)
	cmp [X-4],64
	jz X9
	jc L45
X9:
	.dbline 281
; 		{
	.dbline 282
; 		adr=x-64;
	mov REG[0xd0],>__r0
	mov A,[X-4]
	sub A,64
	mov [X+3],A
	.dbline 283
; 		chipsel=CHIPSEL2;
	mov [X+0],4
	.dbline 284
; 		}
	xjmp L46
L45:
	.dbline 286
; 	else
; 		{
	.dbline 287
; 		adr=x;
	mov A,[X-4]
	mov [X+3],A
	.dbline 288
; 		chipsel=CHIPSEL1;
	mov [X+0],8
	.dbline 289
; 		}
L46:
	.dbline 291
; 			
; 	GLCD_SetYAddress(adr, chipsel);
	push X
	mov A,[X+0]
	push A
	mov REG[0xd0],>__r0
	mov A,[X+3]
	or A,64
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 291
	.dbline 292
; 	GLCD_SetXAddress(y/8, chipsel);
	push X
	mov A,[X+0]
	push A
	mov REG[0xd0],>__r0
	mov A,8
	push A
	mov A,[X-5]
	push A
	xcall __divmodu_8X8_8
	pop A
	mov [__r0],A
	add SP,-1
	or [__r0],-72
	mov A,[__r0]
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 292
	.dbline 293
; 	GLCD_ReadData(chipsel); // dummy read.
	push X
	mov A,[X+0]
	xcall _GLCD_ReadData
	mov REG[0xd0],>__r0
	pop X
	.dbline 294
; 	b=GLCD_ReadData(chipsel); // read the background
	push X
	mov A,[X+0]
	xcall _GLCD_ReadData
	mov REG[0xd0],>__r0
	pop X
	mov [X+2],A
	.dbline 296
;  
; 	if (mode==MODE_PLOT)
	cmp [X-6],1
	jnz L47
	.dbline 297
; 		b=b|d;
	mov A,[X+2]
	or A,[X+1]
	mov [X+2],A
	xjmp L48
L47:
	.dbline 298
; 	else if (mode==MODE_XOR)
	cmp [X-6],2
	jnz L49
	.dbline 299
; 		b=b^d;
	mov REG[0xd0],>__r0
	mov A,[X+2]
	xor A,[X+1]
	mov [X+2],A
	xjmp L50
L49:
	.dbline 300
; 	else if (mode==MODE_ERASE)
	cmp [X-6],0
	jnz L51
	.dbline 301
; 		b=b&(~d);
	mov REG[0xd0],>__r0
	mov A,[X+1]
	cpl A
	and [X+2],A
L51:
L50:
L48:
	.dbline 303
; 	
; 	GLCD_SetYAddress(adr, chipsel);
	push X
	mov A,[X+0]
	push A
	mov REG[0xd0],>__r0
	mov A,[X+3]
	or A,64
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 303
	.dbline 304
; 	GLCD_WriteData(b, chipsel);
	push X
	mov A,[X+0]
	push A
	mov A,[X+2]
	pop X
	xcall _GLCD_WriteData
	pop X
	.dbline -2
	.dbline 305
; }
L30:
	add SP,-4
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l adr 3 c
	.dbsym l b 2 c
	.dbsym l d 1 c
	.dbsym l chipsel 0 c
	.dbsym l mode -6 c
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
	.dbfunc e GLCD_DrawChar _GLCD_DrawChar fc
;         offset -> X+2
;    currentchip -> X+1
;            cnt -> X+0
;           font -> X-8
;              c -> X-6
;              y -> X-5
;              x -> X-4
_GLCD_DrawChar::
	.dbline -1
	push X
	mov X,SP
	add SP,4
	.dbline 308
; 
; BYTE GLCD_DrawChar(BYTE x, BYTE y, BYTE c, const BYTE *font)
; {
	.dbline 309
; 	int offset=4+(c&0x7f)*font[3];
	mov REG[0xd0],>__r0
	mov A,[X-6]
	mov [__r1],A
	mov [__r0],0
	and [__r1],127
	and [__r0],0
	mov A,[X-7]
	add A,3
	mov [__r3],A
	mov A,[X-8]
	adc A,0
	push X
	mov X,[__r3]
	romx
	pop X
	mov [__r3],A
	mov A,0
	push A
	mov A,[__r3]
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	xcall __mul16
	add SP,-4
	mov A,[__rX]
	mov [__r1],A
	mov A,[__rY]
	mov [__r0],A
	mov A,[__r1]
	add A,4
	mov [X+3],A
	mov A,[__r0]
	adc A,0
	mov [X+2],A
	.dbline 310
; 	BYTE cnt=0;
	mov [X+0],0
	.dbline 314
; 	BYTE currentchip;
; 
; 	// Convert given coordinates into LCD's coordinates:
; 	cnt=y;
	mov A,[X-5]
	mov [X+0],A
	.dbline 315
; 	y=x;
	mov A,[X-4]
	mov [X-5],A
	.dbline 316
; 	x=cnt/8;
	mov A,8
	push A
	mov A,[X+0]
	push A
	xcall __divmodu_8X8_8
	pop A
	mov [X-4],A
	add SP,-1
	.dbline 317
; 	cnt=0;
	mov [X+0],0
	.dbline 319
; 	
; 	if (y<0)
	cmp [X-5],0
	jnc L54
X10:
	.dbline 320
; 		{
	.dbline 321
; 		GLCD_SetYAddress(0, CHIPSEL1);
	push X
	mov X,8
	mov A,64
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 321
	.dbline 322
; 		currentchip=CHIPSEL1;
	mov [X+1],8
	.dbline 323
; 		}
	xjmp L55
L54:
	.dbline 324
; 	else if (y<64)
	cmp [X-5],64
	jnc L56
X11:
	.dbline 325
; 		{
	.dbline 326
; 		GLCD_SetYAddress(y, CHIPSEL1);
	push X
	mov A,8
	push A
	mov REG[0xd0],>__r0
	mov A,[X-5]
	or A,64
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 326
	.dbline 327
; 		currentchip=CHIPSEL1;
	mov [X+1],8
	.dbline 328
; 		}
	xjmp L57
L56:
	.dbline 330
; 	else
; 		{
	.dbline 331
; 		GLCD_SetYAddress(y-64, CHIPSEL2);
	push X
	mov A,4
	push A
	mov REG[0xd0],>__r0
	mov A,[X-5]
	sub A,64
	mov [__r0],A
	or [__r0],64
	mov A,[__r0]
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 331
	.dbline 332
; 		currentchip=CHIPSEL2;
	mov [X+1],4
	.dbline 333
; 		}
L57:
L55:
	.dbline 335
; 	
; 	GLCD_SetXAddress(x, currentchip);
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X-4]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 335
	.dbline 337
; 	
; 	for (cnt=0; cnt< font[1];cnt++)
	mov [X+0],0
	xjmp L61
L58:
	.dbline 338
; 	{
	.dbline 339
; 		if (y>=0 && y<128)
	cmp [X-5],0
	jz X12
	jc L62
X12:
	cmp [X-5],-128
	jnc L62
X13:
	.dbline 340
; 			GLCD_WriteData(font[offset+cnt]^GLCD_DrawCharXor, currentchip);
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	mov A,[X+3]
	add A,[__r1]
	mov [__r1],A
	mov A,[X+2]
	adc A,[__r0]
	mov [__r0],A
	mov A,[X-7]
	add [__r1],A
	mov A,[X-8]
	adc [__r0],A
	mov A,[__r0]
	push X
	mov X,[__r1]
	romx
	pop X
	mov [__r0],A
	mov REG[0xd0],>_GLCD_DrawCharXor
	mov A,[_GLCD_DrawCharXor]
	mov REG[0xd0],>__r0
	xor [__r0],A
	mov A,[__r0]
	pop X
	xcall _GLCD_WriteData
	pop X
L62:
	.dbline 342
; 
; 		y++;
	inc [X-5]
	.dbline 343
; 		if (y==64)
	cmp [X-5],64
	jnz L64
	.dbline 344
; 			{
	.dbline 345
; 			GLCD_SetYAddress(0, CHIPSEL2);
	push X
	mov X,4
	mov A,64
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 345
	.dbline 346
; 			currentchip=CHIPSEL2;
	mov [X+1],4
	.dbline 347
; 			GLCD_SetXAddress(x, currentchip);
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X-4]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 347
	.dbline 348
; 			}
L64:
	.dbline 349
L59:
	.dbline 337
	inc [X+0]
L61:
	.dbline 337
	mov REG[0xd0],>__r0
	mov A,[X-7]
	add A,1
	mov [__r1],A
	mov A,[X-8]
	adc A,0
	push X
	mov X,[__r1]
	romx
	pop X
	mov [__r0],A
	mov A,[X+0]
	cmp A,[__r0]
	jz X14
	jc L58
X14:
	.dbline 350
; 	}
; 	return font[1];
	mov REG[0xd0],>__r0
	mov A,[X-7]
	add A,1
	mov [__r1],A
	mov A,[X-8]
	adc A,0
	push X
	mov X,[__r1]
	romx
	pop X
	.dbline -2
L53:
	add SP,-4
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l offset 2 I
	.dbsym l currentchip 1 c
	.dbsym l cnt 0 c
	.dbsym l font -8 pc
	.dbsym l c -6 c
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
	.dbfunc e GLCD_DrawString _GLCD_DrawString fc
;         offset -> X+2
;            idx -> X+0
;           font -> X-9
;              c -> X-7
;              y -> X-5
;              x -> X-4
_GLCD_DrawString::
	.dbline -1
	push X
	mov X,SP
	add SP,3
	.dbline 354
; }
; 
; BYTE GLCD_DrawString(BYTE x, BYTE y, char *c, const BYTE *font)
; {
	.dbline 355
; 	int idx=0;
	mov [X+1],0
	mov [X+0],0
	.dbline 356
; 	BYTE offset=0;
	mov [X+2],0
	xjmp L68
L67:
	.dbline 359
	.dbline 360
	mov A,[X-9]
	push A
	mov A,[X-8]
	push A
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,[X-6]
	mov [__r1],A
	mov A,[X+0]
	adc A,[X-7]
	mov REG[0xd4],A
	mvi A,[__r1]
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	add A,[X+2]
	push A
	xcall _GLCD_DrawChar
	add SP,-5
	mov REG[0xd0],>__r0
	add [X+2],A
	.dbline 361
	inc [X+1]
	adc [X+0],0
	.dbline 362
L68:
	.dbline 358
; 	
; 	while (c[idx]!=0)
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,[X-6]
	mov [__r1],A
	mov A,[X+0]
	adc A,[X-7]
	mov REG[0xd4],A
	mvi A,[__r1]
	cmp A,0
	jnz L67
	.dbline 364
; 	{
; 		offset+=GLCD_DrawChar(x+offset, y, c[idx], font);
; 		idx++;
; 	}
; 	
; 	return offset;
	mov A,[X+2]
	.dbline -2
L66:
	add SP,-3
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l offset 2 c
	.dbsym l idx 0 I
	.dbsym l font -9 pc
	.dbsym l c -7 pc
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
	.dbfunc e GLCD_DrawStringC _GLCD_DrawStringC fc
;         offset -> X+2
;            idx -> X+0
;           font -> X-9
;              c -> X-7
;              y -> X-5
;              x -> X-4
_GLCD_DrawStringC::
	.dbline -1
	push X
	mov X,SP
	add SP,3
	.dbline 368
; }
; 
; BYTE GLCD_DrawStringC(BYTE x, BYTE y, const char *c, const BYTE *font)
; {
	.dbline 369
; 	int idx=0;
	mov [X+1],0
	mov [X+0],0
	.dbline 370
; 	BYTE offset=0;
	mov [X+2],0
	xjmp L72
L71:
	.dbline 373
	.dbline 374
	mov A,[X-9]
	push A
	mov A,[X-8]
	push A
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,[X-6]
	mov [__r1],A
	mov A,[X+0]
	adc A,[X-7]
	push X
	mov X,[__r1]
	romx
	pop X
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	add A,[X+2]
	push A
	xcall _GLCD_DrawChar
	add SP,-5
	mov REG[0xd0],>__r0
	add [X+2],A
	.dbline 375
	inc [X+1]
	adc [X+0],0
	.dbline 376
L72:
	.dbline 372
; 	
; 	while (c[idx]!=0)
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,[X-6]
	mov [__r1],A
	mov A,[X+0]
	adc A,[X-7]
	push X
	mov X,[__r1]
	romx
	pop X
	cmp A,0
	jnz L71
	.dbline 378
; 	{
; 		offset+=GLCD_DrawChar(x+offset, y, c[idx], font);
; 		idx++;
; 	}
; 	
; 	return offset;
	mov A,[X+2]
	.dbline -2
L70:
	add SP,-3
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l offset 2 c
	.dbsym l idx 0 I
	.dbsym l font -9 pc
	.dbsym l c -7 pc
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
	.dbfunc e GLCD_ConsoleWriteString _GLCD_ConsoleWriteString fV
;            idx -> X+0
;              c -> X-5
_GLCD_ConsoleWriteString::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 382
; }
; 
; void GLCD_ConsoleWriteString(char *c)
; {
	.dbline 383
; 	int idx=0;
	mov [X+1],0
	mov [X+0],0
	xjmp L76
L75:
	.dbline 386
	.dbline 387
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,[X-4]
	mov [__r1],A
	mov A,[X+0]
	adc A,[X-5]
	mov REG[0xd4],A
	mvi A,[__r1]
	push A
	xcall _GLCD_ConsoleWriteChar
	add SP,-1
	.dbline 388
	inc [X+1]
	adc [X+0],0
	.dbline 389
L76:
	.dbline 385
; 	
; 	while (c[idx]!=0)
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,[X-4]
	mov [__r1],A
	mov A,[X+0]
	adc A,[X-5]
	mov REG[0xd4],A
	mvi A,[__r1]
	cmp A,0
	jnz L75
	.dbline -2
	.dbline 390
; 	{
; 		GLCD_ConsoleWriteChar(c[idx]);
; 		idx++;
; 	}
; }
L74:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l idx 0 I
	.dbsym l c -5 pc
	.dbend
	.dbfunc e GLCD_ConsoleWriteStringC _GLCD_ConsoleWriteStringC fV
;            idx -> X+0
;              c -> X-5
_GLCD_ConsoleWriteStringC::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 393
; 
; void GLCD_ConsoleWriteStringC(const char *c)
; {
	.dbline 394
; 	int idx=0;
	mov [X+1],0
	mov [X+0],0
	xjmp L80
L79:
	.dbline 397
	.dbline 398
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,[X-4]
	mov [__r1],A
	mov A,[X+0]
	adc A,[X-5]
	push X
	mov X,[__r1]
	romx
	pop X
	push A
	xcall _GLCD_ConsoleWriteChar
	add SP,-1
	.dbline 399
	inc [X+1]
	adc [X+0],0
	.dbline 400
L80:
	.dbline 396
; 	
; 	while (c[idx]!=0)
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,[X-4]
	mov [__r1],A
	mov A,[X+0]
	adc A,[X-5]
	push X
	mov X,[__r1]
	romx
	pop X
	cmp A,0
	jnz L79
	.dbline -2
	.dbline 401
; 	{
; 		GLCD_ConsoleWriteChar(c[idx]);
; 		idx++;
; 	}
; }
L78:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l idx 0 I
	.dbsym l c -5 pc
	.dbend
	.dbfunc e GLCD_ConsoleWriteChar _GLCD_ConsoleWriteChar fV
;              c -> X-4
_GLCD_ConsoleWriteChar::
	.dbline -1
	push X
	mov X,SP
	.dbline 408
; 
; // we delay the printing/scrolling of newlines so we can get
; // a maximum amount of display area out of the LCD. (If we
; // didn't, then we "lose" a line due to always scrolling up
; // after the bottom line.)
; void GLCD_ConsoleWriteChar(char c)
; {
	.dbline 409
; 	if (GLCD_ConsoleNewlinePending)
	mov REG[0xd0],>_GLCD_ConsoleNewlinePending
	cmp [_GLCD_ConsoleNewlinePending],0
	jz L83
	.dbline 410
; 		{
	.dbline 411
; 		GLCD_ConsoleNewlinePending=0;
	mov [_GLCD_ConsoleNewlinePending],0
	.dbline 413
; 		
; 		GLCD_ConsoleX=0;
	mov REG[0xd0],>_GLCD_ConsoleX
	mov [_GLCD_ConsoleX],0
	.dbline 414
; 		GLCD_ConsoleY++;
	mov REG[0xd0],>_GLCD_ConsoleY
	inc [_GLCD_ConsoleY]
	.dbline 415
; 		if (GLCD_ConsoleY>=GLCD_ConsoleHeight)
	mov A,[_GLCD_ConsoleY]
	mov REG[0xd0],>_GLCD_ConsoleHeight
	cmp A,[_GLCD_ConsoleHeight]
	jz X15
	jc L85
X15:
	.dbline 416
; 			{
	.dbline 417
; 			GLCD_ConsoleY=GLCD_ConsoleHeight-1;
	mov REG[0xd0],>_GLCD_ConsoleHeight
	mov A,[_GLCD_ConsoleHeight]
	sub A,1
	mov REG[0xd0],>_GLCD_ConsoleY
	mov [_GLCD_ConsoleY],A
	.dbline 418
; 			GLCD_ConsoleScroll();
	xcall _GLCD_ConsoleScroll
	.dbline 419
; 			GLCD_ConsoleEraseLine(GLCD_ConsoleY);
	mov REG[0xd0],>_GLCD_ConsoleY
	mov A,[_GLCD_ConsoleY]
	push A
	xcall _GLCD_ConsoleEraseLine
	add SP,-1
	.dbline 420
; 			}
L85:
	.dbline 421
; 		}
L83:
	.dbline 423
; 		
; 	if (c==13) // \r
	cmp [X-4],13
	jnz L87
	.dbline 424
; 		return;
	xjmp L82
L87:
	.dbline 426
; 		
; 	if (c==10) // \n
	cmp [X-4],10
	jnz L89
	.dbline 427
; 		{
	.dbline 428
; 		GLCD_ConsoleNewlinePending=1;
	mov REG[0xd0],>_GLCD_ConsoleNewlinePending
	mov [_GLCD_ConsoleNewlinePending],1
	.dbline 429
; 		return;
	xjmp L82
L89:
	.dbline 432
; 		}
; 		
; 	if (c==9) // tab
	cmp [X-4],9
	jnz L91
	.dbline 433
; 		{
	.dbline 434
; 		GLCD_ConsoleX+=3;
	mov REG[0xd0],>_GLCD_ConsoleX
	add [_GLCD_ConsoleX],3
	.dbline 435
; 		if (GLCD_ConsoleX>=GLCD_ConsoleWidth)
	mov A,[_GLCD_ConsoleX]
	mov REG[0xd0],>_GLCD_ConsoleWidth
	cmp A,[_GLCD_ConsoleWidth]
	jz X16
	jc L82
X16:
	.dbline 436
; 			{
	.dbline 437
; 			GLCD_ConsoleX=0;
	mov REG[0xd0],>_GLCD_ConsoleX
	mov [_GLCD_ConsoleX],0
	.dbline 438
; 			GLCD_ConsoleY++;
	mov REG[0xd0],>_GLCD_ConsoleY
	inc [_GLCD_ConsoleY]
	.dbline 439
; 			if (GLCD_ConsoleY>=GLCD_ConsoleHeight)
	mov A,[_GLCD_ConsoleY]
	mov REG[0xd0],>_GLCD_ConsoleHeight
	cmp A,[_GLCD_ConsoleHeight]
	jz X17
	jc L82
X17:
	.dbline 440
; 				{
	.dbline 441
; 				GLCD_ConsoleY=GLCD_ConsoleHeight-1;
	mov REG[0xd0],>_GLCD_ConsoleHeight
	mov A,[_GLCD_ConsoleHeight]
	sub A,1
	mov REG[0xd0],>_GLCD_ConsoleY
	mov [_GLCD_ConsoleY],A
	.dbline 442
; 				GLCD_ConsoleScroll();
	xcall _GLCD_ConsoleScroll
	.dbline 443
; 				GLCD_ConsoleEraseLine(GLCD_ConsoleY);
	mov REG[0xd0],>_GLCD_ConsoleY
	mov A,[_GLCD_ConsoleY]
	push A
	xcall _GLCD_ConsoleEraseLine
	add SP,-1
	.dbline 444
; 				}
	.dbline 445
; 			}
	.dbline 446
; 		return;
	xjmp L82
L91:
	.dbline 449
; 		}
; 	
; 	if (c==8) // backspace
	cmp [X-4],8
	jnz L97
	.dbline 450
; 		{
	.dbline 451
; 		if (GLCD_ConsoleX==0 && GLCD_ConsoleY==0)
	mov REG[0xd0],>_GLCD_ConsoleX
	cmp [_GLCD_ConsoleX],0
	jnz L99
	mov REG[0xd0],>_GLCD_ConsoleY
	cmp [_GLCD_ConsoleY],0
	jnz L99
	.dbline 452
; 			return;
	xjmp L82
L99:
	.dbline 454
; 		
; 		if (GLCD_ConsoleX>0)
	mov REG[0xd0],>_GLCD_ConsoleX
	cmp [_GLCD_ConsoleX],0
	jc L101
	jz L101
X18:
	.dbline 455
; 			{
	.dbline 456
; 			GLCD_ConsoleX--;
	mov REG[0xd0],>_GLCD_ConsoleX
	dec [_GLCD_ConsoleX]
	.dbline 457
; 			return;
	xjmp L82
L101:
	.dbline 460
; 			}
; 		
; 		GLCD_ConsoleY--;
	mov REG[0xd0],>_GLCD_ConsoleY
	dec [_GLCD_ConsoleY]
	.dbline 461
; 		GLCD_ConsoleX=GLCD_ConsoleWidth-1;
	mov REG[0xd0],>_GLCD_ConsoleWidth
	mov A,[_GLCD_ConsoleWidth]
	sub A,1
	mov REG[0xd0],>_GLCD_ConsoleX
	mov [_GLCD_ConsoleX],A
	.dbline 462
; 		return;		
	xjmp L82
L97:
	.dbline 465
; 		}
; 
; 	GLCD_DrawChar((GLCD_ConsoleX+GLCD_ConsoleLeft)*4, (GLCD_ConsoleY+GLCD_ConsoleTop)*8, c, fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,[X-4]
	push A
	mov REG[0xd0],>_GLCD_ConsoleY
	mov A,[_GLCD_ConsoleY]
	mov REG[0xd0],>_GLCD_ConsoleTop
	add A,[_GLCD_ConsoleTop]
	asl A
	asl A
	asl A
	push A
	mov REG[0xd0],>_GLCD_ConsoleX
	mov A,[_GLCD_ConsoleX]
	mov REG[0xd0],>_GLCD_ConsoleLeft
	add A,[_GLCD_ConsoleLeft]
	mov REG[0xd0],>__r0
	mov [__r0],A
	asl [__r0]
	asl [__r0]
	mov A,[__r0]
	push A
	xcall _GLCD_DrawChar
	add SP,-5
	.dbline 466
; 	GLCD_ConsoleX++;
	mov REG[0xd0],>_GLCD_ConsoleX
	inc [_GLCD_ConsoleX]
	.dbline 467
; 	if (GLCD_ConsoleX>=GLCD_ConsoleWidth)
	mov A,[_GLCD_ConsoleX]
	mov REG[0xd0],>_GLCD_ConsoleWidth
	cmp A,[_GLCD_ConsoleWidth]
	jz X19
	jc L103
X19:
	.dbline 468
; 		{
	.dbline 469
; 		GLCD_ConsoleX=0;
	mov REG[0xd0],>_GLCD_ConsoleX
	mov [_GLCD_ConsoleX],0
	.dbline 470
; 		GLCD_ConsoleY++;
	mov REG[0xd0],>_GLCD_ConsoleY
	inc [_GLCD_ConsoleY]
	.dbline 471
; 		if (GLCD_ConsoleY>=GLCD_ConsoleHeight)
	mov A,[_GLCD_ConsoleY]
	mov REG[0xd0],>_GLCD_ConsoleHeight
	cmp A,[_GLCD_ConsoleHeight]
	jz X20
	jc L105
X20:
	.dbline 472
; 			{
	.dbline 473
; 			GLCD_ConsoleY=GLCD_ConsoleHeight-1;
	mov REG[0xd0],>_GLCD_ConsoleHeight
	mov A,[_GLCD_ConsoleHeight]
	sub A,1
	mov REG[0xd0],>_GLCD_ConsoleY
	mov [_GLCD_ConsoleY],A
	.dbline 474
; 			GLCD_ConsoleScroll();
	xcall _GLCD_ConsoleScroll
	.dbline 475
; 			GLCD_ConsoleEraseLine(GLCD_ConsoleY);
	mov REG[0xd0],>_GLCD_ConsoleY
	mov A,[_GLCD_ConsoleY]
	push A
	xcall _GLCD_ConsoleEraseLine
	add SP,-1
	.dbline 476
; 			}
L105:
	.dbline 477
L103:
	.dbline -2
	.dbline 478
; 		}
; }
L82:
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l c -4 c
	.dbend
	.dbfunc e GLCD_DrawLine _GLCD_DrawLine fV
;              t -> X+4
;           step -> X+2
;        stepacc -> X+0
;              m -> X-8
;             y1 -> X-7
;             x1 -> X-6
;             y0 -> X-5
;             x0 -> X-4
_GLCD_DrawLine::
	.dbline -1
	push X
	mov X,SP
	add SP,7
	.dbline 482
; 
; void GLCD_DrawLine( char x0, char y0, 
; 					char x1, char y1, unsigned char m)
; {
	.dbline 487
; 	int step, stepacc;
; 	BYTE t;
; 		
; 	// ensure that (x0,y0) is always left of (x1,y1)
; 	if (x0>x1)
	mov A,[X-4]
	cmp A,[X-6]
	jc L108
	jz L108
X21:
	.dbline 488
; 		{
	.dbline 489
; 		t=x0;
	mov A,[X-4]
	mov [X+4],A
	.dbline 490
; 		x0=x1;
	mov A,[X-6]
	mov [X-4],A
	.dbline 491
; 		x1=t;
	mov A,[X+4]
	mov [X-6],A
	.dbline 492
; 		t=y0;
	mov A,[X-5]
	mov [X+4],A
	.dbline 493
; 		y0=y1;
	mov A,[X-7]
	mov [X-5],A
	.dbline 494
; 		y1=t;
	mov A,[X+4]
	mov [X-7],A
	.dbline 495
; 		}
L108:
	.dbline 498
; 		
; 	// are we moving faster in the X or Y direction?	
; 	if (abs(x1-x0)>abs(y1-y0))
	mov REG[0xd0],>__r0
	mov A,[X-6]
	mov [__r1],A
	mov [__r0],0
	mov A,[X-4]
	sub [__r1],A
	sbb [__r0],0
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	xcall _abs
	mov REG[0xd0],>__r0
	mov A,[__r1]
	mov [X+6],A
	mov A,[__r0]
	mov [X+5],A
	mov A,[X-7]
	mov [__r3],A
	mov [__r2],0
	mov A,[X-5]
	sub [__r3],A
	sbb [__r2],0
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	xcall _abs
	add SP,-4
	mov REG[0xd0],>__r0
	mov A,[X+5]
	xor A,-128
	mov [__rY],A
	mov A,[__r0]
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+6]
	sub A,[__r1]
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L110
	mov A,[__rX]
	jz L110
X22:
	.dbline 499
; 		{
	.dbline 502
; 		// we're moving in the X direction faster, so step in X
; 		// and compute y.
; 		stepacc=y0*128;
	mov REG[0xd0],>__r0
	mov A,[X-5]
	mov [__r1],A
	mov [__r0],0
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	mov A,[__r1]
	mov [X+1],A
	mov A,[__r0]
	mov [X+0],A
	.dbline 503
; 		step=(y1-y0)*128/(x1-x0);
	mov A,[X-7]
	mov [__r1],A
	mov [__r0],0
	mov A,[X-5]
	mov [__r2],0
	sub [__r1],A
	sbb [__r0],0
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	mov A,[X-6]
	mov [__r3],A
	mov A,[X-4]
	sub [__r3],A
	sbb [__r2],0
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	xcall __divmod_16X16_16
	pop A
	mov [X+3],A
	pop A
	mov [X+2],A
	add SP,-2
	xjmp L113
L112:
	.dbline 506
; 		
; 		while (x0!=x1)
; 			{
	.dbline 507
; 				GLCD_Plot(x0,stepacc/128, m);
	mov A,[X-8]
	push A
	mov REG[0xd0],>__r0
	mov A,0
	push A
	mov A,-128
	push A
	mov A,[X+0]
	push A
	mov A,[X+1]
	push A
	xcall __divmod_16X16_16
	pop A
	mov [__r1],A
	pop A
	add SP,-2
	mov A,[__r1]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_Plot
	add SP,-3
	.dbline 508
; 				stepacc+=step;
	mov A,[X+3]
	add [X+1],A
	mov A,[X+2]
	adc [X+0],A
	.dbline 509
; 				if (x0<x1)
	mov A,[X-4]
	cmp A,[X-6]
	jnc L115
X23:
	.dbline 510
; 					x0++;
	inc [X-4]
	xjmp L116
L115:
	.dbline 512
; 				else
; 					x0--;
	dec [X-4]
L116:
	.dbline 513
L113:
	.dbline 505
	mov A,[X-4]
	cmp A,[X-6]
	jnz L112
	.dbline 514
; 			}
; 		}
	xjmp L111
L110:
	.dbline 516
; 	else
; 		{
	.dbline 518
; 		// we're moving faster in the Y direction, so step in Y
; 		stepacc=x0*128;
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	mov A,[__r1]
	mov [X+1],A
	mov A,[__r0]
	mov [X+0],A
	.dbline 519
; 		step=(x1-x0)*128/(y1-y0);
	mov A,[X-6]
	mov [__r1],A
	mov [__r0],0
	mov A,[X-4]
	mov [__r2],0
	sub [__r1],A
	sbb [__r0],0
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	asl [__r1]
	rlc [__r0]
	mov A,[X-7]
	mov [__r3],A
	mov A,[X-5]
	sub [__r3],A
	sbb [__r2],0
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	xcall __divmod_16X16_16
	pop A
	mov [X+3],A
	pop A
	mov [X+2],A
	add SP,-2
	xjmp L118
L117:
	.dbline 522
; 		
; 		while (y0!=y1)
; 			{
	.dbline 523
; 				GLCD_Plot((stepacc+64)/128, y0, m);
	mov A,[X-8]
	push A
	mov A,[X-5]
	push A
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,64
	mov [__r1],A
	mov A,[X+0]
	adc A,0
	mov [__r0],A
	mov A,0
	push A
	mov A,-128
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	xcall __divmod_16X16_16
	pop A
	mov [__r1],A
	pop A
	add SP,-2
	mov A,[__r1]
	push A
	xcall _GLCD_Plot
	add SP,-3
	.dbline 524
; 				stepacc+=step;
	mov A,[X+3]
	add [X+1],A
	mov A,[X+2]
	adc [X+0],A
	.dbline 525
; 				if (y0<y1)
	mov A,[X-5]
	cmp A,[X-7]
	jnc L120
X24:
	.dbline 526
; 					y0++;
	inc [X-5]
	xjmp L121
L120:
	.dbline 528
; 				else
; 					y0--;
	dec [X-5]
L121:
	.dbline 529
L118:
	.dbline 521
	mov A,[X-5]
	cmp A,[X-7]
	jnz L117
	.dbline 530
L111:
	.dbline -2
	.dbline 531
; 			}
; 		}
; }
L107:
	add SP,-7
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l t 4 c
	.dbsym l step 2 I
	.dbsym l stepacc 0 I
	.dbsym l m -8 c
	.dbsym l y1 -7 c
	.dbsym l x1 -6 c
	.dbsym l y0 -5 c
	.dbsym l x0 -4 c
	.dbend
	.dbfunc e GLCD_ConsoleHome _GLCD_ConsoleHome fV
;           line -> X+0
_GLCD_ConsoleHome::
	.dbline -1
	push X
	mov X,SP
	add SP,1
	.dbline 534
; 
; void GLCD_ConsoleHome()
; {
	.dbline 537
; 	BYTE line;
; 	
; 	for (line=0;line<GLCD_ConsoleHeight;line++)
	mov [X+0],0
	xjmp L126
L123:
	.dbline 538
	.dbline 539
	mov A,[X+0]
	push A
	xcall _GLCD_ConsoleEraseLine
	add SP,-1
	.dbline 540
L124:
	.dbline 537
	inc [X+0]
L126:
	.dbline 537
	mov REG[0xd0],>_GLCD_ConsoleHeight
	mov A,[X+0]
	cmp A,[_GLCD_ConsoleHeight]
	jz X25
	jc L123
X25:
	.dbline 541
; 	{
; 		GLCD_ConsoleEraseLine(line);
; 	}
; 	GLCD_ConsoleX=0;
	mov REG[0xd0],>_GLCD_ConsoleX
	mov [_GLCD_ConsoleX],0
	.dbline 542
; 	GLCD_ConsoleY=0;
	mov REG[0xd0],>_GLCD_ConsoleY
	mov [_GLCD_ConsoleY],0
	.dbline 543
; 	GLCD_ConsoleNewlinePending=0;
	mov REG[0xd0],>_GLCD_ConsoleNewlinePending
	mov [_GLCD_ConsoleNewlinePending],0
	.dbline -2
	.dbline 544
; }
L122:
	add SP,-1
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l line 0 c
	.dbend
	.dbfunc e GLCD_ConsoleEraseLine _GLCD_ConsoleEraseLine fV
;             x1 -> X+2
;        chipsel -> X+1
;             x0 -> X+0
;           line -> X-4
_GLCD_ConsoleEraseLine::
	.dbline -1
	push X
	mov X,SP
	add SP,3
	.dbline 547
; 
; void GLCD_ConsoleEraseLine(BYTE line)
; {
	.dbline 551
; 	BYTE x0, x1;
; 	BYTE chipsel;
; 			
; 	x0=GLCD_ConsoleLeft*5;
	mov REG[0xd0],>_GLCD_ConsoleLeft
	mov A,[_GLCD_ConsoleLeft]
	mov REG[0xe8],A
	mov REG[0xe9],5
	nop
	mov A,REG[0xeb]
	mov [X+0],A
	.dbline 552
; 	x1=(GLCD_ConsoleLeft+GLCD_ConsoleWidth)*5;
	mov A,[_GLCD_ConsoleLeft]
	mov REG[0xd0],>_GLCD_ConsoleWidth
	add A,[_GLCD_ConsoleWidth]
	mov REG[0xe8],A
	mov REG[0xe9],5
	nop
	mov A,REG[0xeb]
	mov [X+2],A
	.dbline 554
; 	
; 	line=(line+GLCD_ConsoleTop);
	mov REG[0xd0],>_GLCD_ConsoleTop
	mov A,[_GLCD_ConsoleTop]
	add [X-4],A
	.dbline 556
; 
; 	GLCD_SetXAddress(line, CHIPSEL1);
	push X
	mov A,8
	push A
	mov REG[0xd0],>__r0
	mov A,[X-4]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 556
	.dbline 557
; 	GLCD_SetXAddress(line, CHIPSEL2);
	push X
	mov A,4
	push A
	mov REG[0xd0],>__r0
	mov A,[X-4]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 557
	.dbline 559
; 	
; 	if (x0<64)
	cmp [X+0],64
	jnc L128
X26:
	.dbline 560
; 	{
	.dbline 561
; 		GLCD_SetYAddress(x0, CHIPSEL1);
	push X
	mov A,8
	push A
	mov REG[0xd0],>__r0
	mov A,[X+0]
	or A,64
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 561
	.dbline 562
; 		chipsel=CHIPSEL1;
	mov [X+1],8
	.dbline 563
; 	}
	xjmp L131
L128:
	.dbline 565
; 	else
; 	{
	.dbline 566
; 		GLCD_SetYAddress(x0-64,CHIPSEL2);
	push X
	mov A,4
	push A
	mov REG[0xd0],>__r0
	mov A,[X+0]
	sub A,64
	mov [__r0],A
	or [__r0],64
	mov A,[__r0]
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 566
	.dbline 567
; 		chipsel=CHIPSEL2;
	mov [X+1],4
	.dbline 568
; 	}
	xjmp L131
L130:
	.dbline 571
; 			
; 	while (x0<x1)
; 	{
	.dbline 572
; 		GLCD_WriteData(0, chipsel);			
	push X
	mov X,[X+1]
	mov A,0
	xcall _GLCD_WriteData
	pop X
	.dbline 574
; 	
; 		x0++;
	inc [X+0]
	.dbline 575
; 		if (x0==64)
	cmp [X+0],64
	jnz L133
	.dbline 576
; 		{
	.dbline 577
; 			GLCD_SetYAddress(0, CHIPSEL2);
	push X
	mov X,4
	mov A,64
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 577
	.dbline 578
; 			chipsel=CHIPSEL2;
	mov [X+1],4
	.dbline 579
; 		}
L133:
	.dbline 580
L131:
	.dbline 570
	mov A,[X+0]
	cmp A,[X+2]
	jz X27
	jc L130
X27:
	.dbline -2
	.dbline 581
; 	}
; }
L127:
	add SP,-3
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l x1 2 c
	.dbsym l chipsel 1 c
	.dbsym l x0 0 c
	.dbsym l line -4 c
	.dbend
	.dbfunc e GLCD_ConsoleScroll _GLCD_ConsoleScroll fV
;           ymin -> X+14
;           ymax -> X+13
;           line -> X+12
;              y -> X+11
;              b -> X+3
;        bufsize -> X+2
;        chipsel -> X+1
;              i -> X+0
_GLCD_ConsoleScroll::
	.dbline -1
	push X
	mov X,SP
	add SP,15
	.dbline 584
; 
; void GLCD_ConsoleScroll()
; {
	.dbline 593
; 	BYTE line;
; 	BYTE i;
; 	BYTE b[8];
; 	BYTE ymin,ymax;
; 	BYTE bufsize;
; 	BYTE chipsel;
; 	BYTE y;
; 	
; 	ymin=GLCD_ConsoleLeft*5;
	mov REG[0xd0],>_GLCD_ConsoleLeft
	mov A,[_GLCD_ConsoleLeft]
	mov REG[0xe8],A
	mov REG[0xe9],5
	nop
	mov A,REG[0xeb]
	mov [X+14],A
	.dbline 594
; 	ymax=(GLCD_ConsoleLeft+GLCD_ConsoleWidth)*5;
	mov A,[_GLCD_ConsoleLeft]
	mov REG[0xd0],>_GLCD_ConsoleWidth
	add A,[_GLCD_ConsoleWidth]
	mov REG[0xe8],A
	mov REG[0xe9],5
	nop
	mov A,REG[0xeb]
	mov [X+13],A
	.dbline 596
; 	
; 	for (line=GLCD_ConsoleTop;line<(GLCD_ConsoleTop+GLCD_ConsoleHeight);line++)
	mov REG[0xd0],>_GLCD_ConsoleTop
	mov A,[_GLCD_ConsoleTop]
	mov [X+12],A
	xjmp L139
L136:
	.dbline 597
; 		{
	.dbline 599
; 				
; 		y=ymin;
	mov A,[X+14]
	mov [X+11],A
	.dbline 600
; 		bufsize=8;
	mov [X+2],8
	xjmp L141
L140:
	.dbline 602
; 		while (y<ymax)
; 			{
	.dbline 603
; 				GLCD_SetXAddress(line+1, CHIPSEL1);
	push X
	mov A,8
	push A
	mov REG[0xd0],>__r0
	mov A,[X+12]
	add A,1
	mov [__r0],A
	or [__r0],-72
	mov A,[__r0]
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 603
	.dbline 604
; 				GLCD_SetXAddress(line+1, CHIPSEL2);
	push X
	mov A,4
	push A
	mov REG[0xd0],>__r0
	mov A,[X+12]
	add A,1
	mov [__r0],A
	or [__r0],-72
	mov A,[__r0]
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 604
	.dbline 606
; 
; 				if ((y+bufsize)>=ymax)
	mov REG[0xd0],>__r0
	mov A,[X+11]
	add A,[X+2]
	cmp A,[X+13]
	jz X28
	jc L143
X28:
	.dbline 607
; 					bufsize=ymax-y;
	mov REG[0xd0],>__r0
	mov A,[X+13]
	sub A,[X+11]
	mov [X+2],A
L143:
	.dbline 608
; 				if ((y+bufsize)>=64 && y<64)
	mov REG[0xd0],>__r0
	mov A,[X+11]
	add A,[X+2]
	cmp A,64
	jz X29
	jc L145
X29:
	cmp [X+11],64
	jnc L145
X30:
	.dbline 609
; 					bufsize=64-y;
	mov REG[0xd0],>__r0
	mov A,64
	sub A,[X+11]
	mov [X+2],A
L145:
	.dbline 611
; 				
; 				if (y<64)
	cmp [X+11],64
	jnc L147
X31:
	.dbline 612
; 					{
	.dbline 613
; 					chipsel=CHIPSEL1;
	mov [X+1],8
	.dbline 614
; 					GLCD_SetYAddress(y, chipsel);
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X+11]
	or A,64
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 614
	.dbline 615
; 					}
	xjmp L148
L147:
	.dbline 617
; 				else
; 					{
	.dbline 618
; 					chipsel=CHIPSEL2;
	mov [X+1],4
	.dbline 619
; 					GLCD_SetYAddress(y-64, chipsel);
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X+11]
	sub A,64
	mov [__r0],A
	or [__r0],64
	mov A,[__r0]
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 619
	.dbline 620
; 					}
L148:
	.dbline 622
; 				
; 				GLCD_ReadData(chipsel); // dummy read
	push X
	mov A,[X+1]
	xcall _GLCD_ReadData
	mov REG[0xd0],>__r0
	pop X
	.dbline 623
; 				for (i=0;i<bufsize;i++)	
	mov [X+0],0
	xjmp L152
L149:
	.dbline 624
	push X
	mov A,[X+1]
	xcall _GLCD_ReadData
	mov REG[0xd0],>__r0
	pop X
	mov [__r0],A
	mov A,[X+0]
	mov [__r3],A
	mov [__r2],0
	mov [__r5],X
	add [__r5],3
	mov A,[__r5]
	add [__r3],A
	adc [__r2],7
	mov A,[__r2]
	mov REG[0xd5],A
	mov A,[__r0]
	mvi [__r3],A
L150:
	.dbline 623
	inc [X+0]
L152:
	.dbline 623
	mov A,[X+0]
	cmp A,[X+2]
	jz X32
	jc L149
X32:
	.dbline 626
; 					b[i]=GLCD_ReadData(chipsel);
; 					
; 				GLCD_SetXAddress(line, CHIPSEL1);
	push X
	mov A,8
	push A
	mov REG[0xd0],>__r0
	mov A,[X+12]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 626
	.dbline 627
; 				GLCD_SetXAddress(line, CHIPSEL2);
	push X
	mov A,4
	push A
	mov REG[0xd0],>__r0
	mov A,[X+12]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 627
	.dbline 629
; 
; 				if (y<64)
	cmp [X+11],64
	jnc L153
X33:
	.dbline 630
; 					{
	.dbline 631
; 					chipsel=CHIPSEL1;
	mov [X+1],8
	.dbline 632
; 					GLCD_SetYAddress(y, chipsel);
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X+11]
	or A,64
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 632
	.dbline 633
; 					}
	xjmp L154
L153:
	.dbline 635
; 				else
; 					{
	.dbline 636
; 					chipsel=CHIPSEL2;
	mov [X+1],4
	.dbline 637
; 					GLCD_SetYAddress(y-64, chipsel);
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X+11]
	sub A,64
	mov [__r0],A
	or [__r0],64
	mov A,[__r0]
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 637
	.dbline 638
; 					}
L154:
	.dbline 640
; 
; 				for (i=0;i<bufsize;i++)	
	mov [X+0],0
	xjmp L158
L155:
	.dbline 641
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	mov [__r3],X
	add [__r3],3
	mov A,[__r3]
	add [__r1],A
	adc [__r0],7
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	pop X
	xcall _GLCD_WriteData
	pop X
L156:
	.dbline 640
	inc [X+0]
L158:
	.dbline 640
	mov A,[X+0]
	cmp A,[X+2]
	jz X34
	jc L155
X34:
	.dbline 643
	mov A,[X+2]
	add [X+11],A
	.dbline 644
L141:
	.dbline 601
	mov A,[X+11]
	cmp A,[X+13]
	jz X35
	jc L140
X35:
	.dbline 645
L137:
	.dbline 596
	inc [X+12]
L139:
	.dbline 596
	mov REG[0xd0],>_GLCD_ConsoleTop
	mov A,[_GLCD_ConsoleTop]
	mov REG[0xd0],>_GLCD_ConsoleHeight
	add A,[_GLCD_ConsoleHeight]
	mov REG[0xd0],>__r0
	mov [__r0],A
	mov A,[X+12]
	cmp A,[__r0]
	jz X36
	jc L136
X36:
	.dbline -2
	.dbline 646
; 					GLCD_WriteData(b[i],chipsel);
; 					
; 				y+=bufsize;
; 			}
; 		}
; }
L135:
	add SP,-15
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l ymin 14 c
	.dbsym l ymax 13 c
	.dbsym l line 12 c
	.dbsym l y 11 c
	.dbsym l b 3 A[8:8]c
	.dbsym l bufsize 2 c
	.dbsym l chipsel 1 c
	.dbsym l i 0 c
	.dbend
	.dbfunc e GLCD_DrawRow _GLCD_DrawRow fV
;    currentchip -> X+1
;            cnt -> X+0
;            len -> X-8
;           data -> X-7
;              y -> X-5
;              x -> X-4
_GLCD_DrawRow::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 649
; 
; void GLCD_DrawRow(BYTE x, BYTE y, BYTE *data, BYTE len)
; {
	.dbline 650
; 	BYTE cnt=0;
	mov [X+0],0
	.dbline 654
; 	BYTE currentchip;
; 	
; 	// Convert given coordinates into LCD's coordinates:
; 	cnt=y;
	mov A,[X-5]
	mov [X+0],A
	.dbline 655
; 	y=x;
	mov A,[X-4]
	mov [X-5],A
	.dbline 656
; 	x=cnt/8;
	mov A,8
	push A
	mov A,[X+0]
	push A
	mov REG[0xd0],>__r0
	xcall __divmodu_8X8_8
	pop A
	mov [X-4],A
	add SP,-1
	.dbline 658
; 	
; 	if (y<64)
	cmp [X-5],64
	jnc L160
X37:
	.dbline 659
; 		{
	.dbline 660
; 		GLCD_SetYAddress(y, CHIPSEL1);
	push X
	mov A,8
	push A
	mov REG[0xd0],>__r0
	mov A,[X-5]
	or A,64
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 660
	.dbline 661
; 		currentchip=CHIPSEL1;
	mov [X+1],8
	.dbline 662
; 		}
	xjmp L161
L160:
	.dbline 664
; 	else
; 		{
	.dbline 665
; 		GLCD_SetYAddress(y-64, CHIPSEL2);
	push X
	mov A,4
	push A
	mov REG[0xd0],>__r0
	mov A,[X-5]
	sub A,64
	mov [__r0],A
	or [__r0],64
	mov A,[__r0]
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 665
	.dbline 666
; 		currentchip=CHIPSEL2;
	mov [X+1],4
	.dbline 667
; 		}
L161:
	.dbline 669
; 	
; 	GLCD_SetXAddress(x, currentchip);
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X-4]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 669
	.dbline 671
; 	
; 	for (cnt=0;cnt<len;cnt++)
	mov [X+0],0
	xjmp L165
L162:
	.dbline 672
; 	{
	.dbline 673
; 		if (y>=0 && y<128)
	cmp [X-5],0
	jz X38
	jc L166
X38:
	cmp [X-5],-128
	jnc L166
X39:
	.dbline 674
; 			GLCD_WriteData(data[cnt], currentchip);
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	mov A,[X-6]
	add [__r1],A
	mov A,[X-7]
	adc [__r0],A
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	pop X
	xcall _GLCD_WriteData
	pop X
L166:
	.dbline 676
; 
; 		y++;
	inc [X-5]
	.dbline 677
; 		if (y==64)
	cmp [X-5],64
	jnz L168
	.dbline 678
; 			{
	.dbline 679
; 			GLCD_SetYAddress(0, CHIPSEL2);
	push X
	mov X,4
	mov A,64
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 679
	.dbline 680
; 			currentchip=CHIPSEL2;
	mov [X+1],4
	.dbline 681
; 			GLCD_SetXAddress(x, currentchip);
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X-4]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 681
	.dbline 682
; 			}
L168:
	.dbline 683
L163:
	.dbline 671
	inc [X+0]
L165:
	.dbline 671
	mov A,[X+0]
	cmp A,[X-8]
	jz X40
	jc L162
X40:
	.dbline -2
	.dbline 684
; 	}
; }
L159:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l currentchip 1 c
	.dbsym l cnt 0 c
	.dbsym l len -8 c
	.dbsym l data -7 pc
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
	.dbfunc e GLCD_ReadRow _GLCD_ReadRow fV
;    currentchip -> X+1
;            cnt -> X+0
;            len -> X-8
;           data -> X-7
;              y -> X-5
;              x -> X-4
_GLCD_ReadRow::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 688
; 
; 
; void GLCD_ReadRow(BYTE x, BYTE y, BYTE *data, BYTE len)
; {
	.dbline 689
; 	BYTE cnt=0;
	mov [X+0],0
	.dbline 693
; 	BYTE currentchip;
; 	
; 	// Convert given coordinates into LCD's coordinates:
; 	cnt=y;
	mov A,[X-5]
	mov [X+0],A
	.dbline 694
; 	y=x;
	mov A,[X-4]
	mov [X-5],A
	.dbline 695
; 	x=cnt/8;
	mov A,8
	push A
	mov A,[X+0]
	push A
	mov REG[0xd0],>__r0
	xcall __divmodu_8X8_8
	pop A
	mov [X-4],A
	add SP,-1
	.dbline 697
; 	
; 	if (y<64)
	cmp [X-5],64
	jnc L171
X41:
	.dbline 698
; 		{
	.dbline 699
; 		GLCD_SetYAddress(y, CHIPSEL1);
	push X
	mov A,8
	push A
	mov REG[0xd0],>__r0
	mov A,[X-5]
	or A,64
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 699
	.dbline 700
; 		currentchip=CHIPSEL1;
	mov [X+1],8
	.dbline 701
; 		}
	xjmp L172
L171:
	.dbline 703
; 	else
; 		{
	.dbline 704
; 		GLCD_SetYAddress(y-64, CHIPSEL2);
	push X
	mov A,4
	push A
	mov REG[0xd0],>__r0
	mov A,[X-5]
	sub A,64
	mov [__r0],A
	or [__r0],64
	mov A,[__r0]
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 704
	.dbline 705
; 		currentchip=CHIPSEL2;
	mov [X+1],4
	.dbline 706
; 		}
L172:
	.dbline 708
; 	
; 	GLCD_SetXAddress(x, currentchip);
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X-4]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 708
	.dbline 709
; 	GLCD_ReadData(currentchip); // dummy read
	push X
	mov A,[X+1]
	xcall _GLCD_ReadData
	mov REG[0xd0],>__r0
	pop X
	.dbline 711
; 	
; 	for (cnt=0;cnt<len;cnt++)
	mov [X+0],0
	xjmp L176
L173:
	.dbline 712
; 	{
	.dbline 713
; 		if (y>=0 && y<128)
	cmp [X-5],0
	jz X42
	jc L177
X42:
	cmp [X-5],-128
	jnc L177
X43:
	.dbline 714
; 			data[cnt]=GLCD_ReadData(currentchip);
	push X
	mov A,[X+1]
	xcall _GLCD_ReadData
	mov REG[0xd0],>__r0
	pop X
	mov [__r0],A
	mov A,[X+0]
	mov [__r3],A
	mov [__r2],0
	mov A,[X-6]
	add [__r3],A
	mov A,[X-7]
	adc [__r2],A
	mov A,[__r2]
	mov REG[0xd5],A
	mov A,[__r0]
	mvi [__r3],A
L177:
	.dbline 716
; 
; 		y++;
	inc [X-5]
	.dbline 717
; 		if (y==64)
	cmp [X-5],64
	jnz L179
	.dbline 718
; 			{
	.dbline 719
; 			GLCD_SetYAddress(0, CHIPSEL2);
	push X
	mov X,4
	mov A,64
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 719
	.dbline 720
; 			currentchip=CHIPSEL2;
	mov [X+1],4
	.dbline 721
; 			GLCD_SetXAddress(x, currentchip);
	push X
	mov A,[X+1]
	push A
	mov REG[0xd0],>__r0
	mov A,[X-4]
	or A,-72
	pop X
	xcall _GLCD_WriteInstruction
	pop X
	.dbline 721
	.dbline 722
; 			GLCD_ReadData(currentchip); // dummy read
	push X
	mov A,[X+1]
	xcall _GLCD_ReadData
	mov REG[0xd0],>__r0
	pop X
	.dbline 723
; 			}
L179:
	.dbline 724
L174:
	.dbline 711
	inc [X+0]
L176:
	.dbline 711
	mov A,[X+0]
	cmp A,[X-8]
	jz X44
	jc L173
X44:
	.dbline -2
	.dbline 725
; 	}
; }
L170:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l currentchip 1 c
	.dbsym l cnt 0 c
	.dbsym l len -8 c
	.dbsym l data -7 pc
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
